/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api.marshaller;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.nuxeo.client.api.ConstantsV1;
import org.nuxeo.client.api.marshaller.NuxeoMarshaller;
import org.nuxeo.client.internals.spi.NuxeoClientException;
import retrofit2.Converter;

public final class NuxeoRequestConverterFactory<T>
implements Converter<T, RequestBody> {
    protected JavaType javaType;
    protected ObjectWriter adapter;
    protected final ObjectMapper objectMapper;
    protected NuxeoMarshaller<T> nuxeoMarshaller;

    NuxeoRequestConverterFactory(ObjectWriter adapter, ObjectMapper objectMapper, JavaType javaType) {
        this.adapter = adapter;
        this.objectMapper = objectMapper;
        this.javaType = javaType;
    }

    NuxeoRequestConverterFactory(NuxeoMarshaller<T> nuxeoMarshaller, ObjectMapper objectMapper) {
        this.nuxeoMarshaller = nuxeoMarshaller;
        this.objectMapper = objectMapper;
    }

    public RequestBody convert(T value) throws IOException {
        byte[] bytes;
        ByteArrayBuilder bb = new ByteArrayBuilder();
        if (this.nuxeoMarshaller != null) {
            JsonGenerator jg = this.objectMapper.getFactory().createGenerator((OutputStream)bb, JsonEncoding.UTF8);
            this.nuxeoMarshaller.write(jg, value);
            bytes = bb.toByteArray();
        } else {
            bytes = this.adapter.writeValueAsBytes(value);
        }
        return RequestBody.create((MediaType)ConstantsV1.APPLICATION_JSON_CHARSET_UTF_8, (byte[])bytes);
    }

    public String writeJSON(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (IOException reason) {
            throw new NuxeoClientException("Converter Write Issue. See NuxeoRequestConverterFactory#writeJSON", reason);
        }
    }
}

