/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api.methods;

import okhttp3.ResponseBody;
import org.nuxeo.client.api.objects.Document;
import org.nuxeo.client.api.objects.Documents;
import org.nuxeo.client.api.objects.acl.ACP;
import org.nuxeo.client.api.objects.audit.Audit;
import org.nuxeo.client.api.objects.blob.Blob;
import org.nuxeo.client.api.objects.task.Task;
import org.nuxeo.client.api.objects.workflow.Graph;
import org.nuxeo.client.api.objects.workflow.Workflow;
import org.nuxeo.client.api.objects.workflow.Workflows;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface RepositoryAPI {
    @GET(value="repo/{repositoryName}/path/")
    public Call<Document> fetchDocumentRoot(@Path(value="repositoryName") String var1);

    @GET(value="path/")
    public Call<Document> fetchDocumentRoot();

    @GET(value="repo/{repositoryName}/id/{documentId}")
    public Call<Document> fetchDocumentById(@Path(value="documentId") String var1, @Path(value="repositoryName") String var2);

    @POST(value="repo/{repositoryName}/id/{parentId}")
    public Call<Document> createDocumentById(@Path(value="parentId") String var1, @Body Document var2, @Path(value="repositoryName") String var3);

    @PUT(value="repo/{repositoryName}/id/{documentId}")
    public Call<Document> updateDocument(@Path(value="documentId") String var1, @Body Document var2, @Path(value="repositoryName") String var3);

    @DELETE(value="repo/{repositoryName}/id/{documentId}")
    public Call<ResponseBody> deleteDocument(@Path(value="documentId") String var1, @Path(value="repositoryName") String var2);

    @GET(value="id/{documentId}")
    public Call<Document> fetchDocumentById(@Path(value="documentId") String var1);

    @POST(value="id/{parentId}")
    public Call<Document> createDocumentById(@Path(value="parentId") String var1, @Body Document var2);

    @PUT(value="id/{documentId}")
    public Call<Document> updateDocument(@Path(value="documentId") String var1, @Body Document var2);

    @DELETE(value="id/{documentId}")
    public Call<ResponseBody> deleteDocument(@Path(value="documentId") String var1);

    @GET(value="repo/{repositoryName}/path{docPath}")
    public Call<Document> fetchDocumentByPath(@Path(value="docPath", encoded=true) String var1, @Path(value="repositoryName") String var2);

    @POST(value="repo/{repositoryName}/path{parentPath}")
    public Call<Document> createDocumentByPath(@Path(value="parentPath") String var1, @Body Document var2, @Path(value="repositoryName") String var3);

    @GET(value="path{documentPath}")
    public Call<Document> fetchDocumentByPath(@Path(value="documentPath", encoded=true) String var1);

    @POST(value="path{parentPath}")
    public Call<Document> createDocumentByPath(@Path(value="parentPath", encoded=true) String var1, @Body Document var2);

    @GET(value="query")
    public Call<Documents> query(@Query(value="query") String var1);

    @GET(value="query")
    public Call<Documents> query(@Query(value="query") String var1, @Query(value="pageSize") String var2, @Query(value="currentPageIndex") String var3, @Query(value="maxResults") String var4, @Query(value="sortBy") String var5, @Query(value="sortOrder") String var6, @Query(value="queryParams") String var7);

    @GET(value="query/{providerName}")
    public Call<Documents> queryByProvider(@Path(value="providerName") String var1, @Query(value="pageSize") String var2, @Query(value="currentPageIndex") String var3, @Query(value="maxResults") String var4, @Query(value="sortBy") String var5, @Query(value="sortOrder") String var6, @Query(value="queryParams") String var7);

    @GET(value="path{documentPath}/@audit")
    public Call<Audit> fetchAuditByPath(@Path(value="documentPath", encoded=true) String var1);

    @GET(value="id/{documentId}/@audit")
    public Call<Audit> fetchAuditById(@Path(value="documentId") String var1);

    @GET(value="repo/{repositoryName}/path{documentPath}/@audit")
    public Call<Audit> fetchAuditByPath(@Path(value="documentPath", encoded=true) String var1, @Path(value="repositoryName") String var2);

    @GET(value="repo/{repositoryName}/id/{documentId}/@audit")
    public Call<Audit> fetchAuditById(@Path(value="documentId") String var1, @Path(value="repositoryName") String var2);

    @GET(value="path{documentPath}/@acl")
    public Call<ACP> fetchPermissionsByPath(@Path(value="documentPath", encoded=true) String var1);

    @GET(value="id/{documentId}/@acl")
    public Call<ACP> fetchPermissionsById(@Path(value="documentId") String var1);

    @GET(value="repo/{repositoryName}/path{documentPath}/@acl")
    public Call<ACP> fetchPermissionsByPath(@Path(value="documentPath", encoded=true) String var1, @Path(value="repositoryName") String var2);

    @GET(value="repo/{repositoryName}/id/{documentId}/@acl")
    public Call<ACP> fetchPermissionsById(@Path(value="documentId") String var1, @Path(value="repositoryName") String var2);

    @GET(value="path{parentPath}/@children")
    public Call<Documents> fetchChildrenByPath(@Path(value="parentPath", encoded=true) String var1);

    @GET(value="id/{parentId}/@children")
    public Call<Documents> fetchChildrenById(@Path(value="parentId") String var1);

    @GET(value="repo/{repositoryName}/path{parentPath}/@children")
    public Call<Documents> fetchChildrenByPath(@Path(value="parentPath", encoded=true) String var1, @Path(value="repositoryName") String var2);

    @GET(value="repo/{repositoryName}/id/{parentId}/@children")
    public Call<Documents> fetchChildrenById(@Path(value="parentId") String var1, @Path(value="repositoryName") String var2);

    @GET(value="path{documentPath}/@blob/{fieldPath}")
    public Call<Blob> fetchBlobByPath(@Path(value="documentPath", encoded=true) String var1, @Path(value="fieldPath", encoded=true) String var2);

    @GET(value="id/{documentId}/@blob/{fieldPath}")
    public Call<Blob> fetchBlobById(@Path(value="documentId") String var1, @Path(value="fieldPath", encoded=true) String var2);

    @GET(value="repo/{repositoryName}/path{documentPath}/@blob/{fieldPath}")
    public Call<Blob> fetchBlobByPath(@Path(value="documentPath", encoded=true) String var1, @Path(value="fieldPath", encoded=true) String var2, @Path(value="repositoryName") String var3);

    @GET(value="repo/{repositoryName}/id/{documentId}/@blob/{fieldPath}")
    public Call<Blob> fetchBlobById(@Path(value="documentId") String var1, @Path(value="fieldPath", encoded=true) String var2, @Path(value="repositoryName") String var3);

    @POST(value="id/{documentId}/@workflow")
    public Call<Workflow> startWorkflowInstanceWithDocId(@Path(value="documentId") String var1, @Body Workflow var2);

    @POST(value="repo/{repositoryName}/id/{documentId}/@workflow")
    public Call<Workflow> startWorkflowInstanceWithDocId(@Path(value="documentId") String var1, @Body Workflow var2, @Path(value="repositoryName") String var3);

    @POST(value="path{documentPath}/@workflow")
    public Call<Workflow> startWorkflowInstanceWithDocPath(@Path(value="documentPath", encoded=true) String var1, @Body Workflow var2);

    @POST(value="repo/{repositoryName}/path{documentPath}/@workflow")
    public Call<Workflow> startWorkflowInstanceWithDocPath(@Path(value="documentPath", encoded=true) String var1, @Body Workflow var2, @Path(value="repositoryName") String var3);

    @GET(value="id/{documentId}/@workflow")
    public Call<Workflows> fetchWorkflowInstances(@Path(value="documentId") String var1);

    @GET(value="repo/{repositoryName}/id/{documentId}/@workflow")
    public Call<Workflows> fetchWorkflowInstances(@Path(value="documentId") String var1, @Path(value="repositoryName") String var2);

    @GET(value="path{documentPath}/@workflow")
    public Call<Workflows> fetchWorkflowInstancesByDocPath(@Path(value="documentPath", encoded=true) String var1);

    @GET(value="repo/{repositoryName}/id/{documentId}/@workflow")
    public Call<Workflows> fetchWorkflowInstancesByDocPath(@Path(value="documentPath") String var1, @Path(value="repositoryName") String var2);

    @GET(value="workflow/{workflowInstanceId}")
    public Call<Workflow> fetchWorkflowInstance(@Path(value="workflowInstanceId") String var1);

    @DELETE(value="workflow/{workflowInstanceId}")
    public Call<ResponseBody> cancelWorkflowInstance(@Path(value="workflowInstanceId") String var1);

    @GET(value="workflow/{workflowInstanceId}/graph")
    public Call<Graph> fetchWorkflowInstanceGraph(@Path(value="workflowInstanceId") String var1);

    @GET(value="workflowModel/{workflowModelName}")
    public Call<Workflow> fetchWorkflowModel(@Path(value="workflowModelName") String var1);

    @GET(value="workflowModel/{workflowModelName}/graph")
    public Call<Graph> fetchWorkflowModelGraph(@Path(value="workflowModelName") String var1);

    @GET(value="workflowModel")
    public Call<Workflows> fetchWorkflowModels();

    @GET(value="id/{documentId}/@task")
    public Call<Task> fetchTaskById(@Path(value="documentId") String var1);

    @GET(value="repo/{repositoryName}/id/{documentId}/@task")
    public Call<Task> fetchTaskById(@Path(value="documentId") String var1, @Path(value="repositoryName") String var2);
}

