/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.nuxeo.client.api.NuxeoClient;
import org.nuxeo.client.api.methods.OperationAPI;
import org.nuxeo.client.api.objects.NuxeoEntity;
import org.nuxeo.client.api.objects.blob.Blob;
import org.nuxeo.client.api.objects.blob.Blobs;
import org.nuxeo.client.api.objects.operation.OperationBody;
import retrofit2.Callback;

public class Operation
extends NuxeoEntity {
    public static final String INPUT_PART = "input";
    public static final String INPUT_PARTS = "input#";
    @JsonIgnore
    protected OperationBody body = new OperationBody();
    protected String operationId;

    public Operation(NuxeoClient nuxeoClient) {
        super("operation", nuxeoClient, OperationAPI.class);
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public Operation newRequest(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public Operation input(Object input) {
        this.body.setInput(input);
        return this;
    }

    public Operation param(String key, Object parameter) {
        this.body.getParameters().put(key, parameter);
        return this;
    }

    public Operation context(String key, Object contextValue) {
        this.body.getContext().put(key, contextValue);
        return this;
    }

    public Operation parameters(Map<String, Object> parameters) {
        this.body.setParameters(parameters);
        return this;
    }

    public Operation context(Map<String, Object> context) {
        this.body.setContext(context);
        return this;
    }

    public OperationBody getBody() {
        return this.body;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public <T> T execute(String operationId, OperationBody body) {
        Object input = body.getInput();
        if (input instanceof Blob) {
            ArrayList<MultipartBody.Part> filePart = new ArrayList<MultipartBody.Part>();
            RequestBody fbody = RequestBody.create((MediaType)MediaType.parse((String)((Blob)input).getMimeType()), (File)((Blob)input).getFile());
            filePart.add(MultipartBody.Part.createFormData((String)INPUT_PART, (String)((Blob)input).getFileName(), (RequestBody)fbody));
            return (T)this.getResponse(operationId, body, filePart);
        }
        if (input instanceof Blobs) {
            ArrayList<MultipartBody.Part> fileParts = new ArrayList<MultipartBody.Part>();
            for (int i = 0; i < ((Blobs)input).size(); ++i) {
                Blob fileBlob = ((Blobs)input).getBlobs().get(i);
                RequestBody fbody = RequestBody.create((MediaType)MediaType.parse((String)fileBlob.getMimeType()), (File)fileBlob.getFile());
                fileParts.add(MultipartBody.Part.createFormData((String)(INPUT_PARTS + String.valueOf(i)), (String)fileBlob.getFileName(), (RequestBody)fbody));
            }
            return (T)this.getResponse(operationId, body, fileParts);
        }
        return (T)this.getResponse(operationId, body);
    }

    public <T> T execute(String operationId) {
        return this.execute(operationId, this.body);
    }

    public <T> T execute(String batchId, String fileIdx, String operationId, OperationBody body) {
        return (T)this.getResponse(batchId, fileIdx, operationId, body);
    }

    public <T> T execute() {
        return this.execute(this.operationId, this.body);
    }

    public void execute(String operationId, OperationBody body, Callback<Object> callback) {
        Object input = body.getInput();
        if (input instanceof Blob) {
            HashMap<String, RequestBody> fbodys = new HashMap<String, RequestBody>();
            RequestBody fbody = RequestBody.create((MediaType)MediaType.parse((String)((Blob)input).getMimeType()), (File)((Blob)input).getFile());
            fbodys.put(INPUT_PART, fbody);
            super.execute(callback, operationId, body, fbodys);
        } else if (input instanceof Blobs) {
            HashMap<String, RequestBody> fbodys = new HashMap<String, RequestBody>();
            for (int i = 0; i < ((Blobs)input).size(); ++i) {
                Blob fileBlob = ((Blobs)input).getBlobs().get(i);
                RequestBody fbody = RequestBody.create((MediaType)MediaType.parse((String)fileBlob.getMimeType()), (File)fileBlob.getFile());
                fbodys.put(INPUT_PARTS + String.valueOf(i), fbody);
            }
            super.execute(callback, operationId, body, fbodys);
        } else {
            super.execute(callback, operationId, body);
        }
    }

    public void execute(String operationId, Callback<Object> callback) {
        this.execute(operationId, this.body, callback);
    }

    public void execute(String batchId, String fileIdx, String operationId, OperationBody body, Callback<Object> callback) {
        this.execute(callback, batchId, fileIdx, operationId, body);
    }

    public void execute(Callback<Object> callback) {
        this.execute(this.operationId, this.body, callback);
    }
}

