/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api.objects;

import okhttp3.ResponseBody;
import org.nuxeo.client.api.NuxeoClient;
import org.nuxeo.client.api.methods.RepositoryAPI;
import org.nuxeo.client.api.objects.Document;
import org.nuxeo.client.api.objects.Documents;
import org.nuxeo.client.api.objects.NuxeoEntity;
import org.nuxeo.client.api.objects.acl.ACP;
import org.nuxeo.client.api.objects.audit.Audit;
import org.nuxeo.client.api.objects.blob.Blob;
import org.nuxeo.client.api.objects.workflow.Graph;
import org.nuxeo.client.api.objects.workflow.Workflow;
import org.nuxeo.client.api.objects.workflow.Workflows;
import retrofit2.Callback;

public class Repository
extends NuxeoEntity {
    protected Document root;

    public Repository(NuxeoClient nuxeoClient) {
        super("document", nuxeoClient, RepositoryAPI.class);
    }

    public Repository repositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        return this;
    }

    public Repository refreshCache() {
        this.refreshCache = true;
        return this;
    }

    public Document getDocumentRoot() {
        return this.root;
    }

    public Document fetchDocumentById(String documentId) {
        return (Document)this.getResponse(documentId);
    }

    public Document createDocumentById(String parentId, Document document) {
        return (Document)this.getResponse(parentId, document);
    }

    public Document updateDocument(Document document) {
        document.setProperties(document.getDirtyProperties());
        return (Document)this.getResponse(document.getId(), document);
    }

    public void deleteDocument(Document document) {
        this.getResponse(document.getId());
    }

    public void deleteDocument(String docId) {
        this.getResponse(docId);
    }

    public void fetchDocumentById(String documentId, Callback<Document> callback) {
        this.execute(callback, documentId);
    }

    public void createDocumentById(String parentId, Document document, Callback<Document> callback) {
        this.execute(callback, parentId, document);
    }

    public void updateDocument(Document document, Callback<Document> callback) {
        document.setProperties(document.getDirtyProperties());
        this.execute(callback, document.getId(), document);
    }

    public void deleteDocument(Document document, Callback<ResponseBody> callback) {
        this.execute(callback, document.getId());
    }

    public Document fetchDocumentRoot() {
        this.root = (Document)this.getResponse(new Object[0]);
        return this.root;
    }

    public Document fetchDocumentByPath(String documentPath) {
        return (Document)this.getResponse(documentPath);
    }

    public Document createDocumentByPath(String parentPath, Document document) {
        return (Document)this.getResponse(parentPath, document);
    }

    public void fetchDocumentRoot(Callback<Document> callback) {
        this.execute(callback, new Object[0]);
    }

    public void fetchDocumentByPath(String documentPath, Callback<Document> callback) {
        this.execute(callback, documentPath);
    }

    public void createDocumentByPath(String parentPath, Document document, Callback<Document> callback) {
        this.execute(callback, parentPath, document);
    }

    public Documents query(String query) {
        return (Documents)this.getResponse(query);
    }

    public Documents query(String query, String pageSize, String currentPageIndex, String maxResults, String sortBy, String sortOrder, String queryParams) {
        return (Documents)this.getResponse(query, pageSize, currentPageIndex, maxResults, sortBy, sortOrder, queryParams);
    }

    public Documents queryByProvider(String providerName, String pageSize, String currentPageIndex, String maxResults, String sortBy, String sortOrder, String queryParams) {
        return (Documents)this.getResponse(providerName, pageSize, currentPageIndex, maxResults, sortBy, sortOrder, queryParams);
    }

    public void query(String query, Callback<Documents> callback) {
        this.execute(callback, query);
    }

    public void query(String query, String pageSize, String currentPageIndex, String maxResults, String sortBy, String sortOrder, String queryParams, Callback<Documents> callback) {
        this.execute(callback, query, pageSize, currentPageIndex, maxResults, sortBy, sortOrder, queryParams);
    }

    public void queryByProvider(String providerName, String pageSize, String currentPageIndex, String maxResults, String sortBy, String sortOrder, String queryParams, Callback<Documents> callback) {
        this.execute(callback, providerName, pageSize, currentPageIndex, maxResults, sortBy, sortOrder, queryParams);
    }

    public Audit fetchAuditByPath(String documentPath) {
        return (Audit)this.getResponse(documentPath);
    }

    public Audit fetchAuditById(String documentId) {
        return (Audit)this.getResponse(documentId);
    }

    public void fetchAuditByPath(String documentPath, Callback<Audit> callback) {
        this.execute(callback, documentPath);
    }

    public void fetchAuditById(String documentId, Callback<Audit> callback) {
        this.execute(callback, documentId);
    }

    public ACP fetchACPByPath(String documentPath) {
        return (ACP)this.getResponse(documentPath);
    }

    public ACP fetchACPById(String documentId) {
        return (ACP)this.getResponse(documentId);
    }

    public void fetchACPByPath(String documentPath, Callback<ACP> callback) {
        this.execute(callback, documentPath);
    }

    public void fetchACPById(String documentId, Callback<ACP> callback) {
        this.execute(callback, documentId);
    }

    public Documents fetchChildrenByPath(String parentPath) {
        return (Documents)this.getResponse(parentPath);
    }

    public Documents fetchChildrenById(String parentId) {
        return (Documents)this.getResponse(parentId);
    }

    public void fetchChildrenByPath(String parentPath, Callback<Documents> callback) {
        this.execute(callback, parentPath);
    }

    public void fetchChildrenById(String parentId, Callback<Documents> callback) {
        this.execute(callback, parentId);
    }

    public Blob fetchBlobByPath(String documentPath, String fieldPath) {
        return (Blob)this.getResponse(documentPath, fieldPath);
    }

    public Blob fetchBlobById(String documentId, String fieldPath) {
        return (Blob)this.getResponse(documentId, fieldPath);
    }

    public void fetchBlobByPath(String documentPath, String fieldPath, Callback<Blob> callback) {
        this.execute(callback, documentPath, fieldPath);
    }

    public void fetchBlobById(String documentId, String fieldPath, Callback<Blob> callback) {
        this.execute(callback, documentId, fieldPath);
    }

    public Workflow startWorkflowInstanceWithDocPath(String documentPath, Workflow workflow) {
        return (Workflow)this.getResponse(documentPath, workflow);
    }

    public Workflow startWorkflowInstanceWithDocId(String documentId, Workflow workflow) {
        return (Workflow)this.getResponse(documentId, workflow);
    }

    public Workflows fetchWorkflowInstancesByDocId(String documentId) {
        return (Workflows)this.getResponse(documentId);
    }

    public Workflows fetchWorkflowInstancesByDocPath(String documentPath) {
        return (Workflows)this.getResponse(documentPath);
    }

    public Workflow fetchWorkflowInstance(String workflowInstanceId) {
        return (Workflow)this.getResponse(workflowInstanceId);
    }

    public void cancelWorkflowInstance(String workflowInstanceId) {
        this.getResponse(workflowInstanceId);
    }

    public Graph fetchWorkflowInstanceGraph(String workflowInstanceId) {
        return (Graph)this.getResponse(workflowInstanceId);
    }

    public Graph fetchWorkflowModelGraph(String workflowModelName) {
        return (Graph)this.getResponse(workflowModelName);
    }

    public Workflow fetchWorkflowModel(String workflowModelName) {
        return (Workflow)this.getResponse(workflowModelName);
    }

    public Workflows fetchWorkflowModels() {
        return (Workflows)this.getResponse(new Object[0]);
    }

    public void startWorkflowInstanceWithDocPath(String documentPath, Workflow workflow, Callback<Workflow> callback) {
        this.execute(callback, documentPath, workflow);
    }

    public void startWorkflowInstanceWithDocId(String documentId, Workflow workflow, Callback<Workflow> callback) {
        this.execute(callback, documentId, workflow);
    }

    public void fetchWorkflowInstancesByDocId(String documentId, Callback<Workflow> callback) {
        this.execute(callback, documentId);
    }

    public void fetchWorkflowInstancesByDocPath(String documentPath, Callback<Workflow> callback) {
        this.execute(callback, documentPath);
    }

    public void fetchWorkflowInstance(String workflowInstanceId, Callback<Workflow> callback) {
        this.execute(callback, workflowInstanceId);
    }

    public void deleteWorkflowInstance(String workflowInstanceId, Callback<ResponseBody> callback) {
        this.execute(callback, workflowInstanceId);
    }

    public void fetchWorkflowInstanceGraph(String workflowInstanceId, Callback<Graph> callback) {
        this.execute(callback, workflowInstanceId);
    }

    public void fetchWorkflowModelGraph(String workflowModelName, Callback<Graph> callback) {
        this.execute(callback, workflowModelName);
    }

    public void fetchWorkflowModel(String workflowModelName, Callback<Workflow> callback) {
        this.execute(callback, workflowModelName);
    }

    public void fetchWorkflowModels(Callback<Workflows> callback) {
        this.execute(callback, new Object[0]);
    }
}

