/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api.objects.upload;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.nuxeo.client.api.NuxeoClient;
import org.nuxeo.client.api.methods.BatchUploadAPI;
import org.nuxeo.client.api.objects.NuxeoEntity;
import org.nuxeo.client.api.objects.Operation;
import org.nuxeo.client.api.objects.upload.BatchBlob;
import org.nuxeo.client.api.objects.upload.BatchFile;
import org.nuxeo.client.internals.spi.NuxeoClientException;

public class BatchUpload
extends NuxeoEntity {
    @JsonIgnore
    protected int chunkSize;
    protected String batchId;
    protected String fileIdx;
    protected String uploadType;
    protected long uploadedSize;

    public BatchUpload(NuxeoClient nuxeoClient) {
        super(null, nuxeoClient, BatchUploadAPI.class);
    }

    public BatchUpload() {
        super(null);
    }

    public String getBatchId() {
        return this.batchId;
    }

    public String getFileIdx() {
        return this.fileIdx;
    }

    public String getUploadType() {
        return this.uploadType;
    }

    public long getUploadedSize() {
        return this.uploadedSize;
    }

    public BatchUpload createBatch() {
        return (BatchUpload)this.getResponse(new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BatchUpload upload(String name, long length, String fileType, String batchId, String fileIdx, File file) {
        if (this.chunkSize == 0) {
            RequestBody fbody = RequestBody.create((MediaType)MediaType.parse((String)fileType), (File)file);
            return (BatchUpload)this.getResponse(name, Objects.toString(length), fileType, "normal", "0", "1", batchId, fileIdx, fbody);
        }
        Object response = null;
        int contentLength = 0;
        byte[] buffer = new byte[this.chunkSize];
        int chunkIndex = 0;
        long chunkCount = (file.length() + (long)this.chunkSize - 1L) / (long)this.chunkSize;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            while ((contentLength = bis.read(buffer)) > 0) {
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])buffer, (int)0, (int)contentLength);
                response = this.getResponse(name, Objects.toString(length), fileType, "chunked", Objects.toString(chunkIndex), Objects.toString(chunkCount), batchId, fileIdx, requestBody);
                ++chunkIndex;
            }
            BatchUpload batchUpload = (BatchUpload)response;
            return batchUpload;
        }
        catch (IOException reason) {
            throw new NuxeoClientException(reason);
        }
    }

    public void cancel(String batchId) {
        this.getResponse(batchId);
    }

    public void cancel() {
        this.cancel(this.batchId);
    }

    public List<BatchFile> fetchBatchFiles(String batchId) {
        return (List)this.getResponse(batchId);
    }

    public BatchFile fetchBatchFile(String batchId, String fileIdx) {
        return (BatchFile)this.getResponse(batchId, fileIdx);
    }

    public BatchFile fetchBatchFile(String fileIdx) {
        return this.fetchBatchFile(this.batchId, fileIdx);
    }

    public List<BatchFile> fetchBatchFiles() {
        return this.fetchBatchFiles(this.batchId);
    }

    public BatchBlob getBatchBlob() {
        return this.getBatchBlob(this.batchId, this.fileIdx);
    }

    private BatchBlob getBatchBlob(String batchId, String fileIdx) {
        return new BatchBlob(batchId, fileIdx);
    }

    public BatchUpload chunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public BatchUpload enableChunk() {
        this.chunkSize = 0x100000;
        return this;
    }

    public Object execute(Operation operation) {
        return this.execute(this.batchId, this.fileIdx, operation);
    }

    public Object execute(String batchId, String fileIdx, Operation operation) {
        return this.nuxeoClient.automation().execute(batchId, fileIdx, operation.getOperationId(), operation.getBody());
    }
}

