/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api.objects.user;

import okhttp3.ResponseBody;
import org.nuxeo.client.api.NuxeoClient;
import org.nuxeo.client.api.methods.UserManagerAPI;
import org.nuxeo.client.api.objects.NuxeoEntity;
import org.nuxeo.client.api.objects.user.Group;
import org.nuxeo.client.api.objects.user.Groups;
import org.nuxeo.client.api.objects.user.User;
import org.nuxeo.client.api.objects.user.Users;
import retrofit2.Callback;

public class UserManager
extends NuxeoEntity {
    public UserManager(NuxeoClient nuxeoClient) {
        super(null, nuxeoClient, UserManagerAPI.class);
    }

    public Group fetchGroup(String groupName) {
        return (Group)this.getResponse(groupName);
    }

    public Group updateGroup(String groupName, Group group) {
        return (Group)this.getResponse(groupName, group);
    }

    public Group updateGroup(Group group) {
        return (Group)this.getResponse(group.getGroupName(), group);
    }

    public void deleteGroup(String groupName) {
        this.getResponse(groupName);
    }

    public Group createGroup(Group group) {
        return (Group)this.getResponse(group);
    }

    public Groups searchGroup(String query) {
        return (Groups)this.getResponse(query);
    }

    public Groups searchGroup(String query, int currentPageIndex, int pageSize) {
        return (Groups)this.getResponse(query, currentPageIndex, pageSize);
    }

    public User addUserToGroup(String userName, String groupName) {
        return (User)this.getResponse(groupName, userName);
    }

    public User fetchUser(String userName) {
        return (User)this.getResponse(userName);
    }

    public User updateUser(String userName, User user) {
        return (User)this.getResponse(userName, user);
    }

    public User updateUser(User user) {
        return (User)this.getResponse(user.getUserName(), user);
    }

    public void deleteUser(String userName) {
        this.getResponse(userName);
    }

    public User createUser(User user) {
        return (User)this.getResponse(user);
    }

    public Users searchUser(String query) {
        return (Users)this.getResponse(query);
    }

    public Users searchUser(String query, int currentPageIndex, int pageSize) {
        return (Users)this.getResponse(query, currentPageIndex, pageSize);
    }

    public User attachGroupToUser(String groupName, String userName) {
        return (User)this.getResponse(userName, groupName);
    }

    public void fetchGroup(String groupName, Callback<Group> callback) {
        this.execute(callback, groupName);
    }

    public void updateGroup(String groupName, Group group, Callback<Group> callback) {
        this.execute(callback, groupName, group);
    }

    public void deleteGroup(String groupName, Callback<ResponseBody> callback) {
        this.execute(callback, groupName);
    }

    public void createGroup(Group group, Callback<Group> callback) {
        this.execute(callback, group);
    }

    public void searchGroup(String query, Callback<Groups> callback) {
        this.execute(callback, query);
    }

    public void addUserToGroup(String userName, String groupName, Callback<User> callback) {
        this.execute(callback, groupName, userName);
    }

    public void fetchUser(String userName, Callback<User> callback) {
        this.execute(callback, userName);
    }

    public void updateUser(String userName, User user, Callback<User> callback) {
        this.execute(callback, userName, user);
    }

    public void deleteUser(String userName, Callback<ResponseBody> callback) {
        this.getResponse(userName);
    }

    public void createUser(User user, Callback<User> callback) {
        this.execute(callback, user);
    }

    public void searchUser(String query, Callback<Users> callback) {
        this.execute(callback, query);
    }

    public void attachGroupToUser(String groupName, String userName, Callback<User> callback) {
        this.execute(callback, userName, groupName);
    }
}

