/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.audit.AbstractAuditStorageTest;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.elasticsearch.LogEntryGen;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.audit.ESAuditBackend;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@Deploys(value={@Deploy(value={"org.nuxeo.runtime.metrics"}), @Deploy(value={"org.nuxeo.ecm.platform.audit.api"}), @Deploy(value={"org.nuxeo.ecm.core.persistence"}), @Deploy(value={"org.nuxeo.ecm.platform.audit"}), @Deploy(value={"org.nuxeo.ecm.platform.uidgen.core"}), @Deploy(value={"org.nuxeo.elasticsearch.core"}), @Deploy(value={"org.nuxeo.elasticsearch.seqgen"}), @Deploy(value={"org.nuxeo.elasticsearch.seqgen.test:elasticsearch-seqgen-index-test-contrib.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.audit"}), @Deploy(value={"org.nuxeo.elasticsearch.audit:elasticsearch-audit-index-test-contrib.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.audit:audit-test-contrib.xml"})})
@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
public class TestAuditWithElasticSearch
extends AbstractAuditStorageTest {
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchAdmin esa;
    @Inject
    protected NXAuditEventsService auditEventsService;

    @Before
    public void setupIndex() throws Exception {
        LogEntryGen.flushAndSync();
        this.esa.initIndexes(true);
    }

    @Test
    public void shouldUseESBackend() {
        AuditBackend backend = this.auditEventsService.getBackend();
        Assert.assertNotNull((Object)backend);
        Assert.assertTrue((boolean)(backend instanceof ESAuditBackend));
    }

    @Test
    public void shouldLogInAudit() throws Exception {
        DocumentModel doc = this.session.createDocumentModel("/", "a-file", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"A File"));
        doc = this.session.createDocument(doc);
        LogEntryGen.flushAndSync();
        doc.setPropertyValue("dc:title", (Serializable)((Object)"A modified File"));
        doc = this.session.saveDocument(doc);
        LogEntryGen.flushAndSync();
        AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
        List trail = reader.getLogEntriesFor(doc.getId(), doc.getRepositoryName());
        Assert.assertNotNull((Object)trail);
        Assert.assertEquals((long)2L, (long)trail.size());
        LogEntry entry = (LogEntry)trail.get(0);
        Assert.assertEquals((long)2L, (long)entry.getId());
        Assert.assertEquals((Object)"documentModified", (Object)entry.getEventId());
        Assert.assertEquals((Object)"eventDocumentCategory", (Object)entry.getCategory());
        Assert.assertEquals((Object)"A modified File", (Object)((ExtendedInfo)entry.getExtendedInfos().get("title")).getValue(String.class));
        entry = (LogEntry)trail.get(1);
        Assert.assertEquals((long)1L, (long)entry.getId());
        Assert.assertEquals((Object)"documentCreated", (Object)entry.getEventId());
        Assert.assertEquals((Object)"eventDocumentCategory", (Object)entry.getCategory());
        Assert.assertEquals((Object)"A File", (Object)((ExtendedInfo)entry.getExtendedInfos().get("title")).getValue(String.class));
        LogEntry entryById = reader.getLogEntryByID(entry.getId());
        Assert.assertEquals((long)entry.getId(), (long)entryById.getId());
        entryById = reader.getLogEntryByID(123L);
        Assert.assertNull((Object)entryById);
        AuditBackend backend = this.auditEventsService.getBackend();
        Assert.assertEquals((long)1L, (long)backend.getEventsCount(entry.getEventId()));
    }

    @Test
    public void shouldSupportMultiCriteriaQueries() throws Exception {
        LogEntryGen.generate("mydoc", "evt", "cat", 9);
        AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
        String[] evts = new String[]{"evt1", "evt2"};
        List res = reader.queryLogs(evts, null);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((long)2L, (long)res.size());
        evts = new String[]{"evt1"};
        res = reader.queryLogs(evts, null);
        Assert.assertEquals((long)1L, (long)res.size());
        evts = new String[]{"evt"};
        res = reader.queryLogs(evts, null);
        Assert.assertEquals((long)0L, (long)res.size());
        evts = new String[]{"evt1", "evt2"};
        String[] cats = new String[]{"cat1"};
        res = reader.queryLogsByPage(evts, (Date)null, cats, null, 0, 5);
        Assert.assertEquals((long)1L, (long)res.size());
        evts = new String[]{"evt1", "evt2"};
        cats = new String[]{"cat1", "cat0"};
        res = reader.queryLogsByPage(evts, (Date)null, cats, null, 0, 5);
        Assert.assertEquals((long)2L, (long)res.size());
        res = reader.queryLogsByPage(null, (Date)null, (String[])null, "/mydoc", 0, 5);
        Assert.assertEquals((long)5L, (long)res.size());
        res = reader.queryLogsByPage(null, (Date)null, (String[])null, "/mydoc", 1, 5);
        Assert.assertEquals((long)4L, (long)res.size());
    }

    @Test
    public void shouldSupportNativeQueries() throws Exception {
        LogEntryGen.generate("dummy", "entry", "category", 9);
        AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
        String jsonQuery = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("filtredQuery.json"), (String)"UTF-8");
        List res = reader.nativeQuery(jsonQuery, 0, 5);
        Assert.assertEquals((long)2L, (long)res.size());
        jsonQuery = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("filtredQueryWithParams.json"), (String)"UTF-8");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("category", "category1");
        res = reader.nativeQuery(jsonQuery, params, 0, 5);
        Assert.assertEquals((long)1L, (long)res.size());
    }

    @Test
    public void testGetLatestLogId() throws Exception {
        String repositoryId = "test";
        AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
        LogEntryGen.generate("mydoc", "documentModified", "cat", 1);
        long id1 = reader.getLatestLogId(repositoryId, new String[]{"documentModified0"});
        Assert.assertTrue((String)("id: " + id1), (id1 > 0L ? 1 : 0) != 0);
        LogEntryGen.generate("mydoc", "documentCreated", "cat", 1);
        long id2 = reader.getLatestLogId(repositoryId, new String[]{"documentModified0", "documentCreated0"});
        Assert.assertTrue((String)("id2: " + id2), (id2 > 0L ? 1 : 0) != 0);
        Assert.assertTrue((id2 > id1 ? 1 : 0) != 0);
        long id = reader.getLatestLogId(repositoryId, new String[]{"documentModified0"});
        Assert.assertEquals((long)id1, (long)id);
        id = reader.getLatestLogId(repositoryId, new String[]{"unknown"});
        Assert.assertEquals((long)0L, (long)id);
    }

    @Test
    public void testGetLogEntriesAfter() throws Exception {
        String repositoryId = "test";
        AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
        LogEntryGen.generate("mydoc", "documentModified", "cat", 1);
        long id1 = reader.getLatestLogId(repositoryId, new String[]{"documentModified0"});
        LogEntryGen.generate("mydoc", "documentModified", "cat", 1);
        long id2 = reader.getLatestLogId(repositoryId, new String[]{"documentModified0"});
        Assert.assertTrue((id2 > id1 ? 1 : 0) != 0);
        LogEntryGen.generate("mydoc", "documentModified", "cat", 1);
        long id3 = reader.getLatestLogId(repositoryId, new String[]{"documentModified0"});
        Assert.assertTrue((id3 > id2 ? 1 : 0) != 0);
        LogEntryGen.generate("mydoc", "documentModified", "cat", 1);
        long id4 = reader.getLatestLogId(repositoryId, new String[]{"documentModified0"});
        Assert.assertTrue((id4 > id3 ? 1 : 0) != 0);
        List entries = reader.getLogEntriesAfter(id1, 5, repositoryId, new String[]{"documentCreated0", "documentModified0"});
        Assert.assertEquals((long)4L, (long)entries.size());
        Assert.assertEquals((long)id1, (long)((LogEntry)entries.get(0)).getId());
        entries = reader.getLogEntriesAfter(id2, 2, repositoryId, new String[]{"documentCreated0", "documentModified0"});
        Assert.assertEquals((long)2L, (long)entries.size());
        Assert.assertEquals((long)id2, (long)((LogEntry)entries.get(0)).getId());
        Assert.assertEquals((long)id3, (long)((LogEntry)entries.get(1)).getId());
    }

    @Test
    public void testStartsWith() throws Exception {
        super.testStartsWith();
        this.assertStartsWithCount(0, "/is/eve");
        this.assertStartsWithCount(0, "/is/od");
    }

    protected void flush() throws Exception {
        LogEntryGen.flushAndSync();
    }
}

