/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import java.io.Serializable;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.impl.ExtendedInfoImpl;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.elasticsearch.LogEntryGen;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.TransactionalFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.platform.audit.api"}), @Deploy(value={"org.nuxeo.runtime.metrics"}), @Deploy(value={"org.nuxeo.ecm.platform.audit"}), @Deploy(value={"org.nuxeo.ecm.platform.uidgen.core"}), @Deploy(value={"org.nuxeo.elasticsearch.core"}), @Deploy(value={"org.nuxeo.elasticsearch.seqgen"}), @Deploy(value={"org.nuxeo.elasticsearch.audit"}), @Deploy(value={"org.nuxeo.admin.center"}), @Deploy(value={"org.nuxeo.elasticsearch.seqgen.test:elasticsearch-seqgen-index-test-contrib.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.audit:elasticsearch-test-contrib.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.audit:elasticsearch-audit-index-test-contrib.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.audit:audit-test-contrib.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.audit:es-audit-pageprovider-test-contrib.xml"})})
public class TestESHistoryProvider {
    private static final Logger log = LogManager.getLogger(TestESHistoryProvider.class);
    public static final String CUSTOM_HISTORY_VIEW = "CUSTOM_HISTORY_VIEW";
    @Inject
    protected CoreSession session;
    @Inject
    protected PageProviderService pageProviderService;
    @Inject
    protected TransactionalFeature transactionalFeature;
    @Inject
    protected AuditReader auditReader;
    @Inject
    protected AuditLogger auditLogger;
    @Inject
    protected ElasticSearchAdmin esa;
    protected DocumentModel folder;
    protected DocumentModel doc;
    protected DocumentModel proxy;
    protected List<DocumentModel> versions;
    protected Date t1;
    protected Date t2;

    @Before
    public void before() throws Exception {
        LogEntryGen.flushAndSync();
        this.esa.initIndexes(true);
        this.createTestEntries();
    }

    protected void createTestEntries() throws Exception {
        int i;
        this.folder = this.session.createDocumentModel("/", "section", "Folder");
        this.folder = this.session.createDocument(this.folder);
        this.doc = this.session.createDocumentModel("/", "doc", "File");
        this.doc.setPropertyValue("dc:title", (Serializable)((Object)"TestDoc"));
        this.doc = this.session.createDocument(this.doc);
        Thread.sleep(500L);
        this.t1 = Date.from(Instant.now());
        Thread.sleep(600L);
        for (i = 0; i < 5; ++i) {
            this.doc.setPropertyValue("dc:description", (Serializable)((Object)("Update " + i)));
            this.doc.putContextData("comment", (Serializable)((Object)("Update " + i)));
            this.doc = this.session.saveDocument(this.doc);
        }
        Thread.sleep(600L);
        this.t2 = Date.from(Instant.now());
        Thread.sleep(500L);
        this.doc.putContextData("VersioningOption", (Serializable)VersioningOption.MINOR);
        this.doc = this.session.saveDocument(this.doc);
        Thread.sleep(1100L);
        for (i = 5; i < 10; ++i) {
            this.doc.setPropertyValue("dc:description", (Serializable)((Object)("Update " + i)));
            this.doc.putContextData("comment", (Serializable)((Object)("Update " + i)));
            this.doc = this.session.saveDocument(this.doc);
        }
        Thread.sleep(1100L);
        this.proxy = this.session.publishDocument(this.doc, this.folder);
        Thread.sleep(1100L);
        for (i = 10; i < 15; ++i) {
            this.doc.setPropertyValue("dc:description", (Serializable)((Object)("Update " + i)));
            this.doc.putContextData("comment", (Serializable)((Object)("Update " + i)));
            this.doc = this.session.saveDocument(this.doc);
        }
        Thread.sleep(500L);
        this.versions = this.session.getVersions(this.doc.getRef());
        Assert.assertEquals((long)2L, (long)this.versions.size());
        for (DocumentModel version : this.versions) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)version).getId();
            log.trace("version: {}", supplierArray);
            Supplier[] supplierArray2 = new Supplier[1];
            supplierArray2[0] = () -> ((DocumentModel)version).getVersionSeriesId();
            log.trace("version series: {}", supplierArray2);
            Supplier[] supplierArray3 = new Supplier[1];
            supplierArray3[0] = () -> ((DocumentModel)version).getVersionLabel();
            log.trace("version label: {}", supplierArray3);
            log.trace("version date: {}", new Supplier[]{() -> ((Calendar)version.getPropertyValue("dc:modified")).getTime()});
        }
        LogEntryGen.flushAndSync();
        LogEntryImpl createdEntry = new LogEntryImpl();
        createdEntry.setEventId("bonusEvent");
        createdEntry.setCategory("bonusCategory");
        createdEntry.setDocUUID(this.doc.getId());
        createdEntry.setEventDate(new Date());
        createdEntry.setDocPath(this.doc.getPathAsString());
        createdEntry.setRepositoryId("test");
        HashMap<String, ExtendedInfoImpl.StringInfo> extendedInfos = new HashMap<String, ExtendedInfoImpl.StringInfo>();
        extendedInfos.put("reason", new ExtendedInfoImpl.StringInfo("test"));
        createdEntry.setExtendedInfos(extendedInfos);
        this.auditLogger.addLogEntries(List.of(createdEntry));
        LogEntryGen.flushAndSync();
        this.transactionalFeature.nextTransaction();
        List logs = this.auditReader.getLogEntriesFor(this.doc.getId(), this.doc.getRepositoryName());
        logs.forEach(entry -> log.trace("LogEntry: {}", entry));
    }

    @Test
    public void testDocumentHistoryPageProvider() {
        List entries;
        PageProvider<LogEntry> pageProvider;
        Assert.assertNotNull((Object)this.pageProviderService.getPageProviderDefinition("DOCUMENT_HISTORY_PROVIDER"));
        long startIdx = 0L;
        DocumentModel searchDoc = this.session.createDocumentModel("BasicAuditSearch");
        searchDoc.setPathInfo("/", "auditsearch");
        searchDoc = this.session.createDocument(searchDoc);
        Map<String, DocumentModel> pageProviderConf = Map.of("DOCUMENT_HISTORY_PROVIDER_OLD", this.doc.getId(), "DOCUMENT_HISTORY_PROVIDER", this.doc);
        for (Map.Entry<String, DocumentModel> entry2 : pageProviderConf.entrySet()) {
            pageProvider = this.getPageProvider(entry2.getKey(), 20, 0, entry2.getValue());
            Assert.assertNotNull(pageProvider);
            searchDoc.setPropertyValue("basicauditsearch:eventIds", null);
            searchDoc.setPropertyValue("basicauditsearch:eventCategories", null);
            searchDoc.setPropertyValue("basicauditsearch:startDate", null);
            searchDoc.setPropertyValue("basicauditsearch:endDate", null);
            pageProvider.setSearchDocumentModel(searchDoc);
            entries = pageProvider.getCurrentPage();
            log.trace("Live doc history");
            entries.forEach(e -> log.trace("LogEntry: {}", e));
            Assert.assertEquals((long)20L, (long)entries.size());
            startIdx = ((LogEntry)entries.get(0)).getId();
            searchDoc.setPropertyValue("basicauditsearch:eventIds", (Serializable)new String[]{"documentModified"});
            searchDoc.setPropertyValue("basicauditsearch:eventCategories", null);
            pageProvider.setSearchDocumentModel(searchDoc);
            entries = pageProvider.getCurrentPage();
            Assert.assertEquals((long)16L, (long)entries.size());
            searchDoc.setPropertyValue("basicauditsearch:eventIds", null);
            searchDoc.setPropertyValue("basicauditsearch:eventCategories", (Serializable)new String[]{"eventDocumentCategory"});
            pageProvider.setSearchDocumentModel(searchDoc);
            entries = pageProvider.getCurrentPage();
            Assert.assertEquals((long)19L, (long)entries.size());
            searchDoc.setPropertyValue("basicauditsearch:eventIds", null);
            searchDoc.setPropertyValue("basicauditsearch:eventCategories", (Serializable)new String[]{"eventDocumentCategory", "bonusCategory"});
            pageProvider.setSearchDocumentModel(searchDoc);
            entries = pageProvider.getCurrentPage();
            Assert.assertEquals((long)20L, (long)entries.size());
            searchDoc.setPropertyValue("basicauditsearch:eventIds", null);
            searchDoc.setPropertyValue("basicauditsearch:eventCategories", null);
            searchDoc.setPropertyValue("basicauditsearch:startDate", (Serializable)this.t1);
            searchDoc.setPropertyValue("basicauditsearch:endDate", (Serializable)this.t2);
            pageProvider.setSearchDocumentModel(searchDoc);
            entries = pageProvider.getCurrentPage();
            Assert.assertEquals((long)5L, (long)entries.size());
        }
        searchDoc.setPropertyValue("basicauditsearch:eventIds", null);
        searchDoc.setPropertyValue("basicauditsearch:eventCategories", null);
        searchDoc.setPropertyValue("basicauditsearch:startDate", null);
        searchDoc.setPropertyValue("basicauditsearch:endDate", null);
        pageProvider = this.getPageProvider("DOCUMENT_HISTORY_PROVIDER", 30, 0, this.proxy);
        pageProvider.setSearchDocumentModel(searchDoc);
        entries = pageProvider.getCurrentPage();
        log.trace("Proxy doc history");
        entries.forEach(entry -> log.trace("LogEntry: {}", entry));
        int proxyEntriesCount = 16;
        Assert.assertEquals((long)proxyEntriesCount, (long)entries.size());
        Assert.assertEquals((long)startIdx, (long)((LogEntry)entries.get(0)).getId());
        Assert.assertEquals((long)(startIdx + (long)proxyEntriesCount + 1L), (long)((LogEntry)entries.get(proxyEntriesCount - 1)).getId());
        pageProvider = this.getPageProvider("DOCUMENT_HISTORY_PROVIDER", 20, 0, this.versions.get(0));
        pageProvider.setSearchDocumentModel(searchDoc);
        entries = pageProvider.getCurrentPage();
        log.trace("Version {} doc history", new Supplier[]{() -> this.versions.get(0).getVersionLabel()});
        entries.forEach(e -> log.trace("LogEntry: {}", e));
        int version1EntriesCount = 9;
        if (version1EntriesCount == entries.size()) {
            Assert.assertEquals((long)startIdx, (long)((LogEntry)entries.get(0)).getId());
            Assert.assertEquals((long)(startIdx + (long)version1EntriesCount - 1L), (long)((LogEntry)entries.get(version1EntriesCount - 1)).getId());
        } else {
            Assert.assertEquals((long)(version1EntriesCount - 1), (long)entries.size());
        }
        pageProvider = this.getPageProvider("DOCUMENT_HISTORY_PROVIDER", 20, 0, this.versions.get(1));
        pageProvider.setSearchDocumentModel(searchDoc);
        entries = pageProvider.getCurrentPage();
        log.trace("Version {} doc history", new Supplier[]{() -> this.versions.get(1).getVersionLabel()});
        entries.forEach(e -> log.trace("LogEntry: {}", e));
        int version2EntriesCount = 15;
        Assert.assertEquals((long)version2EntriesCount, (long)entries.size());
        Assert.assertEquals((long)startIdx, (long)((LogEntry)entries.get(0)).getId());
        Assert.assertEquals((long)(startIdx + (long)version2EntriesCount), (long)((LogEntry)entries.get(version2EntriesCount - 1)).getId());
    }

    @Test
    public void testCustomDocumentHistoryPageProvider() {
        Assert.assertNotNull((Object)this.pageProviderService.getPageProviderDefinition(CUSTOM_HISTORY_VIEW));
        DocumentModel searchDoc = this.session.createDocumentModel("BasicAuditSearch");
        searchDoc.setPathInfo("/", "auditsearch");
        searchDoc = this.session.createDocument(searchDoc);
        searchDoc.setPropertyValue("basicauditsearch:eventIds", null);
        searchDoc.setPropertyValue("basicauditsearch:eventCategories", null);
        searchDoc.setPropertyValue("basicauditsearch:startDate", null);
        searchDoc.setPropertyValue("basicauditsearch:endDate", null);
        PageProvider<LogEntry> pageProvider = this.getPageProvider(CUSTOM_HISTORY_VIEW, 26, 0, "/");
        List entries = pageProvider.getCurrentPage();
        entries.forEach(entry -> log.trace("LogEntry: {}", entry));
        Assert.assertEquals((long)26L, (long)entries.size());
        pageProvider = this.getPageProvider(CUSTOM_HISTORY_VIEW, 4, 0, "/s");
        entries = pageProvider.getCurrentPage();
        Assert.assertEquals((long)4L, (long)entries.size());
        Assert.assertEquals((long)1L, (long)entries.stream().map(LogEntry::getDocUUID).distinct().filter(this.folder.getId()::equals).count());
        Assert.assertEquals((long)1L, (long)entries.stream().map(LogEntry::getDocUUID).distinct().filter(this.proxy.getId()::equals).count());
        Optional<String> optional = entries.stream().map(LogEntry::getDocUUID).distinct().findAny();
        Assert.assertEquals((Object)this.folder.getId(), (Object)optional.get());
        pageProvider = this.getPageProvider(CUSTOM_HISTORY_VIEW, 26, 0, "/d");
        entries = pageProvider.getCurrentPage();
        Assert.assertEquals((long)22L, (long)entries.size());
        Assert.assertEquals((long)1L, (long)entries.stream().map(LogEntry::getDocUUID).distinct().filter(this.doc.getId()::equals).count());
        Assert.assertEquals((long)1L, (long)entries.stream().map(LogEntry::getDocUUID).distinct().filter(this.versions.get(0).getId()::equals).count());
        Assert.assertEquals((long)1L, (long)entries.stream().map(LogEntry::getDocUUID).distinct().filter(this.versions.get(1).getId()::equals).count());
        searchDoc.setPropertyValue("basicauditsearch:eventIds", (Serializable)new String[]{"documentModified"});
        searchDoc.setPropertyValue("basicauditsearch:eventCategories", null);
        pageProvider.setSearchDocumentModel(searchDoc);
        entries = pageProvider.getCurrentPage();
        Assert.assertEquals((long)16L, (long)entries.size());
        searchDoc.setPropertyValue("basicauditsearch:eventIds", null);
        searchDoc.setPropertyValue("basicauditsearch:eventCategories", (Serializable)new String[]{"eventDocumentCategory"});
        pageProvider.setSearchDocumentModel(searchDoc);
        entries = pageProvider.getCurrentPage();
        Assert.assertEquals((long)21L, (long)entries.size());
        searchDoc.setPropertyValue("basicauditsearch:eventIds", null);
        searchDoc.setPropertyValue("basicauditsearch:eventCategories", (Serializable)new String[]{"bonusCategory"});
        pageProvider.setSearchDocumentModel(searchDoc);
        entries = pageProvider.getCurrentPage();
        Assert.assertEquals((long)1L, (long)entries.size());
        searchDoc.setPropertyValue("basicauditsearch:eventIds", null);
        searchDoc.setPropertyValue("basicauditsearch:eventCategories", null);
        searchDoc.setPropertyValue("basicauditsearch:startDate", (Serializable)this.t1);
        searchDoc.setPropertyValue("basicauditsearch:endDate", (Serializable)this.t2);
        pageProvider.setSearchDocumentModel(searchDoc);
        entries = pageProvider.getCurrentPage();
        Assert.assertEquals((long)5L, (long)entries.size());
    }

    @Test
    public void testCustomFixedPartDocumentHistoryPageProvider() {
        Assert.assertNotNull((Object)this.pageProviderService.getPageProviderDefinition("FIXED_PART_DOCUMENT_HISTORY_PROVIDER"));
        DocumentModel searchDoc = this.session.createDocumentModel("BasicAuditSearch");
        searchDoc.setPathInfo("/", "auditsearch");
        searchDoc = this.session.createDocument(searchDoc);
        searchDoc.setPropertyValue("basicauditsearch:eventIds", null);
        searchDoc.setPropertyValue("basicauditsearch:eventCategories", null);
        searchDoc.setPropertyValue("basicauditsearch:startDate", null);
        searchDoc.setPropertyValue("basicauditsearch:endDate", null);
        PageProvider<LogEntry> pageProvider = this.getPageProvider("FIXED_PART_DOCUMENT_HISTORY_PROVIDER", 30, 0, this.doc);
        pageProvider.setSearchDocumentModel(searchDoc);
        Assert.assertEquals((long)1L, (long)pageProvider.getCurrentPage().size());
        pageProvider = this.getPageProvider("FIXED_PART_DOCUMENT_HISTORY_PROVIDER", 30, 0, this.proxy);
        pageProvider.setSearchDocumentModel(searchDoc);
        Assert.assertTrue((boolean)pageProvider.getCurrentPage().isEmpty());
    }

    protected PageProvider<LogEntry> getPageProvider(String name, int pageSize, int currentPage, Object ... parameters) {
        List<SortInfo> sorters = List.of(new SortInfo("id", true));
        PageProvider pageProvider = this.pageProviderService.getPageProvider(name, sorters, Long.valueOf(pageSize), Long.valueOf(currentPage), Map.of(), parameters);
        return pageProvider;
    }
}

