/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.elasticsearch.LogEntryGen;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@Deploys(value={@Deploy(value={"org.nuxeo.runtime.metrics"}), @Deploy(value={"org.nuxeo.ecm.platform.audit.api"}), @Deploy(value={"org.nuxeo.ecm.platform.audit"}), @Deploy(value={"org.nuxeo.ecm.platform.uidgen.core"}), @Deploy(value={"org.nuxeo.elasticsearch.core"}), @Deploy(value={"org.nuxeo.elasticsearch.seqgen"}), @Deploy(value={"org.nuxeo.elasticsearch.seqgen.test:elasticsearch-seqgen-index-test-contrib.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.audit"}), @Deploy(value={"org.nuxeo.elasticsearch.audit:elasticsearch-audit-index-test-contrib.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.audit:audit-test-contrib.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.audit:test-pageprovider-track-contrib.xml"})})
@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
public class TestPageProviderTracking {
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchAdmin esa;
    @Inject
    protected PageProviderService pps;
    @Inject
    protected AuditReader reader;

    @Before
    public void setupIndex() throws Exception {
        LogEntryGen.flushAndSync();
        this.esa.initIndexes(true);
    }

    @Test
    public void shouldLogPageProviderCallsInAudit() throws Exception {
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProvider pp = this.pps.getPageProvider("CURRENT_DOCUMENT_CHILDREN_TRACK", null, Long.valueOf(10L), Long.valueOf(0L), props, new Object[]{this.session.getRootDocument().getId()});
        Assert.assertNotNull((Object)pp);
        List trail = this.reader.queryLogs(new String[]{"search"}, null);
        Assert.assertEquals((long)0L, (long)trail.size());
        pp.getCurrentPage();
        LogEntryGen.flushAndSync();
        trail = this.reader.queryLogs(new String[]{"search"}, null);
        Assert.assertEquals((long)1L, (long)trail.size());
        LogEntry entry = (LogEntry)trail.get(0);
        Assert.assertEquals((Object)this.session.getPrincipal().getName(), (Object)entry.getPrincipalName());
        Assert.assertEquals((Object)"search", (Object)entry.getEventId());
        Assert.assertEquals((Object)"CURRENT_DOCUMENT_CHILDREN_TRACK", (Object)((ExtendedInfo)entry.getExtendedInfos().get("pageProviderName")).getSerializableValue());
        Assert.assertEquals((Object)0L, (Object)((ExtendedInfo)entry.getExtendedInfos().get("pageIndex")).getSerializableValue());
        Assert.assertEquals((Object)0L, (Object)((ExtendedInfo)entry.getExtendedInfos().get("resultsCountInPage")).getSerializableValue());
        Assert.assertTrue((boolean)((List)((Object)((ExtendedInfo)entry.getExtendedInfos().get("params")).getSerializableValue())).contains(this.session.getRootDocument().getId()));
        pp.getCurrentPage();
        LogEntryGen.flushAndSync();
        trail = this.reader.queryLogs(new String[]{"search"}, null);
        Assert.assertEquals((long)2L, (long)trail.size());
    }

    @Test
    public void shouldLogPageProviderCallsAndSearchDocumentModelInAudit() throws Exception {
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        DocumentModel rootDoc = this.session.getRootDocument();
        PageProvider pp = this.pps.getPageProvider("CURRENT_DOCUMENT_CHILDREN_SEARCH_DOCUMENT_TRACK", rootDoc, null, Long.valueOf(2L), Long.valueOf(0L), props, new Object[0]);
        Assert.assertNotNull((Object)pp);
        List trail = this.reader.queryLogs(new String[]{"search"}, null);
        Assert.assertEquals((long)0L, (long)trail.size());
        pp.getCurrentPage();
        LogEntryGen.flushAndSync();
        trail = this.reader.queryLogs(new String[]{"search"}, null);
        Assert.assertEquals((long)1L, (long)trail.size());
        LogEntry entry = (LogEntry)trail.get(0);
        Assert.assertEquals((Object)this.session.getPrincipal().getName(), (Object)entry.getPrincipalName());
        Assert.assertEquals((Object)"search", (Object)entry.getEventId());
        Map extended = entry.getExtendedInfos();
        Assert.assertEquals((Object)"CURRENT_DOCUMENT_CHILDREN_SEARCH_DOCUMENT_TRACK", (Object)((ExtendedInfo)extended.get("pageProviderName")).getSerializableValue());
        Assert.assertEquals((Object)0L, (Object)((ExtendedInfo)extended.get("pageIndex")).getSerializableValue());
        Assert.assertEquals((Object)0L, (Object)((ExtendedInfo)extended.get("resultsCountInPage")).getSerializableValue());
        ExtendedInfo extSearchDoc = (ExtendedInfo)extended.get("searchDocumentModel");
        Assert.assertTrue((String)"searchDocumentModel should be a real object", (boolean)(extSearchDoc.getSerializableValue() instanceof Map));
        Map searchDoc = (Map)((Object)extSearchDoc.getSerializableValue());
        Assert.assertEquals((Object)rootDoc.getId(), searchDoc.get("uid"));
        pp.refresh();
        pp.getCurrentPage();
        LogEntryGen.flushAndSync();
        trail = this.reader.queryLogs(new String[]{"search"}, null);
        Assert.assertEquals((long)2L, (long)trail.size());
    }
}

