/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.seqgen;

import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.uidgen.UIDGeneratorService;
import org.nuxeo.ecm.core.uidgen.UIDSequencer;
import org.nuxeo.elasticsearch.seqgen.ESUIDSequencer;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.platform.uidgen.core"}), @Deploy(value={"org.nuxeo.elasticsearch.seqgen"}), @Deploy(value={"org.nuxeo.elasticsearch.core"}), @Deploy(value={"org.nuxeo.elasticsearch.core:elasticsearch-test-contrib.xml"}), @Deploy(value={"org.nuxeo.elasticsearch.seqgen:elasticsearch-seqgen-index-test-contrib.xml"})})
public class TestSequenceGeneratorWithElasticSearch {
    @Inject
    protected UIDGeneratorService uidGeneratorService;

    @Test
    public void testIncrement() throws Exception {
        UIDSequencer seq = this.uidGeneratorService.getSequencer();
        Assert.assertNotNull((Object)seq);
        Assert.assertTrue((boolean)seq.getClass().isAssignableFrom(ESUIDSequencer.class));
        Assert.assertEquals((long)1L, (long)seq.getNext("myseq"));
        Assert.assertEquals((long)2L, (long)seq.getNext("myseq"));
        Assert.assertEquals((long)3L, (long)seq.getNextLong("myseq"));
        Assert.assertEquals((long)1L, (long)seq.getNext("myseq2"));
        Assert.assertEquals((long)4L, (long)seq.getNext("myseq"));
        Assert.assertEquals((long)2L, (long)seq.getNext("myseq2"));
    }

    @Test
    public void testInitSequence() {
        UIDSequencer seq = this.uidGeneratorService.getSequencer();
        seq.getNext("mySequence");
        seq.getNext("mySequence");
        Assert.assertTrue((seq.getNext("mySequence") > 1 ? 1 : 0) != 0);
        seq.initSequence("mySequence", 1000000L);
        Assert.assertEquals((long)1000001L, (long)seq.getNextLong("mySequence"));
        Assert.assertEquals((long)1000002L, (long)seq.getNextLong("mySequence"));
        seq.initSequence("another", 3147483647L);
        Assert.assertTrue((String)"Sequence should be a long", (seq.getNextLong("another") > 3147483647L ? 1 : 0) != 0);
    }

    @Test
    @Ignore(value="NXP-20582: timeout waiting termination")
    public void testConcurrency() throws Exception {
        String seqName = "mt";
        int nbCalls = 5000;
        final UIDSequencer seq = this.uidGeneratorService.getSequencer();
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(5, 5, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(nbCalls + 1));
        for (int i = 0; i < nbCalls; ++i) {
            tpe.submit(new Runnable(){

                @Override
                public void run() {
                    seq.getNext("mt");
                }
            });
        }
        tpe.shutdown();
        boolean finish = tpe.awaitTermination(20L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"timeout", (boolean)finish);
        Assert.assertEquals((long)(nbCalls + 1), (long)seq.getNext("mt"));
    }

    @Test
    public void testBlockOfSequences() {
        UIDSequencer seq = this.uidGeneratorService.getSequencer();
        String key = "blockKey";
        int size = 1000;
        seq.initSequence(key, 0L);
        List block = seq.getNextBlock(key, size);
        Assert.assertNotNull((Object)block);
        Assert.assertEquals((long)size, (long)block.size());
        Assert.assertTrue(((Long)block.get(0) < (Long)block.get(1) ? 1 : 0) != 0);
        Assert.assertTrue(((Long)block.get(size - 2) < (Long)block.get(size - 1) ? 1 : 0) != 0);
        Assert.assertTrue(((Long)block.get(size - 1) < seq.getNextLong(key) ? 1 : 0) != 0);
    }
}

