/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class SecureURL {
    public static void main(String[] args) throws IOException {
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        System.out.println(SecureURL.retrieve(args[0]));
    }

    public static String retrieve(String url) throws IOException {
        return SecureURL.retrieve(url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String retrieve(String url, Boolean force_https) throws IOException {
        BufferedReader r = null;
        try {
            String line;
            URL u = new URL(url);
            if (!u.getProtocol().equals("https") && force_https.booleanValue()) {
                throw new IOException("only 'https' URLs are valid for this method");
            }
            URLConnection uc = u.openConnection();
            uc.setRequestProperty("Connection", "close");
            r = new BufferedReader(new InputStreamReader(uc.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = r.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

