/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.cas2;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ui.web.auth.cas2.Cas2Authenticator;
import org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.DefaultNuxeoExceptionHandler;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.runtime.api.Framework;

public class SecurityExceptionHandler
extends DefaultNuxeoExceptionHandler {
    public static final String CAS_REDIRECTION_URL = "/cas2.jsp";
    public static final String COOKIE_NAME_LOGOUT_URL = "cookie.name.logout.url";
    Cas2Authenticator cas2Authenticator;

    public void handleException(HttpServletRequest request, HttpServletResponse response, Throwable t) throws IOException, ServletException {
        NuxeoPrincipal nuxeoPrincipal;
        Throwable unwrappedException;
        if (response.containsHeader("Cache-Control")) {
            response.setHeader("Cache-Control", "no-cache");
        }
        if (!ExceptionHelper.isSecurityError((Throwable)(unwrappedException = ExceptionHelper.unwrapException((Throwable)t))) && !response.containsHeader("sso.initial.url.request")) {
            super.handleException(request, response, t);
            return;
        }
        Principal principal = this.getPrincipal(request);
        if (principal instanceof NuxeoPrincipal && (nuxeoPrincipal = (NuxeoPrincipal)principal).isAnonymous()) {
            response.resetBuffer();
            String urlToReach = this.getURLToReach(request);
            Cookie cookieUrlToReach = new Cookie("sso.initial.url.request", urlToReach);
            cookieUrlToReach.setPath("/");
            cookieUrlToReach.setMaxAge(60);
            response.addCookie(cookieUrlToReach);
            if (!response.isCommitted()) {
                request.getRequestDispatcher(CAS_REDIRECTION_URL).forward((ServletRequest)request, (ServletResponse)response);
            }
            this.parameters.getListener().responseComplete();
            return;
        }
        super.handleException(request, response, t);
    }

    protected Cas2Authenticator getCasAuthenticator() {
        if (this.cas2Authenticator != null) {
            return this.cas2Authenticator;
        }
        PluggableAuthenticationService service = (PluggableAuthenticationService)Framework.getService(PluggableAuthenticationService.class);
        if (service == null) {
            throw new NuxeoException("Can't initialize Nuxeo Pluggable Authentication Service");
        }
        this.cas2Authenticator = (Cas2Authenticator)service.getPlugin("CAS2_AUTH");
        if (this.cas2Authenticator == null) {
            throw new NuxeoException("Can't get CAS authenticator");
        }
        return this.cas2Authenticator;
    }

    protected String getURLToReach(HttpServletRequest request) {
        return request.getRequestURL().toString() + "?" + request.getQueryString();
    }
}

