/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.client.filter;

import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import edu.yale.its.tp.cas.client.Util;
import edu.yale.its.tp.cas.client.filter.CASFilterRequestWrapper;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class CASFilter
implements Filter {
    public static final String CAS_FILTER_USER = "edu.yale.its.tp.cas.client.filter.user";
    private String casLogin;
    private String casValidate;
    private String casAuthorizedProxy;
    private String casServiceUrl;
    private String casRenew;
    private String casServerName;
    private boolean wrapRequest;

    public void init(FilterConfig config) throws ServletException {
        this.casLogin = config.getInitParameter("edu.yale.its.tp.cas.client.filter.loginUrl");
        this.casValidate = config.getInitParameter("edu.yale.its.tp.cas.client.filter.validateUrl");
        this.casServiceUrl = config.getInitParameter("edu.yale.its.tp.cas.client.filter.serviceUrl");
        this.casAuthorizedProxy = config.getInitParameter("edu.yale.its.tp.cas.client.filter.authorizedProxy");
        this.casRenew = config.getInitParameter("edu.yale.its.tp.cas.client.filter.renew");
        this.casServerName = config.getInitParameter("edu.yale.its.tp.cas.client.filter.serverName");
        this.wrapRequest = Boolean.valueOf(config.getInitParameter("edu.yale.its.tp.cas.client.filter.wrapRequest"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain fc) throws ServletException, IOException {
        HttpSession session;
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("CASFilter protects only HTTP resources");
        }
        if (this.wrapRequest) {
            request = new CASFilterRequestWrapper((HttpServletRequest)request);
        }
        if ((session = ((HttpServletRequest)request).getSession()) != null && session.getAttribute(CAS_FILTER_USER) != null) {
            fc.doFilter(request, response);
            return;
        }
        String ticket = request.getParameter("ticket");
        if (ticket == null || ticket.equals("")) {
            if (this.casLogin == null) {
                throw new ServletException("When CASFilter protects pages that do not receive a 'ticket' parameter, it needs a edu.yale.its.tp.cas.client.filter.loginUrl filter parameter");
            }
            ((HttpServletResponse)response).sendRedirect(this.casLogin + "?service=" + this.getService((HttpServletRequest)request) + (String)(this.casRenew != null && !this.casRenew.equals("") ? "&renew=" + this.casRenew : ""));
            return;
        }
        String user = this.getAuthenticatedUser((HttpServletRequest)request);
        if (user == null) {
            throw new ServletException("Unexpected CAS authentication error");
        }
        if (session != null) {
            session.setAttribute(CAS_FILTER_USER, (Object)user);
        }
        fc.doFilter(request, response);
    }

    public void destroy() {
    }

    private String getAuthenticatedUser(HttpServletRequest request) throws ServletException {
        ProxyTicketValidator pv = null;
        try {
            pv = new ProxyTicketValidator();
            pv.setCasValidateUrl(this.casValidate);
            pv.setServiceTicket(request.getParameter("ticket"));
            pv.setService(this.getService(request));
            pv.setRenew(Boolean.valueOf(this.casRenew));
            pv.validate();
            if (!pv.isAuthenticationSuccesful()) {
                throw new ServletException("CAS authentication error: " + pv.getErrorCode() + ": " + pv.getErrorMessage());
            }
            if (pv.getProxyList().size() != 0) {
                if (this.casAuthorizedProxy == null) {
                    throw new ServletException("this page does not accept proxied tickets");
                }
                boolean authorized = false;
                String proxy = pv.getProxyList().get(0);
                StringTokenizer casProxies = new StringTokenizer(this.casAuthorizedProxy);
                while (casProxies.hasMoreTokens()) {
                    if (!proxy.equals(casProxies.nextToken())) continue;
                    authorized = true;
                    break;
                }
                if (!authorized) {
                    throw new ServletException("unauthorized top-level proxy: '" + pv.getProxyList().get(0) + "'");
                }
            }
            return pv.getUser();
        }
        catch (SAXException ex) {
            String xmlResponse = "";
            if (pv != null) {
                xmlResponse = pv.getResponse();
            }
            throw new ServletException(ex + " " + xmlResponse);
        }
        catch (ParserConfigurationException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    private String getService(HttpServletRequest request) throws ServletException {
        if (this.casServerName == null && this.casServiceUrl == null) {
            throw new ServletException("need one of the following configuration parameters: edu.yale.its.tp.cas.client.filter.serviceUrl or edu.yale.its.tp.cas.client.filter.serverName");
        }
        if (this.casServiceUrl != null) {
            return URLEncoder.encode(this.casServiceUrl);
        }
        return Util.getService(request, this.casServerName);
    }
}

