/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.gcp;

import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.blob.AbstractBinaryGarbageCollector;
import org.nuxeo.ecm.blob.AbstractCloudBinaryManager;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.CachingBinaryManager;
import org.nuxeo.ecm.core.blob.binary.FileStorage;

public class GoogleStorageBinaryManager
extends AbstractCloudBinaryManager {
    private static final Log log = LogFactory.getLog(GoogleStorageBinaryManager.class);
    public static final String BUCKET_NAME_PROPERTY = "storage.bucket";
    public static final String BUCKET_PREFIX_PROPERTY = "storage.bucket_prefix";
    public static final String PROJECT_ID_PROPERTY = "project";
    public static final String GOOGLE_APPLICATION_CREDENTIALS = "credentials";
    public static final String GOOGLE_PLATFORM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    public static final String GOOGLE_STORAGE_SCOPE = "https://www.googleapis.com/auth/devstorage.full_control";
    public static final String SYSTEM_PROPERTY_PREFIX = "nuxeo.gcp";
    private static final Pattern MD5_RE = Pattern.compile("[0-9a-f]{32}");
    public static final String DELIMITER = "/";
    public static final String GCP_JSON_FILE = "gcp-credentials.json";
    protected String bucketName;
    protected String bucketPrefix;
    protected Bucket bucket;
    protected Storage storage;

    protected void setupCloudClient() {
        try {
            String projectId = this.getProperty(PROJECT_ID_PROPERTY);
            File googleCredentials = new File(this.getProperty(GOOGLE_APPLICATION_CREDENTIALS));
            String credentialsPath = googleCredentials.isFile() ? googleCredentials.getAbsolutePath() : new File(Environment.getDefault().getConfig(), this.getProperty(GOOGLE_APPLICATION_CREDENTIALS, GCP_JSON_FILE)).getAbsolutePath();
            GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(Files.readAllBytes(Paths.get(credentialsPath, new String[0])))).createScoped(new String[]{GOOGLE_PLATFORM_SCOPE, GOOGLE_STORAGE_SCOPE});
            credentials.refreshIfExpired();
            this.storage = (Storage)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)GoogleCredentials.create((AccessToken)credentials.refreshAccessToken()))).setProjectId(projectId)).build().getService();
            this.bucketName = this.getProperty(BUCKET_NAME_PROPERTY);
            this.bucketPrefix = this.getProperty(BUCKET_PREFIX_PROPERTY, "");
            this.bucket = this.getOrCreateBucket(this.bucketName);
            if (!StringUtils.isBlank((CharSequence)this.bucketPrefix) && !this.bucketPrefix.endsWith(DELIMITER)) {
                log.warn((Object)String.format("%s %s Google bucket prefix should end with '/' : added automatically.", BUCKET_PREFIX_PROPERTY, this.bucketPrefix));
                this.bucketPrefix = this.bucketPrefix + DELIMITER;
            }
            if (StringUtils.isNotBlank((CharSequence)this.namespace)) {
                this.bucketPrefix = this.bucketPrefix + this.namespace;
                if (!this.bucketPrefix.endsWith(DELIMITER)) {
                    this.bucketPrefix = this.bucketPrefix + DELIMITER;
                }
            }
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public Bucket getOrCreateBucket(String bucketName) {
        Bucket bucket = this.storage.get(bucketName, new Storage.BucketGetOption[0]);
        if (bucket == null) {
            log.debug((Object)String.format("Creating a new bucket %s", bucketName));
            return this.storage.create(BucketInfo.of((String)bucketName), new Storage.BucketTargetOption[0]);
        }
        return bucket;
    }

    public boolean deleteBucket(String bucketName) {
        Bucket bucket = this.storage.get(bucketName, new Storage.BucketGetOption[0]);
        for (Blob blob : this.storage.list(bucketName, new Storage.BlobListOption[0]).iterateAll()) {
            blob.delete(new Blob.BlobSourceOption[0]);
        }
        return bucket.exists(new Bucket.BucketSourceOption[0]) && this.storage.delete(bucketName, new Storage.BucketSourceOption[0]);
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    protected FileStorage getFileStorage() {
        return new GCPFileStorage();
    }

    protected String getSystemPropertyPrefix() {
        return SYSTEM_PROPERTY_PREFIX;
    }

    protected static boolean isMD5(String digest) {
        return MD5_RE.matcher(digest).matches();
    }

    protected BinaryGarbageCollector instantiateGarbageCollector() {
        return new GoogleStorageBinaryGarbageCollector(this);
    }

    public void removeBinaries(Collection<String> digests) {
        digests.forEach(this::removeBinary);
    }

    protected void removeBinary(String digest) {
        this.storage.delete(BlobId.of((String)this.bucket.getName(), (String)(this.bucketPrefix + digest)));
    }

    public static class GoogleStorageBinaryGarbageCollector
    extends AbstractBinaryGarbageCollector<GoogleStorageBinaryManager> {
        protected GoogleStorageBinaryGarbageCollector(GoogleStorageBinaryManager binaryManager) {
            super((CachingBinaryManager)binaryManager);
        }

        public String getId() {
            return "gcs:" + ((GoogleStorageBinaryManager)this.binaryManager).bucketName;
        }

        public Set<String> getUnmarkedBlobs() {
            HashSet<String> unmarked = new HashSet<String>();
            Page blobs = ((GoogleStorageBinaryManager)this.binaryManager).getBucket().list(new Storage.BlobListOption[]{Storage.BlobListOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.ID, Storage.BlobField.SIZE}), Storage.BlobListOption.prefix((String)((GoogleStorageBinaryManager)this.binaryManager).bucketPrefix)});
            do {
                int prefixLength = ((GoogleStorageBinaryManager)this.binaryManager).bucketPrefix.length();
                for (Blob blob : blobs.iterateAll()) {
                    String digest = blob.getName().substring(prefixLength);
                    if (!GoogleStorageBinaryManager.isMD5(digest)) continue;
                    if (this.marked.contains(digest)) {
                        ++this.status.numBinaries;
                        this.status.sizeBinaries += blob.getSize().longValue();
                        continue;
                    }
                    ++this.status.numBinariesGC;
                    this.status.sizeBinariesGC += blob.getSize().longValue();
                    unmarked.add(digest);
                    this.marked.remove(digest);
                }
            } while ((blobs = blobs.getNextPage()) != null);
            return unmarked;
        }
    }

    public class GCPFileStorage
    implements FileStorage {
        public void storeFile(String key, File file) {
            try {
                GoogleStorageBinaryManager.this.bucket.create(GoogleStorageBinaryManager.this.bucketPrefix + key, (InputStream)new FileInputStream(file), new Bucket.BlobWriteOption[0]);
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
        }

        public boolean fetchFile(String key, File file) {
            Blob blob = GoogleStorageBinaryManager.this.bucket.get(GoogleStorageBinaryManager.this.bucketPrefix + key, new Storage.BlobGetOption[0]);
            if (blob != null) {
                blob.downloadTo(file.toPath());
                return true;
            }
            return false;
        }
    }
}

