/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.random;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.importer.random.DictionaryHolder;

public class RandomTextGenerator {
    protected DictionaryHolder dictionaryHolder;
    protected Map<String, String> paragraphCache = new HashMap<String, String>();
    protected Map<String, String> pageCache = new HashMap<String, String>();
    protected Map<String, String> blockCache = new HashMap<String, String>();
    protected static final int PARAGRAPH_CACHE_SIZE = 100;
    protected static final int PARAGRAPH_CACHE_HIT = 100;
    protected static final int PAGE_CACHE_SIZE = 50;
    protected static final int PAGE_CACHE_HIT = 30;
    protected static final int BLOC_CACHE_SIZE = 30;
    protected static final int BLOC_CACHE_HIT = 20;
    protected static final int BLOC_SIZE = 10240;
    protected static final int NB_WORDS_PER_LINE = 20;
    protected static final int NB_LINES_PER_PARAGRAPH = 40;
    protected static final int NB_PARAGRAPH_PER_PAGE = 8;
    protected static final int NB_PAGE_PER_BLOC = 3;
    protected static final Random RANDOM = new Random();

    public RandomTextGenerator(DictionaryHolder dictionary) {
        this.dictionaryHolder = dictionary;
    }

    protected int getTargetPageMaxSizeB() {
        return 4095;
    }

    protected int getTargetParagraphMaxSizeB() {
        return (int)(1.2 * (double)(this.getTargetPageMaxSizeB() / 8));
    }

    public String getRandomTitle(int nbWord) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nbWord; ++i) {
            sb.append(this.dictionaryHolder.getRandomWord());
        }
        return sb.toString();
    }

    public String getRandomLine() {
        int nbW = 10 + RANDOM.nextInt(20);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nbW; ++i) {
            sb.append(this.dictionaryHolder.getRandomWord());
        }
        sb.append(".\n");
        return sb.toString();
    }

    public String generateParagraph() {
        int nbL = 10 + RANDOM.nextInt(40);
        StringBuilder sb = new StringBuilder();
        int maxSize = this.getTargetParagraphMaxSizeB();
        for (int i = 0; i < nbL; ++i) {
            sb.append(this.getRandomLine());
            if (sb.length() > maxSize) break;
        }
        sb.append("\n\n");
        return sb.toString();
    }

    public void prefilCache() {
        String page;
        int i;
        try {
            this.dictionaryHolder.init();
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        for (i = 0; i < 100; ++i) {
            this.paragraphCache.put("P" + i, this.generateParagraph());
        }
        for (i = 0; i < 50; ++i) {
            page = this.generatePage();
            this.pageCache.put("P" + i, page);
        }
        for (i = 0; i < 30; ++i) {
            page = this.generateBloc();
            this.blockCache.put("B" + i, page);
        }
    }

    public String getRandomParagraph() {
        int rand = RANDOM.nextInt();
        int idx = RANDOM.nextInt(100);
        String paragraph = null;
        if (rand % 100 != 0) {
            paragraph = this.paragraphCache.get("P" + idx);
        }
        if (paragraph == null) {
            paragraph = this.generateParagraph();
            this.paragraphCache.put("P" + idx, paragraph);
        }
        return paragraph;
    }

    public String generatePage() {
        int nbL = RANDOM.nextInt(8) + 1;
        StringBuilder sb = new StringBuilder();
        int maxTargetPageSize = this.getTargetPageMaxSizeB();
        for (int i = 0; i < nbL; ++i) {
            sb.append(this.getRandomParagraph());
            if (sb.length() > maxTargetPageSize) break;
        }
        sb.append("\n\n");
        return sb.toString();
    }

    public String getRandomPage() {
        int rand = RANDOM.nextInt();
        int idx = RANDOM.nextInt(50);
        String page = null;
        if (rand % 30 != 0) {
            page = this.pageCache.get("P" + idx);
        }
        if (page == null) {
            page = this.generatePage();
            this.pageCache.put("P" + idx, page);
        }
        return page;
    }

    public String generateBloc() {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < 10240) {
            sb.append(this.getRandomPage());
        }
        return sb.toString();
    }

    public String getRandomBloc() {
        int rand = RANDOM.nextInt();
        int idx = RANDOM.nextInt(30);
        String bloc = null;
        if (rand % 20 != 0) {
            bloc = this.blockCache.get("B" + idx);
        }
        if (bloc == null) {
            bloc = this.generateBloc();
            this.blockCache.put("B" + idx, bloc);
        }
        return bloc;
    }

    public String getRandomText(int avSizeInK) {
        String p;
        if (avSizeInK == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int minSize = (int)((double)(avSizeInK * 1024) * (0.8 + 0.4 * (double)RANDOM.nextFloat()));
        while (sb.length() < minSize - 10240) {
            p = this.getRandomBloc();
            sb.append(p);
        }
        while (sb.length() < minSize) {
            p = this.getRandomPage();
            sb.append(p);
        }
        return sb.toString();
    }

    public String getRandomText() {
        int sizeK = RANDOM.nextInt(500) + 1;
        return this.getRandomText(sizeK);
    }
}

