/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.automation;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.RetryPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.importer.stream.StreamImporters;
import org.nuxeo.importer.stream.automation.RandomBlobProducers;
import org.nuxeo.importer.stream.consumer.BlobInfoWriter;
import org.nuxeo.importer.stream.consumer.BlobMessageConsumerFactory;
import org.nuxeo.importer.stream.consumer.LogBlobInfoWriter;
import org.nuxeo.importer.stream.message.BlobInfoMessage;
import org.nuxeo.importer.stream.message.BlobMessage;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.log.LogAppender;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.pattern.consumer.BatchPolicy;
import org.nuxeo.lib.stream.pattern.consumer.ConsumerPolicy;
import org.nuxeo.lib.stream.pattern.consumer.ConsumerPool;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamService;

@Operation(id="StreamImporter.runBlobConsumers", category="Services", label="Import blobs", since="9.1", description="Import blob into the binarystore.")
public class BlobConsumers {
    private static final Log log = LogFactory.getLog(BlobConsumers.class);
    public static final String ID = "StreamImporter.runBlobConsumers";
    @Context
    protected OperationContext ctx;
    @Param(name="nbThreads", required=false)
    protected Integer nbThreads;
    @Param(name="blobProviderName", required=false)
    protected String blobProviderName = "default";
    @Param(name="batchSize", required=false)
    protected Integer batchSize = 10;
    @Param(name="batchThresholdS", required=false)
    protected Integer batchThresholdS = 20;
    @Param(name="retryMax", required=false)
    protected Integer retryMax = 3;
    @Param(name="retryDelayS", required=false)
    protected Integer retryDelayS = 2;
    @Param(name="logName", required=false)
    protected String logName = "import-blob";
    @Param(name="logBlobInfo", required=false)
    protected String logBlobInfoName = "import-blob-info";
    @Param(name="logConfig", required=false)
    protected String logConfig = "default";
    @Param(name="waitMessageTimeoutSeconds", required=false)
    protected Integer waitMessageTimeoutSeconds = 20;
    @Param(name="watermark", required=false)
    protected String watermark;
    @Param(name="persistBlobPath", required=false)
    protected String persistBlobPath;

    @OperationMethod
    public void run() throws OperationException {
        RandomBlobProducers.checkAccess(this.ctx);
        ConsumerPolicy consumerPolicy = ConsumerPolicy.builder().name(ID).batchPolicy(BatchPolicy.builder().capacity(this.batchSize).timeThreshold(Duration.ofSeconds(this.batchThresholdS.intValue())).build()).retryPolicy(new RetryPolicy().withMaxRetries(this.retryMax.intValue()).withDelay((long)this.retryDelayS.intValue(), TimeUnit.SECONDS)).maxThreads(this.getNbThreads()).waitMessageTimeout(Duration.ofSeconds(this.waitMessageTimeoutSeconds.intValue())).build();
        LogManager manager = ((StreamService)Framework.getService(StreamService.class)).getLogManager(this.logConfig);
        Codec<BlobMessage> codec = StreamImporters.getBlobCodec();
        try (BlobInfoWriter blobInfoWriter = this.getBlobInfoWriter(manager);){
            ConsumerPool<BlobMessage> consumers = new ConsumerPool<BlobMessage>(this.logName, manager, codec, new BlobMessageConsumerFactory(this.blobProviderName, blobInfoWriter, this.watermark, this.persistBlobPath), consumerPolicy);
            consumers.start().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn((Object)"Operation interrupted");
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            log.error((Object)"Operation fails", (Throwable)e);
            throw new OperationException((Throwable)e);
        }
    }

    protected BlobInfoWriter getBlobInfoWriter(LogManager managerBlobInfo) {
        this.initBlobInfoMQ(managerBlobInfo);
        Codec<BlobInfoMessage> blobInfoCodec = StreamImporters.getBlobInfoCodec();
        return new LogBlobInfoWriter((LogAppender<BlobInfoMessage>)managerBlobInfo.getAppender(this.logBlobInfoName, blobInfoCodec));
    }

    protected void initBlobInfoMQ(LogManager manager) {
        manager.createIfNotExists(this.logBlobInfoName, 1);
    }

    protected short getNbThreads() {
        if (this.nbThreads != null) {
            return this.nbThreads.shortValue();
        }
        return 0;
    }
}

