/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.automation;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.RetryPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.importer.stream.StreamImporters;
import org.nuxeo.importer.stream.automation.RandomBlobProducers;
import org.nuxeo.importer.stream.consumer.DocumentConsumerPolicy;
import org.nuxeo.importer.stream.consumer.DocumentConsumerPool;
import org.nuxeo.importer.stream.consumer.DocumentMessageConsumerFactory;
import org.nuxeo.importer.stream.message.DocumentMessage;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.pattern.consumer.BatchPolicy;
import org.nuxeo.lib.stream.pattern.consumer.ConsumerPolicy;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamService;

@Operation(id="StreamImporter.runDocumentConsumers", category="Services", label="Imports document", since="9.1", description="Import documents into repository.")
public class DocumentConsumers {
    private static final Log log = LogFactory.getLog(DocumentConsumers.class);
    public static final String ID = "StreamImporter.runDocumentConsumers";
    @Context
    protected OperationContext ctx;
    @Param(name="nbThreads", required=false)
    protected Integer nbThreads;
    @Param(name="rootFolder")
    protected String rootFolder;
    @Param(name="repositoryName", required=false)
    protected String repositoryName;
    @Param(name="batchSize", required=false)
    protected Integer batchSize = 10;
    @Param(name="batchThresholdS", required=false)
    protected Integer batchThresholdS = 20;
    @Param(name="retryMax", required=false)
    protected Integer retryMax = 3;
    @Param(name="retryDelayS", required=false)
    protected Integer retryDelayS = 2;
    @Param(name="logName", required=false)
    protected String logName = "import-doc";
    @Param(name="logConfig", required=false)
    protected String logConfig = "default";
    @Param(name="blockIndexing", required=false)
    protected Boolean blockIndexing = false;
    @Param(name="blockAsyncListeners", required=false)
    protected Boolean blockAsyncListeners = false;
    @Param(name="blockPostCommitListeners", required=false)
    protected Boolean blockPostCommitListeners = false;
    @Param(name="blockDefaultSyncListeners", required=false)
    protected Boolean blockSyncListeners = false;
    @Param(name="useBulkMode", required=false)
    protected Boolean useBulkMode = false;
    @Param(name="waitMessageTimeoutSeconds", required=false)
    protected Integer waitMessageTimeoutSeconds = 20;

    @OperationMethod
    public void run() throws OperationException {
        RandomBlobProducers.checkAccess(this.ctx);
        this.repositoryName = this.getRepositoryName();
        ConsumerPolicy consumerPolicy = DocumentConsumerPolicy.builder().blockIndexing(this.blockIndexing).blockAsyncListeners(this.blockAsyncListeners).blockPostCommitListeners(this.blockPostCommitListeners).blockDefaultSyncListener(this.blockSyncListeners).useBulkMode(this.useBulkMode).name(ID).batchPolicy(BatchPolicy.builder().capacity(this.batchSize).timeThreshold(Duration.ofSeconds(this.batchThresholdS.intValue())).build()).retryPolicy(new RetryPolicy().withMaxRetries(this.retryMax.intValue()).withDelay((long)this.retryDelayS.intValue(), TimeUnit.SECONDS)).maxThreads(this.getNbThreads()).waitMessageTimeout(Duration.ofSeconds(this.waitMessageTimeoutSeconds.intValue())).salted().build();
        log.warn((Object)String.format("Import documents from log: %s into: %s/%s, with policy: %s", this.logName, this.repositoryName, this.rootFolder, consumerPolicy));
        LogManager manager = ((StreamService)Framework.getService(StreamService.class)).getLogManager(this.logConfig);
        Codec<DocumentMessage> codec = StreamImporters.getDocCodec();
        try (DocumentConsumerPool<DocumentMessage> consumers = new DocumentConsumerPool<DocumentMessage>(this.logName, manager, codec, new DocumentMessageConsumerFactory(this.repositoryName, this.rootFolder), consumerPolicy);){
            consumers.start().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn((Object)"Operation interrupted");
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            log.error((Object)"Operation fails", (Throwable)e);
            throw new OperationException((Throwable)e);
        }
    }

    protected short getNbThreads() {
        if (this.nbThreads != null) {
            return this.nbThreads.shortValue();
        }
        return 0;
    }

    protected String getRepositoryName() {
        if (this.repositoryName != null && !this.repositoryName.isEmpty()) {
            return this.repositoryName;
        }
        return this.ctx.getCoreSession().getRepositoryName();
    }
}

