/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.automation;

import java.io.File;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.importer.stream.StreamImporters;
import org.nuxeo.importer.stream.message.BlobMessage;
import org.nuxeo.importer.stream.producer.FileBlobMessageProducerFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.pattern.producer.ProducerPool;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamService;

@Operation(id="StreamImporter.runFileBlobProducers", category="Services", label="Produces blobs from a list of files", since="10.2", description="Produces blobs from a list of files.")
public class FileBlobProducers {
    private static final Log log = LogFactory.getLog(FileBlobProducers.class);
    public static final String ID = "StreamImporter.runFileBlobProducers";
    @Context
    protected OperationContext ctx;
    @Param(name="listFile")
    protected String listFile;
    @Param(name="nbBlobs", required=false)
    protected Integer nbBlobs;
    @Param(name="nbThreads", required=false)
    protected Integer nbThreads = 1;
    @Param(name="logName", required=false)
    protected String logName = "import-blob";
    @Param(name="logSize", required=false)
    protected Integer logSize;
    @Param(name="logConfig", required=false)
    protected String logConfig = "default";
    @Param(name="basePath", required=false)
    protected String basePath;

    @OperationMethod
    public void run() throws OperationException {
        FileBlobProducers.checkAccess(this.ctx);
        LogManager manager = ((StreamService)Framework.getService(StreamService.class)).getLogManager(this.logConfig);
        manager.createIfNotExists(this.logName, this.getLogSize());
        Codec<BlobMessage> codec = StreamImporters.getBlobCodec();
        try (ProducerPool<BlobMessage> producers = new ProducerPool<BlobMessage>(this.logName, manager, codec, new FileBlobMessageProducerFactory(this.getListFile(), this.getBasePath(), this.getNbBlobs()), this.nbThreads.shortValue());){
            producers.start().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn((Object)"Operation interrupted");
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            log.error((Object)"Operation fails", (Throwable)e);
            throw new OperationException((Throwable)e);
        }
    }

    protected long getNbBlobs() {
        if (this.nbBlobs == null) {
            return 0L;
        }
        return this.nbBlobs.longValue();
    }

    protected int getLogSize() {
        if (this.logSize != null && this.logSize > 0) {
            return this.logSize;
        }
        return this.nbThreads;
    }

    protected String getBasePath() {
        if (StringUtils.isEmpty((CharSequence)this.basePath)) {
            return null;
        }
        if (!new File(this.basePath).exists()) {
            throw new IllegalArgumentException("Can not access basePath: " + this.basePath);
        }
        return this.basePath;
    }

    protected File getListFile() {
        File ret = new File(this.listFile);
        if (!ret.exists() || !ret.canRead()) {
            throw new IllegalArgumentException("Can not access or read listFile: " + this.listFile);
        }
        return ret;
    }

    protected static void checkAccess(OperationContext context) {
        NuxeoPrincipal principal = context.getPrincipal();
        if (principal == null || !principal.isAdministrator()) {
            throw new RuntimeException("Unauthorized access: " + principal);
        }
    }
}

