/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.automation;

import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.importer.stream.StreamImporters;
import org.nuxeo.importer.stream.message.BlobMessage;
import org.nuxeo.importer.stream.producer.RandomStringBlobMessageProducerFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.pattern.producer.ProducerPool;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamService;

@Operation(id="StreamImporter.runRandomBlobProducers", category="Services", label="Produces random blobs", since="9.1", description="Produces random blobs in a Log.")
public class RandomBlobProducers {
    private static final Log log = LogFactory.getLog(RandomBlobProducers.class);
    public static final String ID = "StreamImporter.runRandomBlobProducers";
    @Context
    protected OperationContext ctx;
    @Param(name="nbBlobs")
    protected Integer nbBlobs;
    @Param(name="nbThreads", required=false)
    protected Integer nbThreads = 8;
    @Param(name="avgBlobSizeKB", required=false)
    protected Integer avgBlobSizeKB = 1;
    @Param(name="lang", required=false)
    protected String lang = "en_US";
    @Param(name="logName", required=false)
    protected String logName = "import-blob";
    @Param(name="logSize", required=false)
    protected Integer logSize;
    @Param(name="logConfig", required=false)
    protected String logConfig = "default";
    @Param(name="blobMarker", required=false)
    protected String blobMarker;

    @OperationMethod
    public void run() throws OperationException {
        RandomBlobProducers.checkAccess(this.ctx);
        LogManager manager = ((StreamService)Framework.getService(StreamService.class)).getLogManager(this.logConfig);
        manager.createIfNotExists(this.logName, this.getLogSize());
        Codec<BlobMessage> codec = StreamImporters.getBlobCodec();
        try (ProducerPool<BlobMessage> producers = new ProducerPool<BlobMessage>(this.logName, manager, codec, new RandomStringBlobMessageProducerFactory(this.nbBlobs.intValue(), this.lang, this.avgBlobSizeKB, this.blobMarker), this.nbThreads.shortValue());){
            producers.start().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn((Object)"Operation interrupted");
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            log.error((Object)"fail", (Throwable)e);
            throw new OperationException((Throwable)e);
        }
    }

    protected int getLogSize() {
        if (this.logSize != null && this.logSize > 0) {
            return this.logSize;
        }
        return this.nbThreads;
    }

    protected static void checkAccess(OperationContext context) {
        NuxeoPrincipal principal = context.getPrincipal();
        if (principal == null || !principal.isAdministrator()) {
            throw new RuntimeException("Unauthorized access: " + principal);
        }
    }
}

