/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.automation;

import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.importer.stream.StreamImporters;
import org.nuxeo.importer.stream.automation.RandomBlobProducers;
import org.nuxeo.importer.stream.message.DocumentMessage;
import org.nuxeo.importer.stream.producer.RandomDocumentMessageProducerFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.pattern.producer.ProducerPool;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamService;

@Operation(id="StreamImporter.runRandomDocumentProducers", category="Services", label="Produces random blobs", since="9.1", description="Produces random blobs in a Log.")
public class RandomDocumentProducers {
    private static final Log log = LogFactory.getLog(RandomDocumentProducers.class);
    public static final String ID = "StreamImporter.runRandomDocumentProducers";
    @Context
    protected OperationContext ctx;
    @Param(name="nbDocuments")
    protected Integer nbDocuments;
    @Param(name="nbThreads", required=false)
    protected Integer nbThreads = 8;
    @Param(name="avgBlobSizeKB", required=false)
    protected Integer avgBlobSizeKB = 1;
    @Param(name="lang", required=false)
    protected String lang = "en_US";
    @Param(name="logName", required=false)
    protected String logName = "import-doc";
    @Param(name="logSize", required=false)
    protected Integer logSize;
    @Param(name="logBlobInfo", required=false)
    protected String logBlobInfoName;
    @Param(name="logConfig", required=false)
    protected String logConfig = "default";
    @Param(name="countFolderAsDocument", required=false)
    protected Boolean countFolderAsDocument = true;

    @OperationMethod
    public void run() throws OperationException {
        RandomBlobProducers.checkAccess(this.ctx);
        LogManager manager = ((StreamService)Framework.getService(StreamService.class)).getLogManager(this.logConfig);
        manager.createIfNotExists(this.logName, this.getLogSize());
        RandomDocumentMessageProducerFactory factory = this.logBlobInfoName != null ? new RandomDocumentMessageProducerFactory(this.nbDocuments.intValue(), this.lang, manager, this.logBlobInfoName, this.countFolderAsDocument) : new RandomDocumentMessageProducerFactory((long)this.nbDocuments.intValue(), this.lang, this.avgBlobSizeKB, this.countFolderAsDocument);
        Codec<DocumentMessage> codec = StreamImporters.getDocCodec();
        try (ProducerPool<DocumentMessage> producers = new ProducerPool<DocumentMessage>(this.logName, manager, codec, factory, this.nbThreads.shortValue());){
            producers.start().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn((Object)"Operation interrupted");
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            log.error((Object)"Operation fails", (Throwable)e);
            throw new OperationException((Throwable)e);
        }
    }

    protected int getLogSize() {
        if (this.logSize != null && this.logSize > 0) {
            return this.logSize;
        }
        return this.nbThreads;
    }
}

