/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.automation;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.RetryPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.importer.stream.StreamImporters;
import org.nuxeo.importer.stream.automation.RandomBlobProducers;
import org.nuxeo.importer.stream.consumer.RedisDocumentMessageConsumerFactory;
import org.nuxeo.importer.stream.message.DocumentMessage;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.pattern.consumer.BatchPolicy;
import org.nuxeo.lib.stream.pattern.consumer.ConsumerPolicy;
import org.nuxeo.lib.stream.pattern.consumer.ConsumerPool;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamService;

@Operation(id="StreamImporter.runRedisDocumentConsumers", category="Services", label="Imports document into Redis", since="10.1", description="Import documents into Redis.")
public class RedisDocumentConsumers {
    private static final Log log = LogFactory.getLog(RedisDocumentConsumers.class);
    public static final String ID = "StreamImporter.runRedisDocumentConsumers";
    @Context
    protected OperationContext ctx;
    @Param(name="nbThreads", required=false)
    protected Integer nbThreads;
    @Param(name="redisPrefix", required=false)
    protected String redisPrefix;
    @Param(name="retryMax", required=false)
    protected Integer retryMax = 3;
    @Param(name="retryDelayS", required=false)
    protected Integer retryDelayS = 2;
    @Param(name="logName", required=false)
    protected String logName = "import-doc";
    @Param(name="logConfig", required=false)
    protected String logConfig = "default";
    @Param(name="waitMessageTimeoutSeconds", required=false)
    protected Integer waitMessageTimeoutSeconds = 20;

    @OperationMethod
    public void run() throws OperationException {
        RandomBlobProducers.checkAccess(this.ctx);
        ConsumerPolicy consumerPolicy = ConsumerPolicy.builder().name(ID).batchPolicy(BatchPolicy.NO_BATCH).retryPolicy(new RetryPolicy().withMaxRetries(this.retryMax.intValue()).withDelay((long)this.retryDelayS.intValue(), TimeUnit.SECONDS)).maxThreads(this.getNbThreads()).waitMessageTimeout(Duration.ofSeconds(this.waitMessageTimeoutSeconds.intValue())).build();
        log.warn((Object)String.format("Import documents into Redis from log: %s, with policy: %s", this.logName, consumerPolicy));
        LogManager manager = ((StreamService)Framework.getService(StreamService.class)).getLogManager(this.logConfig);
        Codec<DocumentMessage> codec = StreamImporters.getDocCodec();
        try (ConsumerPool<DocumentMessage> consumers = new ConsumerPool<DocumentMessage>(this.logName, manager, codec, new RedisDocumentMessageConsumerFactory(this.redisPrefix), consumerPolicy);){
            consumers.start().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn((Object)"Operation interrupted");
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            log.error((Object)"fail", (Throwable)e);
            throw new OperationException((Throwable)e);
        }
    }

    protected short getNbThreads() {
        if (this.nbThreads != null) {
            return this.nbThreads.shortValue();
        }
        return 0;
    }
}

