/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.consumer;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.importer.stream.consumer.BlobInfoWriter;
import org.nuxeo.importer.stream.message.BlobMessage;
import org.nuxeo.lib.stream.pattern.consumer.AbstractConsumer;
import org.nuxeo.runtime.api.Framework;

public class BlobMessageConsumer
extends AbstractConsumer<BlobMessage> {
    private static final Log log = LogFactory.getLog(BlobMessageConsumer.class);
    protected BlobProvider blobProvider;
    protected final String blobProviderName;
    protected final BlobInfoWriter blobInfoWriter;

    public BlobMessageConsumer(String consumerId, String blobProviderName, BlobInfoWriter blobInfoWriter) {
        super(consumerId);
        this.blobProviderName = blobProviderName;
        if (!StringUtils.isBlank((CharSequence)blobProviderName)) {
            this.blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(blobProviderName);
            if (this.blobProvider == null) {
                throw new IllegalArgumentException("Invalid blob provider: " + blobProviderName);
            }
        }
        this.blobInfoWriter = blobInfoWriter;
    }

    @Override
    public void begin() {
    }

    @Override
    public void accept(BlobMessage message) {
        try (CloseableBlob blob = this.getBlob(message);){
            String digest = null;
            if (this.blobProvider != null) {
                digest = this.blobProvider.writeBlob(blob.getBlob());
            }
            long length = blob.getBlob().getLength();
            this.saveBlobInfo(message, digest, length, blob.getBlob().getFile());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid blob: " + message, e);
        }
    }

    protected CloseableBlob getBlob(BlobMessage message) {
        Object blob = message.getPath() != null ? new FileBlob(new File(message.getPath())) : new StringBlob(message.getContent(), null, null, null);
        return new CloseableBlob((Blob)blob);
    }

    protected void saveBlobInfo(BlobMessage message, String digest, long length, File blobFile) {
        BlobInfo bi = new BlobInfo();
        bi.digest = digest;
        bi.key = this.blobProviderName + ":" + bi.digest;
        bi.length = length;
        bi.filename = digest == null ? blobFile.getAbsolutePath() : message.getFilename();
        bi.mimeType = message.getMimeType();
        bi.encoding = message.getEncoding();
        this.blobInfoWriter.save(null, bi);
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }

    public class CloseableBlob
    implements AutoCloseable {
        protected final Blob blob;
        protected final Path fileToDelete;

        public CloseableBlob(Blob blob) {
            this(blob, null);
        }

        public CloseableBlob(Blob blob, Path fileToDelete) {
            this.blob = blob;
            this.fileToDelete = fileToDelete;
        }

        public Blob getBlob() {
            return this.blob;
        }

        @Override
        public void close() {
            if (this.fileToDelete != null) {
                try {
                    Files.delete(this.fileToDelete);
                }
                catch (IOException e) {
                    log.warn((Object)("Unable to delete file: " + this.fileToDelete), (Throwable)e);
                }
            }
        }
    }
}

