/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.consumer;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.importer.stream.consumer.BlobInfoWriter;
import org.nuxeo.importer.stream.consumer.BlobMessageConsumer;
import org.nuxeo.importer.stream.consumer.BlobWatermarkMessageConsumer;
import org.nuxeo.importer.stream.message.BlobMessage;
import org.nuxeo.lib.stream.pattern.consumer.Consumer;
import org.nuxeo.lib.stream.pattern.consumer.ConsumerFactory;

public class BlobMessageConsumerFactory
implements ConsumerFactory<BlobMessage> {
    protected final String blobProviderName;
    protected final BlobInfoWriter blobInfoWriter;
    protected final String watermarkPrefix;
    protected final String persistBlobPath;

    public BlobMessageConsumerFactory(String blobProviderName, BlobInfoWriter blobInfoWriter) {
        this(blobProviderName, blobInfoWriter, null, null);
    }

    public BlobMessageConsumerFactory(String blobProviderName, BlobInfoWriter blobInfoWriter, String watermarkPrefix) {
        this(blobProviderName, blobInfoWriter, watermarkPrefix, null);
    }

    public BlobMessageConsumerFactory(String blobProviderName, BlobInfoWriter blobInfoWriter, String watermarkPrefix, String persistBlobPath) {
        this.blobProviderName = blobProviderName;
        this.blobInfoWriter = blobInfoWriter;
        this.watermarkPrefix = watermarkPrefix;
        this.persistBlobPath = persistBlobPath;
    }

    @Override
    public Consumer<BlobMessage> createConsumer(String consumerId) {
        if (StringUtils.isEmpty((CharSequence)this.watermarkPrefix)) {
            return new BlobMessageConsumer(consumerId, this.blobProviderName, this.blobInfoWriter);
        }
        return new BlobWatermarkMessageConsumer(consumerId, this.blobProviderName, this.blobInfoWriter, this.watermarkPrefix, this.persistBlobPath);
    }
}

