/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.consumer;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.importer.stream.consumer.BlobInfoWriter;
import org.nuxeo.importer.stream.consumer.BlobMessageConsumer;
import org.nuxeo.importer.stream.consumer.watermarker.JpegWatermarker;
import org.nuxeo.importer.stream.consumer.watermarker.Mp4Watermarker;
import org.nuxeo.importer.stream.consumer.watermarker.TextWatermarker;
import org.nuxeo.importer.stream.consumer.watermarker.Watermarker;
import org.nuxeo.importer.stream.message.BlobMessage;

public class BlobWatermarkMessageConsumer
extends BlobMessageConsumer {
    protected final String prefix;
    protected final String generatedBlobPath;
    protected final Path outputPath;
    protected final Watermarker textWatermarker = new TextWatermarker();
    protected final Watermarker jpegWatermarker = new JpegWatermarker();
    protected final Watermarker mp4Watermarker = new Mp4Watermarker();

    public BlobWatermarkMessageConsumer(String consumerId, String blobProviderName, BlobInfoWriter blobInfoWriter, String watermarkPrefix, String persistBlobPath) {
        super(consumerId, blobProviderName, blobInfoWriter);
        this.prefix = watermarkPrefix;
        this.generatedBlobPath = persistBlobPath;
        if (StringUtils.isBlank((CharSequence)persistBlobPath)) {
            try {
                this.outputPath = Files.createTempDirectory("watermark", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new NuxeoException("Failed to create temp dir", (Throwable)e);
            }
        } else {
            this.outputPath = Paths.get(persistBlobPath, new String[0]);
        }
    }

    @Override
    protected BlobMessageConsumer.CloseableBlob getBlob(BlobMessage message) {
        String watermark = this.getWatermarkString();
        switch (message.getMimeType()) {
            case "text/plain": {
                return this.addWatermark(message, watermark, this.textWatermarker);
            }
            case "image/jpeg": {
                return this.addWatermark(message, watermark, this.jpegWatermarker);
            }
            case "video/mp4": {
                return this.addWatermark(message, watermark, this.mp4Watermarker);
            }
        }
        return super.getBlob(message);
    }

    protected BlobMessageConsumer.CloseableBlob addWatermark(BlobMessage message, String watermark, Watermarker watermarker) {
        Path output = watermarker.addWatermark(Paths.get(message.getPath(), new String[0]), this.outputPath, watermark);
        Path fileToDelete = StringUtils.isBlank((CharSequence)this.generatedBlobPath) ? output : null;
        return new BlobMessageConsumer.CloseableBlob(this, (Blob)new FileBlob(output.toFile(), message.getMimeType()), fileToDelete);
    }

    protected String getWatermarkString() {
        return this.prefix + " " + System.currentTimeMillis();
    }
}

