/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.consumer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.importer.stream.message.DocumentMessage;
import org.nuxeo.lib.stream.pattern.consumer.AbstractConsumer;
import org.nuxeo.runtime.api.Framework;

public class RedisDocumentMessageConsumer
extends AbstractConsumer<DocumentMessage> {
    protected static final String DEFAULT_REDIS_PREFIX = "imp";
    protected static final String DOC_KEY_SUFFIX = "doc";
    protected static final String DATA_KEY_SUFFIX = "data";
    protected static final String FOLDER_KEY_SUFFIX = "folder";
    protected static final String BATCH_ID_TAG = "_BATCH_ID_";
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final byte[] addDocumentSHA;
    protected final RedisExecutor redisExecutor;
    protected final String redisPrefix;

    public RedisDocumentMessageConsumer(String consumerId, String redisPrefix) {
        super(consumerId);
        this.redisPrefix = StringUtils.isBlank((CharSequence)redisPrefix) ? DEFAULT_REDIS_PREFIX : redisPrefix;
        RedisAdmin redisAdmin = (RedisAdmin)Framework.getService(RedisAdmin.class);
        try {
            this.addDocumentSHA = this.bytes(redisAdmin.load("org.nuxeo.importer.stream", "add-document"));
        }
        catch (IOException e) {
            throw new NuxeoException("Cannot load Redis script", (Throwable)e);
        }
        this.redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
    }

    @Override
    public void accept(DocumentMessage message) {
        BlobInfo blobInfo = message.getBlobInfo();
        String blobPath = "";
        String blobFilename = "";
        String blobMimeType = "";
        try {
            String properties;
            if (blobInfo == null || StringUtils.isBlank((CharSequence)blobInfo.filename)) {
                properties = this.getProperties(message);
            } else {
                blobPath = blobInfo.filename;
                blobMimeType = blobInfo.mimeType;
                blobFilename = Paths.get(blobInfo.filename, new String[0]).getFileName().toString();
                properties = this.getPropertiesWithBlob(message);
            }
            String parentPath = message.getParentPath();
            if (parentPath.startsWith("/")) {
                parentPath = parentPath.substring(1);
            }
            String key = Paths.get(parentPath, message.getName()).toString();
            String docKey = this.redisPrefix + ":doc";
            String folderKey = this.redisPrefix + ":folder";
            String dataKey = this.redisPrefix + ":data:" + key;
            String level = String.valueOf(key.split("/").length);
            String url = URIUtils.quoteURIPathComponent((String)key, (boolean)false);
            String payload = this.getPayload(message, properties);
            this.redisExecutor.evalsha(this.addDocumentSHA, Arrays.asList(this.bytes(docKey), this.bytes(dataKey), this.bytes(folderKey)), Arrays.asList(this.bytes(key), this.bytes(parentPath), this.bytes(message.getType()), this.bytes(message.getName()), this.bytes(payload), this.bytes(url), this.bytes(level), this.bytes(blobPath), this.bytes(blobFilename), this.bytes(blobMimeType)));
        }
        catch (JsonProcessingException e) {
            throw new NuxeoException("Cannot convert properties to json: " + message, (Throwable)e);
        }
    }

    protected String getPayload(DocumentMessage message, String properties) {
        return String.format("{\"entity-type\": \"document\", \"name\": \"%s\", \"type\": \"%s\", \"properties\": %s}", message.getName(), message.getType(), properties);
    }

    protected String getPropertiesWithBlob(DocumentMessage message) {
        JsonNode node = OBJECT_MAPPER.valueToTree(message.getProperties());
        ObjectNode fileContent = OBJECT_MAPPER.createObjectNode();
        fileContent.put("upload-batch", BATCH_ID_TAG);
        fileContent.put("upload-fileId", "0");
        return ((ObjectNode)node).set("file:content", (JsonNode)fileContent).toString();
    }

    protected String getProperties(DocumentMessage message) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(message.getProperties());
    }

    protected byte[] bytes(String val) {
        return val.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void begin() {
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }
}

