/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.consumer.watermarker;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.apache.commons.io.FileUtils;
import org.nuxeo.importer.stream.consumer.watermarker.AbstractWatermarker;

public class JpegWatermarker
extends AbstractWatermarker {
    @Override
    public Path addWatermark(Path inputFile, Path outputDir, String watermark) {
        File jpegImageFile = inputFile.toFile();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            TiffImageMetadata exif;
            TiffOutputSet outputSet = null;
            ImageMetadata metadata = Imaging.getMetadata((File)jpegImageFile);
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            if (jpegMetadata != null && (exif = jpegMetadata.getExif()) != null) {
                outputSet = exif.getOutputSet();
            }
            if (outputSet == null) {
                outputSet = new TiffOutputSet();
            }
            TiffOutputDirectory exifDirectory = outputSet.getOrCreateRootDirectory();
            exifDirectory.removeField((TagInfo)ExifTagConstants.EXIF_TAG_SOFTWARE);
            exifDirectory.add(ExifTagConstants.EXIF_TAG_SOFTWARE, new String[]{watermark});
            new ExifRewriter().updateExifMetadataLossless(jpegImageFile, (OutputStream)os, outputSet);
            os.flush();
            File output = this.getOutputPath(inputFile, outputDir, watermark).toFile();
            FileUtils.writeByteArrayToFile((File)output, (byte[])os.toByteArray());
            Path path = output.toPath();
            return path;
        }
        catch (IOException | ImageReadException | ImageWriteException e) {
            throw new IllegalArgumentException("Unable to edit jpeg " + inputFile, e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }
}

