/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.consumer.watermarker;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import org.nuxeo.importer.stream.consumer.watermarker.AbstractWatermarker;

public class TextWatermarker
extends AbstractWatermarker {
    @Override
    public Path addWatermark(Path inputFile, Path outputDir, String watermark) {
        try {
            Path output = this.getOutputPath(inputFile, outputDir, watermark);
            Files.copy(inputFile, output, StandardCopyOption.REPLACE_EXISTING);
            String footer = "\n" + watermark + "\n";
            Files.write(output, footer.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
            return output;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid text file: " + inputFile, e);
        }
    }
}

