/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.message;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.nuxeo.lib.stream.pattern.Message;

public class BlobMessage
implements Message {
    static final long serialVersionUID = 20170529L;
    protected String mimeType;
    protected String encoding;
    protected String filename;
    protected String path;
    protected String content;

    public BlobMessage() {
    }

    protected BlobMessage(StringMessageBuilder builder) {
        this.mimeType = builder.mimetype;
        this.encoding = builder.encoding;
        this.filename = builder.filename;
        this.path = builder.path;
        this.content = builder.content;
        if ((this.path == null || this.path.isEmpty()) && (this.content == null || this.content.isEmpty())) {
            throw new IllegalArgumentException("BlobMessage must be initialized with a file path or content");
        }
    }

    @Override
    public String getId() {
        return this.filename;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContent() {
        return this.content;
    }

    public String getPath() {
        return this.path;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.mimeType);
        out.writeObject(this.encoding);
        out.writeObject(this.filename);
        out.writeObject(this.path);
        out.writeObject(this.content);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mimeType = (String)in.readObject();
        this.encoding = (String)in.readObject();
        this.filename = (String)in.readObject();
        this.path = (String)in.readObject();
        this.content = (String)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlobMessage that = (BlobMessage)o;
        if (this.mimeType != null ? !this.mimeType.equals(that.mimeType) : that.mimeType != null) {
            return false;
        }
        if (this.encoding != null ? !this.encoding.equals(that.encoding) : that.encoding != null) {
            return false;
        }
        if (this.filename != null ? !this.filename.equals(that.filename) : that.filename != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        return this.content != null ? this.content.equals(that.content) : that.content == null;
    }

    public int hashCode() {
        int result = this.mimeType != null ? this.mimeType.hashCode() : 0;
        result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
        result = 31 * result + (this.filename != null ? this.filename.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BlobMessage{mimeType='" + this.mimeType + "', encoding='" + this.encoding + "', filename='" + this.filename + "', path='" + this.path + "', content='" + this.content + "'}";
    }

    public static class FileMessageBuilder
    extends StringMessageBuilder {
        public FileMessageBuilder(String path) {
            super(null);
            this.setPath(path);
            this.filename = Paths.get(path, new String[0]).getFileName().toString();
            this.mimetype = this.guessMimeType();
        }

        protected String guessMimeType() {
            try {
                return Files.probeContentType(Paths.get(this.path, new String[0]));
            }
            catch (IOException e) {
                return "application/octet-stream";
            }
        }
    }

    public static class StringMessageBuilder {
        protected String mimetype;
        protected String encoding;
        protected String filename;
        protected String path;
        protected String content;

        public StringMessageBuilder(String content) {
            this.content = content;
        }

        public StringMessageBuilder setFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public StringMessageBuilder setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public StringMessageBuilder setMimetype(String mimetype) {
            this.mimetype = mimetype;
            return this;
        }

        protected StringMessageBuilder setPath(String path) {
            this.path = path;
            this.content = null;
            return this;
        }

        public BlobMessage build() {
            return new BlobMessage(this);
        }
    }
}

