/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.producer;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.importer.stream.message.BlobMessage;
import org.nuxeo.lib.stream.pattern.producer.AbstractProducer;

public class FileBlobMessageProducer
extends AbstractProducer<BlobMessage> {
    private static final Log log = LogFactory.getLog(FileBlobMessageProducer.class);
    protected final File listFile;
    protected final String basePath;
    protected long count = 0L;
    protected final long nbBlobs;
    protected Iterator<String> fileIterator;
    protected Stream<String> lines;

    public FileBlobMessageProducer(int producerId, File listFile, String basePath, long nbBlobs) {
        super(producerId);
        this.listFile = listFile;
        this.nbBlobs = nbBlobs;
        this.basePath = StringUtils.defaultString((String)basePath);
        log.info((Object)("Producer using file list: " + listFile.getAbsolutePath()));
        this.getFileIterator();
    }

    protected void getFileIterator() {
        try {
            if (this.lines != null) {
                this.lines.close();
            }
            this.lines = Files.lines(this.listFile.toPath());
            this.fileIterator = this.lines.iterator();
        }
        catch (IOException e) {
            String msg = "Failed to read file: " + this.listFile.getAbsolutePath();
            log.error((Object)msg, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public int getPartition(BlobMessage message, int partitions) {
        return (int)this.count % partitions;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.fileIterator = null;
        if (this.lines != null) {
            this.lines.close();
        }
        this.lines = null;
    }

    @Override
    public boolean hasNext() {
        if (this.nbBlobs > 0L && this.count >= this.nbBlobs) {
            return false;
        }
        if (!this.fileIterator.hasNext()) {
            if (this.nbBlobs == 0L) {
                return false;
            }
            this.getFileIterator();
        }
        return true;
    }

    @Override
    public BlobMessage next() {
        String filePath = this.fileIterator.next();
        ++this.count;
        return new BlobMessage.FileMessageBuilder(new File(this.basePath, filePath).toString()).build();
    }
}

