/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.producer;

import java.util.Collections;
import org.nuxeo.importer.stream.StreamImporters;
import org.nuxeo.importer.stream.message.BlobInfoMessage;
import org.nuxeo.importer.stream.message.DocumentMessage;
import org.nuxeo.importer.stream.producer.RandomDocumentMessageProducer;
import org.nuxeo.importer.stream.producer.RandomLogBlobInfoFetcher;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.pattern.producer.ProducerFactory;
import org.nuxeo.lib.stream.pattern.producer.ProducerIterator;

public class RandomDocumentMessageProducerFactory
implements ProducerFactory<DocumentMessage> {
    protected final long nbDocuments;
    protected final String lang;
    protected final int blobSizeKb;
    protected final LogManager manager;
    protected final String logName;
    protected final boolean countFolderAsDocument;

    public RandomDocumentMessageProducerFactory(long nbDocuments, String lang, int blobSizeKb) {
        this(nbDocuments, lang, blobSizeKb, true);
    }

    public RandomDocumentMessageProducerFactory(long nbDocuments, String lang, int blobSizeKb, Boolean countFolderAsDocument) {
        this.nbDocuments = nbDocuments;
        this.lang = lang;
        this.manager = null;
        this.blobSizeKb = blobSizeKb;
        this.logName = null;
        this.countFolderAsDocument = countFolderAsDocument;
    }

    public RandomDocumentMessageProducerFactory(long nbDocuments, String lang, LogManager manager, String logBlobInfoName, Boolean countFolderAsDocument) {
        this.nbDocuments = nbDocuments;
        this.lang = lang;
        this.manager = manager;
        this.logName = logBlobInfoName;
        this.blobSizeKb = 0;
        this.countFolderAsDocument = countFolderAsDocument;
    }

    public RandomDocumentMessageProducerFactory(long nbDocuments, String lang, LogManager manager, String logBlobInfoName) {
        this(nbDocuments, lang, manager, logBlobInfoName, true);
    }

    @Override
    public ProducerIterator<DocumentMessage> createProducer(int producerId) {
        RandomLogBlobInfoFetcher fetcher = null;
        if (this.manager != null) {
            Codec<BlobInfoMessage> blobInfoCodec = StreamImporters.getBlobInfoCodec();
            LogTailer tailer = this.manager.createTailer(this.getGroupName(producerId), Collections.singleton(LogPartition.of((String)this.logName, (int)0)), blobInfoCodec);
            fetcher = new RandomLogBlobInfoFetcher((LogTailer<BlobInfoMessage>)tailer);
        }
        return new RandomDocumentMessageProducer(producerId, this.nbDocuments, this.lang, fetcher).withBlob(this.blobSizeKb, false).countFolderAsDocument(this.countFolderAsDocument);
    }

    protected String getGroupName(int producerId) {
        return "RandomDocumentMessageProducer." + producerId;
    }
}

