/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.producer;

import java.time.Duration;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.importer.stream.message.BlobInfoMessage;
import org.nuxeo.importer.stream.message.DocumentMessage;
import org.nuxeo.importer.stream.producer.BlobInfoFetcher;
import org.nuxeo.lib.stream.log.LogRecord;
import org.nuxeo.lib.stream.log.LogTailer;

public class RandomLogBlobInfoFetcher
implements BlobInfoFetcher {
    protected static final int READ_DELAY_MS = 100;
    protected final LogTailer<BlobInfoMessage> tailer;
    protected boolean first;

    public RandomLogBlobInfoFetcher(LogTailer<BlobInfoMessage> blobInfoTailer) {
        this.tailer = blobInfoTailer;
        this.first = true;
    }

    @Override
    public BlobInfo get(DocumentMessage.Builder builder) {
        LogRecord record;
        try {
            record = this.tailer.read(Duration.ofMillis(100L));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        if (record == null) {
            if (this.first) {
                return null;
            }
            this.tailer.toStart();
            return this.get(builder);
        }
        this.first = false;
        return (BlobInfo)record.message();
    }

    @Override
    public void close() {
        this.tailer.close();
    }
}

