/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.importer.stream.producer;

import java.util.concurrent.ThreadLocalRandom;
import org.nuxeo.ecm.platform.importer.random.DictionaryHolder;
import org.nuxeo.ecm.platform.importer.random.HunspellDictionaryHolder;
import org.nuxeo.ecm.platform.importer.random.RandomTextGenerator;
import org.nuxeo.importer.stream.message.BlobMessage;
import org.nuxeo.importer.stream.producer.RandomDocumentMessageProducer;
import org.nuxeo.lib.stream.pattern.producer.AbstractProducer;

public class RandomStringBlobMessageProducer
extends AbstractProducer<BlobMessage> {
    protected static final String DEFAULT_MIME_TYPE = "plain/text";
    protected final long nbBlobs;
    protected final int averageSizeKB;
    protected final ThreadLocalRandom rand;
    protected final String marker;
    protected long count = 0L;
    protected static RandomTextGenerator gen;
    protected final String mimetype;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomStringBlobMessageProducer(int producerId, long nbBlobs, String lang, int averageSizeKB, String marker) {
        super(producerId);
        this.nbBlobs = nbBlobs;
        this.averageSizeKB = averageSizeKB;
        this.mimetype = DEFAULT_MIME_TYPE;
        this.marker = marker != null ? marker.trim() + " " : "";
        Class<RandomDocumentMessageProducer> clazz = RandomDocumentMessageProducer.class;
        synchronized (RandomDocumentMessageProducer.class) {
            if (gen == null) {
                gen = new RandomTextGenerator((DictionaryHolder)new HunspellDictionaryHolder(lang));
                gen.prefilCache();
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            this.rand = ThreadLocalRandom.current();
            return;
        }
    }

    @Override
    public int getPartition(BlobMessage message, int partitions) {
        return (int)this.count % partitions;
    }

    @Override
    public boolean hasNext() {
        return this.count < this.nbBlobs;
    }

    @Override
    public BlobMessage next() {
        String filename = this.generateFilename();
        String content = this.generateContent();
        BlobMessage ret = new BlobMessage.StringMessageBuilder(content).setFilename(filename).setMimetype(this.mimetype).build();
        ++this.count;
        return ret;
    }

    protected String generateFilename() {
        return gen.getRandomTitle(this.rand.nextInt(4) + 1).trim().replaceAll("\\W+", "-").toLowerCase() + ".txt";
    }

    protected String generateContent() {
        return this.marker + gen.getRandomText(this.averageSizeKB);
    }
}

