/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.pattern.consumer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.kafka.KafkaUtils;
import org.nuxeo.lib.stream.pattern.Message;
import org.nuxeo.lib.stream.pattern.consumer.ConsumerFactory;
import org.nuxeo.lib.stream.pattern.consumer.ConsumerPolicy;
import org.nuxeo.lib.stream.pattern.consumer.ConsumerStatus;
import org.nuxeo.lib.stream.pattern.consumer.internals.AbstractCallablePool;
import org.nuxeo.lib.stream.pattern.consumer.internals.ConsumerRunner;

public class ConsumerPool<M extends Message>
extends AbstractCallablePool<ConsumerStatus> {
    private static final Log log = LogFactory.getLog(ConsumerPool.class);
    protected final String logName;
    protected final LogManager manager;
    protected final Codec<M> codec;
    protected final ConsumerFactory<M> factory;
    protected final ConsumerPolicy policy;
    protected final List<List<LogPartition>> defaultAssignments;

    @Deprecated
    public ConsumerPool(String logName, LogManager manager, ConsumerFactory<M> factory, ConsumerPolicy policy) {
        this(logName, manager, (Codec<M>)NoCodec.NO_CODEC, factory, policy);
    }

    public ConsumerPool(String logName, LogManager manager, Codec<M> codec, ConsumerFactory<M> factory, ConsumerPolicy policy) {
        super(ConsumerPool.computeNbThreads((short)manager.getAppender(logName).size(), policy.getMaxThreads()));
        this.logName = logName;
        this.manager = manager;
        this.codec = codec;
        this.factory = factory;
        this.policy = policy;
        this.defaultAssignments = this.getDefaultAssignments();
        if (manager.supportSubscribe()) {
            log.info((Object)("Creating consumer pool using Log subscribe on " + logName));
        } else {
            log.info((Object)("Creating consumer pool using Log assignments on " + logName + ": " + this.defaultAssignments));
        }
    }

    protected static short computeNbThreads(short maxConcurrency, short maxThreads) {
        if (maxThreads > 0) {
            return (short)Math.min(maxConcurrency, maxThreads);
        }
        return maxConcurrency;
    }

    public String getConsumerGroupName() {
        return this.policy.getName();
    }

    @Override
    protected ConsumerStatus getErrorStatus() {
        return new ConsumerStatus("error", 0L, 0L, 0L, 0L, 0L, 0L, true);
    }

    @Override
    protected Callable<ConsumerStatus> getCallable(int i) {
        return new ConsumerRunner<M>(this.factory, this.policy, this.manager, this.codec, this.defaultAssignments.get(i));
    }

    @Override
    protected String getThreadPrefix() {
        return "Nuxeo-Consumer";
    }

    @Override
    protected void afterCall(List<ConsumerStatus> ret) {
        ret.forEach(arg_0 -> ((Log)log).info(arg_0));
        log.warn((Object)ConsumerStatus.toString(ret));
    }

    protected List<List<LogPartition>> getDefaultAssignments() {
        Map<String, Integer> streams = Collections.singletonMap(this.logName, this.manager.getAppender(this.logName).size());
        return KafkaUtils.roundRobinAssignments((int)this.getNbThreads(), streams);
    }
}

