/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.pattern.consumer.internals;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.Timer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.jodah.failsafe.Execution;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.LogPartition;
import org.nuxeo.lib.stream.log.LogRecord;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.log.RebalanceException;
import org.nuxeo.lib.stream.log.RebalanceListener;
import org.nuxeo.lib.stream.pattern.Message;
import org.nuxeo.lib.stream.pattern.consumer.BatchPolicy;
import org.nuxeo.lib.stream.pattern.consumer.Consumer;
import org.nuxeo.lib.stream.pattern.consumer.ConsumerFactory;
import org.nuxeo.lib.stream.pattern.consumer.ConsumerPolicy;
import org.nuxeo.lib.stream.pattern.consumer.ConsumerStatus;
import org.nuxeo.lib.stream.pattern.consumer.internals.BatchState;

public class ConsumerRunner<M extends Message>
implements Callable<ConsumerStatus>,
RebalanceListener {
    private static final Log log = LogFactory.getLog(ConsumerRunner.class);
    public static final String NUXEO_METRICS_REGISTRY_NAME = "org.nuxeo.runtime.metrics.MetricsService";
    protected final ConsumerFactory<M> factory;
    protected final ConsumerPolicy policy;
    protected final LogTailer<M> tailer;
    protected String consumerId;
    protected BatchPolicy currentBatchPolicy;
    protected String threadName;
    protected Consumer<M> consumer;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)"org.nuxeo.runtime.metrics.MetricsService");
    protected long acceptCounter;
    protected long committedCounter;
    protected long batchCommitCounter;
    protected long batchFailureCounter;
    protected boolean alreadySalted;
    protected Timer globalAcceptTimer;
    protected Counter globalCommittedCounter;
    protected Timer globalBatchCommitTimer;
    protected Counter globalBatchFailureCounter;
    protected Counter globalConsumersCounter;

    @Deprecated
    public ConsumerRunner(ConsumerFactory<M> factory, ConsumerPolicy policy, LogManager manager, List<LogPartition> defaultAssignments) {
        this(factory, policy, manager, (Codec<M>)NoCodec.NO_CODEC, defaultAssignments);
    }

    public ConsumerRunner(ConsumerFactory<M> factory, ConsumerPolicy policy, LogManager manager, Codec<M> codec, List<LogPartition> defaultAssignments) {
        this.factory = factory;
        this.currentBatchPolicy = policy.getBatchPolicy();
        this.policy = policy;
        this.tailer = this.createTailer(manager, codec, defaultAssignments);
        this.consumerId = this.tailer.toString();
        this.globalConsumersCounter = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"importer", "stream", "consumers"}));
        this.setTailerPosition(manager);
        log.debug((Object)("Consumer thread created tailing on: " + this.consumerId));
    }

    protected LogTailer<M> createTailer(LogManager manager, Codec<M> codec, List<LogPartition> defaultAssignments) {
        LogTailer tailer;
        if (manager.supportSubscribe()) {
            Set names = defaultAssignments.stream().map(LogPartition::name).collect(Collectors.toSet());
            tailer = manager.subscribe(this.policy.getName(), names, (RebalanceListener)this, codec);
        } else {
            tailer = manager.createTailer(this.policy.getName(), defaultAssignments, codec);
        }
        return tailer;
    }

    @Override
    public ConsumerStatus call() throws Exception {
        this.threadName = Thread.currentThread().getName();
        this.setMetrics();
        this.globalConsumersCounter.inc();
        long start = System.currentTimeMillis();
        this.consumer = this.factory.createConsumer(this.consumerId);
        try {
            this.consumerLoop();
        }
        finally {
            this.consumer.close();
            this.globalConsumersCounter.dec();
            this.tailer.close();
        }
        return new ConsumerStatus(this.consumerId, this.acceptCounter, this.committedCounter, this.batchCommitCounter, this.batchFailureCounter, start, System.currentTimeMillis(), false);
    }

    protected void setMetrics() {
        this.globalAcceptTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"importer", "stream", "consumer", "accepted"}));
        this.globalCommittedCounter = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"importer", "stream", "consumer", "committed"}));
        this.globalBatchFailureCounter = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"importer", "stream", "consumer", "batchFailure"}));
        this.globalBatchCommitTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"importer", "stream", "consumer", "batchCommit"}));
    }

    protected void addSalt() throws InterruptedException {
        if (this.alreadySalted) {
            return;
        }
        if (this.policy.isSalted()) {
            long randomDelay = ThreadLocalRandom.current().nextLong(this.policy.getBatchPolicy().getTimeThreshold().toMillis());
            Thread.sleep(randomDelay);
        }
        this.alreadySalted = true;
    }

    protected void setTailerPosition(LogManager manager) {
        ConsumerPolicy.StartOffset seekPosition = this.policy.getStartOffset();
        if (manager.supportSubscribe() && seekPosition != ConsumerPolicy.StartOffset.LAST_COMMITTED) {
            throw new UnsupportedOperationException("Tailer startOffset to " + seekPosition + " is not supported in subscribe mode");
        }
        switch (this.policy.getStartOffset()) {
            case BEGIN: {
                this.tailer.toStart();
                break;
            }
            case END: {
                this.tailer.toEnd();
                break;
            }
            default: {
                this.tailer.toLastCommitted();
            }
        }
    }

    protected void consumerLoop() throws InterruptedException {
        boolean end = false;
        while (!end) {
            Execution execution = new Execution(this.policy.getRetryPolicy());
            end = this.processBatchWithRetry(execution);
            if (execution.getLastFailure() == null) continue;
            if (this.policy.continueOnFailure()) {
                log.error((Object)"Skip message on failure after applying the retry policy: ", execution.getLastFailure());
                continue;
            }
            log.error((Object)"Abort on Failure after applying the retry policy: ", execution.getLastFailure());
            end = true;
        }
    }

    protected boolean processBatchWithRetry(Execution execution) throws InterruptedException {
        boolean end = false;
        while (!execution.isComplete()) {
            try {
                end = this.processBatch();
                this.tailer.commit();
                execution.complete();
            }
            catch (Throwable t) {
                this.globalBatchFailureCounter.inc();
                ++this.batchFailureCounter;
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    throw t;
                }
                if (t instanceof RebalanceException) {
                    log.info((Object)"Rebalance");
                }
                if (execution.canRetryOn(t)) {
                    this.setBatchRetryPolicy();
                    this.tailer.toLastCommitted();
                }
                throw t;
            }
            this.restoreBatchPolicy();
        }
        return end;
    }

    protected void setBatchRetryPolicy() {
        this.currentBatchPolicy = BatchPolicy.NO_BATCH;
    }

    protected void restoreBatchPolicy() {
        this.currentBatchPolicy = this.policy.getBatchPolicy();
    }

    protected boolean processBatch() throws InterruptedException {
        boolean end = false;
        this.beginBatch();
        try {
            BatchState state = this.acceptBatch();
            this.commitBatch(state);
            if (state.getState() == BatchState.State.LAST) {
                log.info((Object)("No more message on tailer: " + this.tailer));
                end = true;
            }
        }
        catch (Exception e) {
            try {
                this.rollbackBatch(e);
            }
            catch (Exception rollbackException) {
                log.error((Object)"Exception on rollback invocation", (Throwable)rollbackException);
            }
            throw e;
        }
        return end;
    }

    protected void beginBatch() {
        this.consumer.begin();
    }

    protected void commitBatch(BatchState state) {
        try (Timer.Context ignore = this.globalBatchCommitTimer.time();){
            this.consumer.commit();
            this.committedCounter += (long)state.getSize();
            this.globalCommittedCounter.inc((long)state.getSize());
            ++this.batchCommitCounter;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Commit batch size: " + state.getSize() + ", total committed: " + this.committedCounter));
            }
        }
    }

    protected void rollbackBatch(Exception e) {
        if (e instanceof RebalanceException) {
            log.warn((Object)"Rollback current batch because of consumer rebalancing");
        } else {
            log.warn((Object)"Rollback batch", (Throwable)e);
        }
        this.consumer.rollback();
    }

    protected BatchState acceptBatch() throws InterruptedException {
        LogRecord record;
        BatchState batch = new BatchState(this.currentBatchPolicy);
        batch.start();
        while ((record = this.tailer.read(this.policy.getWaitMessageTimeout())) != null) {
            this.addSalt();
            Message message = (Message)record.message();
            if (message.poisonPill()) {
                log.warn((Object)("Receive a poison pill: " + message));
                batch.last();
            } else {
                try (Timer.Context ignore = this.globalAcceptTimer.time();){
                    this.setThreadName(message.getId());
                    this.consumer.accept(message);
                    ++this.acceptCounter;
                }
                batch.inc();
                if (message.forceBatch()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Force end of batch: " + message));
                    }
                    batch.force();
                }
            }
            if (batch.getState() == BatchState.State.FILLING) continue;
            return batch;
        }
        batch.last();
        log.info((Object)String.format("No record after: %ds on %s, terminating", this.policy.getWaitMessageTimeout().getSeconds(), this.consumerId));
        return batch;
    }

    protected void setThreadName(String message) {
        String name = this.threadName + "-" + this.acceptCounter + "-" + message;
        Thread.currentThread().setName(name);
    }

    public void onPartitionsRevoked(Collection<LogPartition> partitions) {
    }

    public void onPartitionsAssigned(Collection<LogPartition> partitions) {
        this.consumerId = this.tailer.toString();
        this.setThreadName("rebalance-" + this.consumerId);
    }
}

