/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.pattern.producer;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.pattern.Message;
import org.nuxeo.lib.stream.pattern.consumer.internals.AbstractCallablePool;
import org.nuxeo.lib.stream.pattern.producer.ProducerFactory;
import org.nuxeo.lib.stream.pattern.producer.ProducerStatus;
import org.nuxeo.lib.stream.pattern.producer.internals.ProducerRunner;

public class ProducerPool<M extends Message>
extends AbstractCallablePool<ProducerStatus> {
    private static final Log log = LogFactory.getLog(ProducerPool.class);
    protected final LogManager manager;
    protected final String logName;
    protected final Codec<M> codec;
    protected final ProducerFactory<M> factory;

    @Deprecated
    public ProducerPool(String logName, LogManager manager, ProducerFactory<M> factory, short nbThreads) {
        this(logName, manager, (Codec<M>)NoCodec.NO_CODEC, factory, nbThreads);
    }

    public ProducerPool(String logName, LogManager manager, Codec<M> codec, ProducerFactory<M> factory, short nbThreads) {
        super(nbThreads);
        this.logName = logName;
        this.manager = manager;
        this.codec = codec;
        this.factory = factory;
    }

    @Override
    protected ProducerStatus getErrorStatus() {
        return new ProducerStatus(0, 0L, 0L, 0L, true);
    }

    @Override
    protected Callable<ProducerStatus> getCallable(int i) {
        return new ProducerRunner<M>(this.factory, this.manager.getAppender(this.logName, this.codec), i);
    }

    @Override
    protected String getThreadPrefix() {
        return "Nuxeo-Producer";
    }

    @Override
    protected void afterCall(List<ProducerStatus> ret) {
        ret.forEach(arg_0 -> ((Log)log).info(arg_0));
        log.warn((Object)ProducerStatus.toString(ret));
    }
}

