/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.pattern.producer;

import java.util.List;

public class ProducerStatus {
    public final long startTime;
    public final long stopTime;
    public final long nbProcessed;
    public final int producer;
    protected final boolean fail;

    public ProducerStatus(int producer, long nbProcessed, long startTime, long stopTime, boolean fail) {
        this.producer = producer;
        this.nbProcessed = nbProcessed;
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.fail = fail;
    }

    public String toString() {
        if (this.fail) {
            return "Producer status FAILURE";
        }
        double elapsed = (double)(this.stopTime - this.startTime) / 1000.0;
        double mps = elapsed != 0.0 ? (double)this.nbProcessed / elapsed : 0.0;
        return String.format("Producer %02d status: messages: %d, elapsed: %.2fs, throughput: %.2f msg/s.", this.producer, this.nbProcessed, elapsed, mps);
    }

    static String toString(List<ProducerStatus> stats) {
        long startTime = stats.stream().mapToLong(r -> r.startTime).min().orElse(0L);
        long stopTime = stats.stream().mapToLong(r -> r.stopTime).max().orElse(0L);
        double elapsed = (double)(stopTime - startTime) / 1000.0;
        long messages = stats.stream().mapToLong(r -> r.nbProcessed).sum();
        double mps = elapsed != 0.0 ? (double)messages / elapsed : 0.0;
        int producers = stats.size();
        long failures = stats.stream().filter(s -> s.fail).count();
        return String.format("Producers status: threads: %d, failures: %d, messages: %d, elapsed: %.2fs, throughput: %.2f msg/s", producers, failures, messages, elapsed, mps);
    }
}

