/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.pattern.producer.internals;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.Timer;
import java.io.Externalizable;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.log.LogAppender;
import org.nuxeo.lib.stream.pattern.Message;
import org.nuxeo.lib.stream.pattern.producer.ProducerFactory;
import org.nuxeo.lib.stream.pattern.producer.ProducerIterator;
import org.nuxeo.lib.stream.pattern.producer.ProducerStatus;

public class ProducerRunner<M extends Message>
implements Callable<ProducerStatus> {
    private static final Log log = LogFactory.getLog(ProducerRunner.class);
    protected final int producerId;
    protected final LogAppender<M> appender;
    protected final ProducerFactory<M> factory;
    protected String threadName;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)"org.nuxeo.runtime.metrics.MetricsService");
    protected final Timer producerTimer;
    protected final Counter producersCount;
    protected long counter;

    public ProducerRunner(ProducerFactory<M> factory, LogAppender<M> appender, int producerId) {
        this.factory = factory;
        this.producerId = producerId;
        this.appender = appender;
        this.producerTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"importer", "stream", "producer"}));
        this.producersCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"importer", "stream", "producers"}));
        log.debug((Object)("ProducerIterator thread created: " + producerId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProducerStatus call() throws Exception {
        this.threadName = Thread.currentThread().getName();
        long start = System.currentTimeMillis();
        this.producersCount.inc();
        try (ProducerIterator<M> producer = this.factory.createProducer(this.producerId);){
            this.producerLoop(producer);
        }
        finally {
            this.producersCount.dec();
        }
        return new ProducerStatus(this.producerId, this.counter, start, System.currentTimeMillis(), false);
    }

    protected void producerLoop(ProducerIterator<M> producer) {
        while (producer.hasNext()) {
            Message message;
            try (Timer.Context ignored = this.producerTimer.time();){
                message = (Message)producer.next();
                this.setThreadName(message);
                ++this.counter;
            }
            this.appender.append(producer.getPartition(message, this.appender.size()), (Externalizable)message);
        }
    }

    protected void setThreadName(M message) {
        String name = this.threadName + "-" + this.counter;
        name = message != null ? name + "-" + message.getId() : name + "-null";
        Thread.currentThread().setName(name);
    }
}

