/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant;

import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.multi.tenant.MultiTenantService;
import org.nuxeo.runtime.api.Framework;

public class MultiTenantListener
implements EventListener {
    public void handleEvent(Event event) {
        String eventName;
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        MultiTenantService multiTenantService = (MultiTenantService)Framework.getService(MultiTenantService.class);
        String tenantDocumentType = multiTenantService.getTenantDocumentType();
        DocumentModel doc = ((DocumentEventContext)ctx).getSourceDocument();
        if (!doc.getType().equals(tenantDocumentType)) {
            return;
        }
        CoreSession session = ctx.getCoreSession();
        if (!multiTenantService.isTenantIsolationEnabled(session)) {
            return;
        }
        switch (eventName = event.getName()) {
            case "documentCreated": 
            case "documentCreatedByCopy": 
            case "documentUntrashed": {
                multiTenantService.enableTenantIsolationFor(session, doc);
                break;
            }
            case "documentRemoved": 
            case "documentTrashed": {
                multiTenantService.disableTenantIsolationFor(session, doc);
                break;
            }
            case "lifecycle_transition_event": {
                String transition = (String)((Object)ctx.getProperty("transition"));
                if ("delete".equals(transition)) {
                    multiTenantService.disableTenantIsolationFor(session, doc);
                    break;
                }
                if (!"undelete".equals(transition)) break;
                multiTenantService.enableTenantIsolationFor(session, doc);
            }
        }
        session.save();
    }
}

