/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.openid;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.platform.oauth2.openid.OpenIDConnectProvider;
import org.nuxeo.ecm.platform.oauth2.openid.OpenIDConnectProviderDescriptor;
import org.nuxeo.ecm.platform.oauth2.openid.OpenIDConnectProviderRegistry;
import org.nuxeo.ecm.platform.oauth2.openid.RedirectUriResolver;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.ecm.platform.ui.web.auth.LoginScreenHelper;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginProviderLinkComputer;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class OpenIDConnectProviderRegistryImpl
extends DefaultComponent
implements OpenIDConnectProviderRegistry {
    protected static final Logger log = LogManager.getLogger(OpenIDConnectProviderRegistryImpl.class);
    public static final String PROVIDER_EP = "providers";
    protected Map<String, OpenIDConnectProvider> providers = new HashMap<String, OpenIDConnectProvider>();

    protected OAuth2ServiceProviderRegistry getOAuth2ServiceProviderRegistry() {
        return (OAuth2ServiceProviderRegistry)Framework.getService(OAuth2ServiceProviderRegistry.class);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (PROVIDER_EP.equals(extensionPoint)) {
            OpenIDConnectProviderDescriptor provider = (OpenIDConnectProviderDescriptor)contribution;
            if (provider.getClientId() == null || provider.getClientSecret() == null) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = provider::getName;
                supplierArray[1] = () -> ((ComponentInstance)contributor).getName();
                log.info("OpenId provider for {} is disabled because clientId and/or clientSecret are empty (component id = {})", supplierArray);
                provider.setEnabled(false);
            }
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = provider::getName;
            log.info("OpenId provider for {} will be registred at application startup", supplierArray);
            this.register(PROVIDER_EP, provider);
        }
    }

    @Override
    public Collection<OpenIDConnectProvider> getProviders() {
        return this.providers.values();
    }

    @Override
    public Collection<OpenIDConnectProvider> getEnabledProviders() {
        return this.getProviders().stream().filter(OpenIDConnectProvider::isEnabled).collect(Collectors.toList());
    }

    @Override
    public OpenIDConnectProvider getProvider(String name) {
        return this.providers.get(name);
    }

    protected void registerPendingProviders() {
        List providers = this.getDescriptors(PROVIDER_EP);
        for (OpenIDConnectProviderDescriptor provider : providers) {
            if (!provider.isEnabled()) continue;
            this.registerOpenIdProvider(provider);
        }
    }

    protected void registerOpenIdProvider(OpenIDConnectProviderDescriptor provider) {
        RedirectUriResolver redirectUriResolver;
        OAuth2ServiceProviderRegistry oauth2ProviderRegistry = this.getOAuth2ServiceProviderRegistry();
        try {
            redirectUriResolver = provider.getRedirectUriResolver().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        if (oauth2ProviderRegistry != null) {
            OAuth2ServiceProvider oauth2Provider = oauth2ProviderRegistry.getProvider(provider.getName());
            if (oauth2Provider == null) {
                oauth2Provider = oauth2ProviderRegistry.addProvider(provider.getName(), provider.getDescription(), provider.getTokenServerURL(), provider.getAuthorizationServerURL(), provider.getClientId(), provider.getClientSecret(), Arrays.asList(provider.getScopes()));
            } else {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = provider::getName;
                log.warn("Provider {} is already in the Database, XML contribution  won't overwrite it", supplierArray);
            }
            this.providers.put(provider.getName(), new OpenIDConnectProvider(oauth2Provider, provider.getAccessTokenKey(), provider.getUserInfoURL(), provider.getUserInfoClass(), provider.getIcon(), provider.isEnabled(), redirectUriResolver, provider.getUserResolverClass(), provider.getUserMapper(), provider.getAuthenticationMethod()));
            LoginScreenHelper.registerSingleProviderLoginScreenConfig((String)provider.getName(), (String)provider.getIcon(), (String)provider.getUserInfoURL(), (String)provider.getLabel(), (String)provider.getDescription(), (LoginProviderLinkComputer)this.providers.get(provider.getName()));
        } else if (Framework.isTestModeSet()) {
            this.providers.put(provider.getName(), new OpenIDConnectProvider(null, provider.getAccessTokenKey(), provider.getUserInfoURL(), provider.getUserInfoClass(), provider.getIcon(), provider.isEnabled(), redirectUriResolver, provider.getUserResolverClass(), provider.getUserMapper(), provider.getAuthenticationMethod()));
        } else {
            log.error("Can not register OAuth Provider since OAuth Registry is not available");
        }
    }

    public void start(ComponentContext context) {
        this.registerPendingProviders();
    }
}

