/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.openid.auth.github;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.Key;
import java.util.Date;
import org.nuxeo.ecm.platform.oauth2.openid.auth.OpenIDUserInfo;

public class GithubUserInfo
extends GenericJson
implements OpenIDUserInfo {
    @Key(value="sub")
    protected String subject;
    @Key(value="name")
    protected String name;
    @Key(value="given_name")
    protected String givenName;
    @Key(value="family_name")
    protected String familyName;
    @Key(value="middle_name")
    protected String middleName;
    @Key(value="nickname")
    protected String nickname;
    @Key(value="preferred_username")
    protected String preferredUsername;
    @Key(value="profile")
    protected String profile;
    @Key(value="picture")
    protected String picture;
    @Key(value="website")
    protected String website;
    @Key(value="email")
    protected String email;
    @Key(value="email_verified")
    protected boolean emailVerified;
    @Key(value="gender")
    protected String gender;
    @Key(value="birthdate")
    protected Date birthdate;
    @Key(value="zoneinfo")
    protected String zoneInfo;
    @Key(value="locale")
    protected String locale;
    @Key(value="phone_number")
    protected String phoneNumber;
    @Key(value="address")
    protected String address;
    @Key(value="updated_time")
    protected String updatedTime;
    @Key
    protected String bio;
    @Key
    protected String blog;
    @Key
    protected String company;
    @Key(value="login")
    protected String login;

    @Override
    public String getSubject() {
        return this.getEmail();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMiddleName() {
        return this.middleName;
    }

    @Override
    public String getPreferredUsername() {
        return this.preferredUsername;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public String getPicture() {
        return this.picture;
    }

    @Override
    public String getWebsite() {
        return this.website;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    @Override
    public String getGender() {
        return this.gender;
    }

    @Override
    public Date getBirthdate() {
        return this.birthdate;
    }

    @Override
    public String getZoneInfo() {
        return this.zoneInfo;
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public Date getUpdatedTime() {
        Date date;
        try {
            DateTime dateTime = DateTime.parseRfc3339((String)this.updatedTime);
            date = new Date(dateTime.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
        return date;
    }

    @Override
    public String getGivenName() {
        return this.splitNameField(0);
    }

    @Override
    public String getFamilyName() {
        return this.splitNameField(1);
    }

    @Override
    public String getNickname() {
        return this.login;
    }

    public String getBlog() {
        return this.blog;
    }

    public String getBio() {
        return this.bio;
    }

    public String getCompany() {
        return this.company;
    }

    public String getLogin() {
        return this.login;
    }

    public String splitNameField(int index) {
        String[] strings = this.name.split(" ");
        if (index >= strings.length) {
            return this.name;
        }
        return strings[index];
    }
}

