/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security;

import java.security.Key;
import java.security.interfaces.DSAParams;
import java.util.HashMap;
import java.util.Map;
import org.opensaml.xml.security.SecurityConfiguration;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSecurityConfiguration
implements SecurityConfiguration {
    public static final String KEYINFO_RESOLVER_DEFAULT_CONFIG = "_KEYINFO_RESOLVER_DEFAULT_";
    private final Logger log = LoggerFactory.getLogger(BasicSecurityConfiguration.class);
    private Map<String, String> signatureAlgorithms = new HashMap<String, String>();
    private String signatureCanonicalization;
    private String signatureReferenceDigestMethod;
    private Integer signatureHMACOutputLength;
    private Map<DataEncryptionIndex, String> dataEncryptionAlgorithms = new HashMap<DataEncryptionIndex, String>();
    private Map<KeyTransportEncryptionIndex, String> keyTransportEncryptionAlgorithms = new HashMap<KeyTransportEncryptionIndex, String>();
    private String autoGenEncryptionURI;
    private NamedKeyInfoGeneratorManager keyInfoGeneratorManager;
    private Map<String, KeyInfoCredentialResolver> keyInfoCredentialResolvers = new HashMap<String, KeyInfoCredentialResolver>();
    private Map<Integer, DSAParams> dsaParams = new HashMap<Integer, DSAParams>();

    @Override
    public String getSignatureAlgorithmURI(String jcaAlgorithmName) {
        return this.signatureAlgorithms.get(jcaAlgorithmName);
    }

    @Override
    public String getSignatureAlgorithmURI(Credential credential) {
        Key key = SecurityHelper.extractSigningKey(credential);
        if (key == null) {
            this.log.debug("Could not extract signing key from credential, unable to map to algorithm URI");
            return null;
        }
        if (key.getAlgorithm() == null) {
            this.log.debug("Signing key algorithm value was not available, unable to map to algorithm URI");
            return null;
        }
        return this.getSignatureAlgorithmURI(key.getAlgorithm());
    }

    public void registerSignatureAlgorithmURI(String jcaAlgorithmName, String algorithmURI) {
        this.signatureAlgorithms.put(jcaAlgorithmName, algorithmURI);
    }

    public void deregisterSignatureAlgorithmURI(String jcaAlgorithmName) {
        this.signatureAlgorithms.remove(jcaAlgorithmName);
    }

    @Override
    public String getSignatureCanonicalizationAlgorithm() {
        return this.signatureCanonicalization;
    }

    public void setSignatureCanonicalizationAlgorithm(String algorithmURI) {
        this.signatureCanonicalization = algorithmURI;
    }

    @Override
    public String getSignatureReferenceDigestMethod() {
        return this.signatureReferenceDigestMethod;
    }

    public void setSignatureReferenceDigestMethod(String algorithmURI) {
        this.signatureReferenceDigestMethod = algorithmURI;
    }

    @Override
    public Integer getSignatureHMACOutputLength() {
        return this.signatureHMACOutputLength;
    }

    public void setSignatureHMACOutputLength(Integer length) {
        this.signatureHMACOutputLength = length;
    }

    @Override
    public String getDataEncryptionAlgorithmURI(String jcaAlgorithmName, Integer keyLength) {
        DataEncryptionIndex index = new DataEncryptionIndex(jcaAlgorithmName, keyLength);
        String algorithmURI = this.dataEncryptionAlgorithms.get(index);
        if (algorithmURI != null) {
            return algorithmURI;
        }
        if (keyLength != null) {
            this.log.debug("No data encryption algorithm mapping available for JCA name + key length, trying JCA name alone");
            index = new DataEncryptionIndex(jcaAlgorithmName, null);
            return this.dataEncryptionAlgorithms.get(index);
        }
        return null;
    }

    @Override
    public String getDataEncryptionAlgorithmURI(Credential credential) {
        Key key = SecurityHelper.extractEncryptionKey(credential);
        if (key == null) {
            this.log.debug("Could not extract data encryption key from credential, unable to map to algorithm URI");
            return null;
        }
        if (key.getAlgorithm() == null) {
            this.log.debug("Data encryption key algorithm value was not available, unable to map to algorithm URI");
            return null;
        }
        Integer length = SecurityHelper.getKeyLength(key);
        return this.getDataEncryptionAlgorithmURI(key.getAlgorithm(), length);
    }

    public void registerDataEncryptionAlgorithmURI(String jcaAlgorithmName, Integer keyLength, String algorithmURI) {
        DataEncryptionIndex index = new DataEncryptionIndex(jcaAlgorithmName, keyLength);
        this.dataEncryptionAlgorithms.put(index, algorithmURI);
    }

    public void deregisterDataEncryptionAlgorithmURI(String jcaAlgorithmName, Integer keyLength) {
        DataEncryptionIndex index = new DataEncryptionIndex(jcaAlgorithmName, keyLength);
        this.dataEncryptionAlgorithms.remove(index);
    }

    @Override
    public String getKeyTransportEncryptionAlgorithmURI(String jcaAlgorithmName, Integer keyLength, String wrappedKeyAlgorithm) {
        KeyTransportEncryptionIndex index = new KeyTransportEncryptionIndex(jcaAlgorithmName, keyLength, wrappedKeyAlgorithm);
        String algorithmURI = this.keyTransportEncryptionAlgorithms.get(index);
        if (algorithmURI != null) {
            return algorithmURI;
        }
        if (wrappedKeyAlgorithm != null) {
            this.log.debug("No data encryption algorithm mapping available for JCA name + key length + wrapped algorithm, trying JCA name + key length");
            index = new KeyTransportEncryptionIndex(jcaAlgorithmName, keyLength, null);
            algorithmURI = this.keyTransportEncryptionAlgorithms.get(index);
            if (algorithmURI != null) {
                return algorithmURI;
            }
        }
        if (keyLength != null) {
            this.log.debug("No data encryption algorithm mapping available for JCA name + key length + wrapped algorithm, trying JCA name + wrapped algorithm");
            index = new KeyTransportEncryptionIndex(jcaAlgorithmName, null, wrappedKeyAlgorithm);
            algorithmURI = this.keyTransportEncryptionAlgorithms.get(index);
            if (algorithmURI != null) {
                return algorithmURI;
            }
        }
        this.log.debug("No data encryption algorithm mapping available for JCA name + key length + wrapped algorithm, trying JCA name alone");
        index = new KeyTransportEncryptionIndex(jcaAlgorithmName, null, null);
        return this.keyTransportEncryptionAlgorithms.get(index);
    }

    @Override
    public String getKeyTransportEncryptionAlgorithmURI(Credential credential, String wrappedKeyAlgorithm) {
        Key key = SecurityHelper.extractEncryptionKey(credential);
        if (key == null) {
            this.log.debug("Could not extract key transport encryption key from credential, unable to map to algorithm URI");
            return null;
        }
        if (key.getAlgorithm() == null) {
            this.log.debug("Key transport encryption key algorithm value was not available, unable to map to algorithm URI");
            return null;
        }
        Integer length = SecurityHelper.getKeyLength(key);
        return this.getKeyTransportEncryptionAlgorithmURI(key.getAlgorithm(), length, wrappedKeyAlgorithm);
    }

    public void registerKeyTransportEncryptionAlgorithmURI(String jcaAlgorithmName, Integer keyLength, String wrappedKeyAlgorithm, String algorithmURI) {
        KeyTransportEncryptionIndex index = new KeyTransportEncryptionIndex(jcaAlgorithmName, keyLength, wrappedKeyAlgorithm);
        this.keyTransportEncryptionAlgorithms.put(index, algorithmURI);
    }

    public void deregisterKeyTransportEncryptionAlgorithmURI(String jcaAlgorithmName, Integer keyLength, String wrappedKeyAlgorithm) {
        KeyTransportEncryptionIndex index = new KeyTransportEncryptionIndex(jcaAlgorithmName, keyLength, wrappedKeyAlgorithm);
        this.keyTransportEncryptionAlgorithms.remove(index);
    }

    @Override
    public String getAutoGeneratedDataEncryptionKeyAlgorithmURI() {
        return this.autoGenEncryptionURI;
    }

    public void setAutoGeneratedDataEncryptionKeyAlgorithmURI(String algorithmURI) {
        this.autoGenEncryptionURI = algorithmURI;
    }

    @Override
    public NamedKeyInfoGeneratorManager getKeyInfoGeneratorManager() {
        return this.keyInfoGeneratorManager;
    }

    public void setKeyInfoGeneratorManager(NamedKeyInfoGeneratorManager keyInfoManager) {
        this.keyInfoGeneratorManager = keyInfoManager;
    }

    @Override
    public KeyInfoCredentialResolver getDefaultKeyInfoCredentialResolver() {
        return this.keyInfoCredentialResolvers.get(KEYINFO_RESOLVER_DEFAULT_CONFIG);
    }

    public void setDefaultKeyInfoCredentialResolver(KeyInfoCredentialResolver resolver) {
        this.keyInfoCredentialResolvers.put(KEYINFO_RESOLVER_DEFAULT_CONFIG, resolver);
    }

    @Override
    public KeyInfoCredentialResolver getKeyInfoCredentialResolver(String name) {
        return this.keyInfoCredentialResolvers.get(name);
    }

    public void registerKeyInfoCredentialResolver(String name, KeyInfoCredentialResolver resolver) {
        this.keyInfoCredentialResolvers.put(name, resolver);
    }

    public void deregisterKeyInfoCredentialResolver(String name) {
        this.keyInfoCredentialResolvers.remove(name);
    }

    @Override
    public DSAParams getDSAParams(int keyLength) {
        return this.dsaParams.get(keyLength);
    }

    public void setDSAParams(int keyLength, DSAParams params) {
        this.dsaParams.put(keyLength, params);
    }

    protected class KeyTransportEncryptionIndex {
        private String keyAlgorithm;
        private Integer keyLength;
        private String wrappedAlgorithm;

        protected KeyTransportEncryptionIndex(String jcaAlgorithmName, Integer length, String wrappedKeyAlgorithm) {
            if (DatatypeHelper.isEmpty(jcaAlgorithmName)) {
                throw new IllegalArgumentException("JCA Algorithm name may not be null or empty");
            }
            this.keyAlgorithm = DatatypeHelper.safeTrimOrNullString(jcaAlgorithmName);
            this.keyLength = length;
            this.wrappedAlgorithm = DatatypeHelper.safeTrimOrNullString(wrappedKeyAlgorithm);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof KeyTransportEncryptionIndex)) {
                return false;
            }
            KeyTransportEncryptionIndex other = (KeyTransportEncryptionIndex)obj;
            if (!this.keyAlgorithm.equals(other.keyAlgorithm)) {
                return false;
            }
            if (this.keyLength == null ? other.keyLength != null : !this.keyLength.equals(other.keyLength)) {
                return false;
            }
            if (this.wrappedAlgorithm == null) {
                return other.wrappedAlgorithm == null;
            }
            return this.wrappedAlgorithm.equals(other.wrappedAlgorithm);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.keyAlgorithm.hashCode();
            if (this.keyLength != null) {
                result = 37 * result + this.keyLength.hashCode();
            }
            if (this.wrappedAlgorithm != null) {
                result = 37 * result + this.wrappedAlgorithm.hashCode();
            }
            return result;
        }

        public String toString() {
            return String.format("[%s,%s,%s]", this.keyAlgorithm, this.keyLength, this.wrappedAlgorithm);
        }
    }

    protected class DataEncryptionIndex {
        private String keyAlgorithm;
        private Integer keyLength;

        protected DataEncryptionIndex(String jcaAlgorithmName, Integer length) {
            if (DatatypeHelper.isEmpty(jcaAlgorithmName)) {
                throw new IllegalArgumentException("JCA Algorithm name may not be null or empty");
            }
            this.keyAlgorithm = DatatypeHelper.safeTrimOrNullString(jcaAlgorithmName);
            this.keyLength = length;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DataEncryptionIndex)) {
                return false;
            }
            DataEncryptionIndex other = (DataEncryptionIndex)obj;
            if (!this.keyAlgorithm.equals(other.keyAlgorithm)) {
                return false;
            }
            if (this.keyLength == null) {
                return other.keyLength == null;
            }
            return this.keyLength.equals(other.keyLength);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.keyAlgorithm.hashCode();
            if (this.keyLength != null) {
                result = 37 * result + this.keyLength.hashCode();
            }
            return result;
        }

        public String toString() {
            return String.format("[%s,%s]", this.keyAlgorithm, this.keyLength);
        }
    }
}

