/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.connect;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.json.JSONArray;
import org.json.JSONException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectConnector;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.launcher.connect.ConnectBroker;
import org.nuxeo.launcher.connect.LauncherRestartException;
import org.nuxeo.launcher.connect.StandaloneCallbackHolder;
import org.nuxeo.launcher.connect.fake.LocalConnectFakeConnector;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LogCaptureFeature;
import org.nuxeo.runtime.test.runner.ServletContainerFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={LogCaptureFeature.class, ServletContainerFeature.class})
@Deploy(value={"org.nuxeo.connect.standalone.test:OSGI-INF/server-deploy-contrib.xml"})
public class TestConnectBroker {
    public static final String TEST_STORE_PATH = "src/test/resources/packages/store";
    public static final String TEST_LOCAL_ONLY_PATH = "src/test/resources/packages/store/local-only";
    public static final File testStore = new File("src/test/resources/packages/store");
    public static final File nuxeoHome = new File(FeaturesRunner.getBuildDirectory() + "/launcher");
    protected ConnectBroker connectBroker;
    private Environment environment;
    @Inject
    LogCaptureFeature.Result logCaptureResult;
    @Inject
    protected ServletContainerFeature servletContainerFeature;

    @Before
    public void setUpPort() {
        int port = this.servletContainerFeature.getPort();
        ConnectUrlConfig.setTestPort((int)port);
    }

    @Before
    public void beforeEach() throws Exception {
        String addonJSON = FileUtils.readFileToString((File)new File(testStore, "addon_remote.json"), (Charset)StandardCharsets.UTF_8);
        String hotfixJSON = FileUtils.readFileToString((File)new File(testStore, "hotfix_remote.json"), (Charset)StandardCharsets.UTF_8);
        String studioJSON = FileUtils.readFileToString((File)new File(testStore, "studio_remote.json"), (Charset)StandardCharsets.UTF_8);
        String addonWithPrivateJSON = FileUtils.readFileToString((File)new File(testStore, "addon_with_private_remote.json"), (Charset)StandardCharsets.UTF_8);
        NuxeoConnectClient.getConnectGatewayComponent().setTestConnector((ConnectConnector)new LocalConnectFakeConnector(addonJSON, hotfixJSON, studioJSON, addonWithPrivateJSON));
        Environment.setDefault(null);
        FileUtils.deleteQuietly((File)nuxeoHome);
        nuxeoHome.mkdirs();
        System.setProperty("nuxeo.home", nuxeoHome.getPath());
        System.setProperty("tomcat.home", Environment.getDefault().getServerHome().getPath());
        this.buildInitialPackageStore();
        this.environment = Environment.getDefault();
        this.environment.setProperty("org.nuxeo.distribution.name", "server");
        this.environment.setProperty("org.nuxeo.distribution.version", "8.3");
        this.environment.setProperty("launcher.changed", "false");
        this.connectBroker = new ConnectBroker(this.environment);
        this.connectBroker.setPendingFile(this.environment.getData().toPath().resolve("installAfterRestart.log"));
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
    }

    private void copyPackageToStore(File nuxeoStore, File uninstallFile, File pkgZip) {
        try {
            File pkgDir = new File(nuxeoStore, pkgZip.getName().replace(".zip", ""));
            ZipUtils.unzip((File)pkgZip, (File)pkgDir);
            FileUtils.copyFileToDirectory((File)uninstallFile, (File)pkgDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void buildInitialPackageStore() throws IOException {
        String[] unzippedPkgs;
        File nuxeoPackages = new File(nuxeoHome, "packages");
        File nuxeoStore = new File(nuxeoPackages, "store");
        File uninstallFile = new File(testStore, "uninstall.xml");
        FileUtils.iterateFiles((File)testStore, (String[])new String[]{"zip"}, (boolean)false).forEachRemaining(pkgZip -> this.copyPackageToStore(nuxeoStore, uninstallFile, (File)pkgZip));
        this.copyPackageToStore(nuxeoStore, uninstallFile, new File(TEST_LOCAL_ONLY_PATH, "K-1.0.0-SNAPSHOT.zip"));
        for (String pkg : unzippedPkgs = new String[]{"NXP-24507-A-1.0.0", "NXP-24507-B-1.0.0"}) {
            File sourceDir = new File(TEST_LOCAL_ONLY_PATH, pkg);
            File targetDir = new File(nuxeoStore, pkg);
            Assertions.assertThat((File)sourceDir).exists();
            FileUtils.copyDirectory((File)sourceDir, (File)targetDir);
        }
        FileUtils.copyFileToDirectory((File)new File(testStore, ".packages"), (File)nuxeoPackages);
    }

    @After
    public void afterEach() {
        System.clearProperty("nuxeo.home");
        System.clearProperty("tomcat.home");
        LogicalInstanceIdentifier.cleanUp();
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testListAllPackages() throws Exception {
        this.connectBroker.pkgListAll();
        String expectedLogs = "All packages:\nstudio     started\tstudioA (id: studioA-1.0.0) \nstudio  downloaded\tstudioA (id: studioA-1.0.1) \nstudio  downloaded\tstudioA (id: studioA-1.0.2-SNAPSHOT) \nhotfix     started\thfA (id: hfA-1.0.0) \nhotfix  downloaded\thfA (id: hfA-1.0.8) \nhotfix  downloaded\thfB (id: hfB-1.0.0) \nhotfix  downloaded\thfC (id: hfC-1.0.0-SNAPSHOT) \n addon     started\tA (id: A-1.0.0) \n addon  downloaded\tA (id: A-1.2.0) \n addon  downloaded\tA (id: A-1.2.1-SNAPSHOT) \n addon  downloaded\tA (id: A-1.2.2-SNAPSHOT) \n addon  downloaded\tA (id: A-1.2.2) \n addon  downloaded\tA (id: A-1.2.3-SNAPSHOT) \n addon     started\tB (id: B-1.0.1-SNAPSHOT) \n addon  downloaded\tB (id: B-1.0.1) \n addon  downloaded\tB (id: B-1.0.2) \n addon     started\tC (id: C-1.0.0) \n addon  downloaded\tC (id: C-1.0.1-SNAPSHOT) \n addon  downloaded\tC (id: C-1.0.2-SNAPSHOT) \n addon     started\tD (id: D-1.0.2-SNAPSHOT) \n addon  downloaded\tD (id: D-1.0.3-SNAPSHOT) \n addon  downloaded\tD (id: D-1.0.4-SNAPSHOT) \n addon     started\tG (id: G-1.0.1-SNAPSHOT) \n addon     started\tH (id: H-1.0.1-SNAPSHOT) \n addon     started\tJ (id: J-1.0.1) \n addon     started\tK (id: K-1.0.0-SNAPSHOT) \n addon  downloaded\tM (id: M-1.0.0-SNAPSHOT) \n addon      remote\tM (id: M-1.0.1) [REGISTRATION REQUIRED]\n addon  downloaded\tN (id: N-1.0.1-HF08-SNAPSHOT) \n addon  downloaded\tNXP-24507-A (id: NXP-24507-A-1.0.0) \n addon  downloaded\tNXP-24507-B (id: NXP-24507-B-1.0.0) \n";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        LogicalInstanceIdentifier CLID = new LogicalInstanceIdentifier("toto--titi", "myInstance");
        CLID.save();
        this.connectBroker.refreshCache();
        this.connectBroker.pkgListAll();
        expectedLogs = "All packages:\nstudio     started\tstudioA (id: studioA-1.0.0) \nstudio  downloaded\tstudioA (id: studioA-1.0.1) \nstudio  downloaded\tstudioA (id: studioA-1.0.2-SNAPSHOT) \nhotfix     started\thfA (id: hfA-1.0.0) \nhotfix  downloaded\thfA (id: hfA-1.0.8) \nhotfix  downloaded\thfB (id: hfB-1.0.0) \nhotfix  downloaded\thfC (id: hfC-1.0.0-SNAPSHOT) \n addon     started\tA (id: A-1.0.0) \n addon  downloaded\tA (id: A-1.2.0) \n addon  downloaded\tA (id: A-1.2.1-SNAPSHOT) \n addon  downloaded\tA (id: A-1.2.2-SNAPSHOT) \n addon  downloaded\tA (id: A-1.2.2) \n addon  downloaded\tA (id: A-1.2.3-SNAPSHOT) \n addon     started\tB (id: B-1.0.1-SNAPSHOT) \n addon  downloaded\tB (id: B-1.0.1) \n addon  downloaded\tB (id: B-1.0.2) \n addon     started\tC (id: C-1.0.0) \n addon  downloaded\tC (id: C-1.0.1-SNAPSHOT) \n addon  downloaded\tC (id: C-1.0.2-SNAPSHOT) \n addon     started\tD (id: D-1.0.2-SNAPSHOT) \n addon  downloaded\tD (id: D-1.0.3-SNAPSHOT) \n addon  downloaded\tD (id: D-1.0.4-SNAPSHOT) \n addon     started\tG (id: G-1.0.1-SNAPSHOT) \n addon     started\tH (id: H-1.0.1-SNAPSHOT) \n addon     started\tJ (id: J-1.0.1) \n addon     started\tK (id: K-1.0.0-SNAPSHOT) \n addon  downloaded\tM (id: M-1.0.0-SNAPSHOT) \n addon      remote\tM (id: M-1.0.1) \n addon  downloaded\tN (id: N-1.0.1-HF08-SNAPSHOT) \n addon  downloaded\tNXP-24507-A (id: NXP-24507-A-1.0.0) \n addon  downloaded\tNXP-24507-B (id: NXP-24507-B-1.0.0) \n addon      remote\tprivA (id: privA-1.0.1) [PRIVATE (Owner: customer1)]\n addon      remote\tprivB (id: privB-1.0.0-SNAPSHOT) [PRIVATE (Owner: customer1)]\n";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testListAllPackagesWithPlatformRange() throws Exception {
        Environment environment = Environment.getDefault();
        environment.setProperty("org.nuxeo.distribution.name", "server");
        environment.setProperty("org.nuxeo.distribution.version", "11.2");
        this.connectBroker = new ConnectBroker(environment);
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        this.connectBroker.pkgListAll();
        String expectedLogs = "All packages:\nstudio     started\tstudioA (id: studioA-1.0.0) \nstudio  downloaded\tstudioA (id: studioA-1.0.1) \nstudio  downloaded\tstudioA (id: studioA-1.0.2-SNAPSHOT) \nhotfix     started\thfA (id: hfA-1.0.0) \nhotfix  downloaded\thfA (id: hfA-1.0.8) \nhotfix  downloaded\thfB (id: hfB-1.0.0) \nhotfix  downloaded\thfC (id: hfC-1.0.0-SNAPSHOT) \n addon     started\tA (id: A-1.0.0) \n addon  downloaded\tA (id: A-1.2.0) \n addon  downloaded\tA (id: A-1.2.1-SNAPSHOT) \n addon  downloaded\tA (id: A-1.2.2-SNAPSHOT) \n addon  downloaded\tA (id: A-1.2.2) \n addon  downloaded\tA (id: A-1.2.3-SNAPSHOT) \n addon     started\tB (id: B-1.0.1-SNAPSHOT) \n addon  downloaded\tB (id: B-1.0.1) \n addon  downloaded\tB (id: B-1.0.2) \n addon     started\tC (id: C-1.0.0) \n addon  downloaded\tC (id: C-1.0.1-SNAPSHOT) \n addon  downloaded\tC (id: C-1.0.2-SNAPSHOT) \n addon     started\tD (id: D-1.0.2-SNAPSHOT) \n addon  downloaded\tD (id: D-1.0.3-SNAPSHOT) \n addon  downloaded\tD (id: D-1.0.4-SNAPSHOT) \n addon     started\tG (id: G-1.0.1-SNAPSHOT) \n addon     started\tH (id: H-1.0.1-SNAPSHOT) \n addon     started\tJ (id: J-1.0.1) \n addon     started\tK (id: K-1.0.0-SNAPSHOT) \n addon  downloaded\tM (id: M-1.0.0-SNAPSHOT) \n addon  downloaded\tN (id: N-1.0.1-HF08-SNAPSHOT) \n addon  downloaded\tNXP-24507-A (id: NXP-24507-A-1.0.0) \n addon  downloaded\tNXP-24507-B (id: NXP-24507-B-1.0.0) \n addon      remote\tP (id: P-1.0.1) [REGISTRATION REQUIRED]\n addon      remote\tT (id: T-1.0.1) [REGISTRATION REQUIRED]\n";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        LogicalInstanceIdentifier CLID = new LogicalInstanceIdentifier("toto--titi", "myInstance");
        CLID.save();
        this.connectBroker.refreshCache();
        this.connectBroker.pkgListAll();
        expectedLogs = "All packages:\nstudio     started\tstudioA (id: studioA-1.0.0) \nstudio  downloaded\tstudioA (id: studioA-1.0.1) \nstudio  downloaded\tstudioA (id: studioA-1.0.2-SNAPSHOT) \nhotfix     started\thfA (id: hfA-1.0.0) \nhotfix  downloaded\thfA (id: hfA-1.0.8) \nhotfix  downloaded\thfB (id: hfB-1.0.0) \nhotfix  downloaded\thfC (id: hfC-1.0.0-SNAPSHOT) \n addon     started\tA (id: A-1.0.0) \n addon  downloaded\tA (id: A-1.2.0) \n addon  downloaded\tA (id: A-1.2.1-SNAPSHOT) \n addon  downloaded\tA (id: A-1.2.2-SNAPSHOT) \n addon  downloaded\tA (id: A-1.2.2) \n addon  downloaded\tA (id: A-1.2.3-SNAPSHOT) \n addon     started\tB (id: B-1.0.1-SNAPSHOT) \n addon  downloaded\tB (id: B-1.0.1) \n addon  downloaded\tB (id: B-1.0.2) \n addon     started\tC (id: C-1.0.0) \n addon  downloaded\tC (id: C-1.0.1-SNAPSHOT) \n addon  downloaded\tC (id: C-1.0.2-SNAPSHOT) \n addon     started\tD (id: D-1.0.2-SNAPSHOT) \n addon  downloaded\tD (id: D-1.0.3-SNAPSHOT) \n addon  downloaded\tD (id: D-1.0.4-SNAPSHOT) \n addon     started\tG (id: G-1.0.1-SNAPSHOT) \n addon     started\tH (id: H-1.0.1-SNAPSHOT) \n addon     started\tJ (id: J-1.0.1) \n addon     started\tK (id: K-1.0.0-SNAPSHOT) \n addon  downloaded\tM (id: M-1.0.0-SNAPSHOT) \n addon  downloaded\tN (id: N-1.0.1-HF08-SNAPSHOT) \n addon  downloaded\tNXP-24507-A (id: NXP-24507-A-1.0.0) \n addon  downloaded\tNXP-24507-B (id: NXP-24507-B-1.0.0) \n addon      remote\tP (id: P-1.0.1) \n addon      remote\tprivD (id: privD-1.0.1) [PRIVATE (Owner: customer1)]\n addon      remote\tT (id: T-1.0.1) \n";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testShowPackages() throws Exception {
        this.connectBroker.pkgShow(Arrays.asList("A-1.0.0", "studioA-1.0.1", "hfA-1.0.0", "M-1.0.1", "unknown-package"));
        this.connectBroker.getCommandSet().log();
        String expectedLogs = "****************************************\nPackage: A-1.0.0\nState: started\nVersion: 1.0.0\nName: A\nType: addon\nTarget platforms: {server-8.3,server-8.4}\nSupports hot-reload: false\nTitle: Package A\nDescription: Description of A\nLicense: LGPL\nLicense URL: http://www.gnu.org/licenses/lgpl.html\n****************************************\nPackage: studioA-1.0.1\nState: downloaded\nVersion: 1.0.1\nName: studioA\nType: studio\nTarget platforms: {server-8.3,server-8.4}\nSupports hot-reload: false\nTitle: Studio A\nDescription: Description of studioA\nLicense: LGPL\nLicense URL: http://www.gnu.org/licenses/lgpl.html\n****************************************\nPackage: hfA-1.0.0\nState: started\nVersion: 1.0.0\nName: hfA\nType: hotfix\nTarget platforms: {server-8.3}\nSupports hot-reload: false\nTitle: Hot fix NXP\nDescription: Hot Fix for NXP\nLicense: LGPL\nLicense URL: http://www.gnu.org/licenses/lgpl.html\n****************************************\nPackage: M-1.0.1\nState: remote [REGISTRATION REQUIRED]\nVersion: 1.0.1\nName: M\nType: addon\nTarget platforms: {server-8.3,server-8.4}\nSupports hot-reload: false\nTitle: Package M\nDescription: description of M\n****************************************\n\tCould not find a remote or local (relative to current directory or to NUXEO_HOME) package with name or ID unknown-package";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        LogicalInstanceIdentifier CLID = new LogicalInstanceIdentifier("toto--titi", "myInstance");
        CLID.save();
        this.connectBroker.refreshCache();
        this.connectBroker.pkgShow(Arrays.asList("privA-1.0.1", "M-1.0.1"));
        expectedLogs = "****************************************\nPackage: privA-1.0.1\nState: remote [PRIVATE (Owner: customer1)]\nVersion: 1.0.1\nName: privA\nType: addon\nTarget platforms: {server-8.3,server-8.4}\nSupports hot-reload: false\nTitle: Package privA\nDescription: description of privA\n****************************************\nPackage: M-1.0.1\nState: remote \nVersion: 1.0.1\nName: M\nType: addon\nTarget platforms: {server-8.3,server-8.4}\nSupports hot-reload: false\nTitle: Package M\nDescription: description of M\n****************************************";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testDownloadUnknownPackage() throws Exception {
        this.checkPackagesState(null, "unknown-package");
        boolean isSuccessful = this.connectBroker.downloadPackages(Arrays.asList("unknown-package"));
        Assertions.assertThat((boolean)isSuccessful).isFalse();
        this.checkPackagesState(null, "unknown-package");
        this.connectBroker.getCommandSet().log();
        String expectedLogs = "Downloading [unknown-package]...\n\tDownload failed (not found).";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testDownloadSubscriptionRequiredPackage() throws Exception {
        this.checkPackagesState(PackageState.REMOTE, "M-1.0.1");
        boolean isSuccessful = this.connectBroker.downloadPackages(new ArrayList<String>(Collections.singleton("M-1.0.1")));
        Assertions.assertThat((boolean)isSuccessful).isFalse();
        this.checkPackagesState(PackageState.REMOTE, "M-1.0.1");
        this.connectBroker.getCommandSet().log();
        String expectedLogs = "Downloading [M-1.0.1]...\n\tRegistration required.";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.checkPackagesState(PackageState.DOWNLOADED, "M-1.0.0-SNAPSHOT");
        isSuccessful = this.connectBroker.downloadPackages(new ArrayList<String>(Collections.singleton("M-1.0.0-SNAPSHOT")));
        Assertions.assertThat((boolean)isSuccessful).isTrue();
        this.checkPackagesState(PackageState.DOWNLOADED, "M-1.0.0-SNAPSHOT");
        expectedLogs = "Registration is required for package 'M-1.0.0-SNAPSHOT'. Download skipped.";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    public void testPkgRequest_restartLauncherWithoutPendingCommand() {
        this.checkPackagesState(PackageState.DOWNLOADED, "NXP-24507-A-1.0.0");
        try {
            this.connectBroker.pkgRequest(null, Collections.singletonList("NXP-24507-A-1.0.0"), null, null, true, false);
            Assert.fail();
        }
        catch (LauncherRestartException e) {
            Assertions.assertThat((boolean)this.connectBroker.isRestartRequired()).isTrue();
        }
        Path pending = this.connectBroker.getPendingFile();
        Assertions.assertThat((Path)pending).doesNotExist();
    }

    @Test
    public void testPkgRequest_restartLauncherWithOnePendingCommand() {
        String pkgA = "NXP-24507-A-1.0.0";
        String pkgB = "NXP-24507-B-1.0.0";
        this.checkPackagesState(PackageState.DOWNLOADED, pkgA, pkgB);
        try {
            this.connectBroker.pkgRequest(null, Arrays.asList(pkgA, pkgB), null, null, true, false);
            Assert.fail();
        }
        catch (LauncherRestartException e) {
            Assertions.assertThat((boolean)this.connectBroker.isRestartRequired()).isTrue();
        }
        this.checkPackagesState(PackageState.STARTED, pkgA);
        Path pending = this.connectBroker.getPendingFile();
        Assertions.assertThat((Path)pending).hasContent("install " + pkgB);
    }

    @Test
    public void testPkgInstall_restartLauncherWithoutPendingCommand() {
        this.checkPackagesState(PackageState.DOWNLOADED, "NXP-24507-A-1.0.0");
        Path pending = this.connectBroker.getPendingFile();
        Assertions.assertThat((Path)pending).doesNotExist();
        try {
            this.connectBroker.pkgInstall(Collections.singletonList("NXP-24507-A-1.0.0"), false);
            Assert.fail();
        }
        catch (LauncherRestartException e) {
            Assertions.assertThat((boolean)this.connectBroker.isRestartRequired()).isTrue();
        }
        this.checkPackagesState(PackageState.STARTED, "NXP-24507-A-1.0.0");
        pending = this.connectBroker.getPendingFile();
        Assertions.assertThat((Path)pending).doesNotExist();
    }

    @Test
    public void testPkgInstall_restartLauncherWithOnePendingCommand() {
        this.checkPackagesState(PackageState.DOWNLOADED, "NXP-24507-A-1.0.0");
        try {
            this.connectBroker.pkgInstall(Arrays.asList("NXP-24507-A-1.0.0", "B", "C"), false);
            Assert.fail();
        }
        catch (LauncherRestartException e) {
            Assertions.assertThat((boolean)this.connectBroker.isRestartRequired()).isTrue();
        }
        this.checkPackagesState(PackageState.STARTED, "NXP-24507-A-1.0.0");
        Path pending = this.connectBroker.getPendingFile();
        Assertions.assertThat((Path)pending).hasContent("install B\ninstall C\n");
    }

    @Test
    public void testPkgUninstall_restartLauncherWithoutPendingCommand() {
        this.connectBroker.pkgInstall("NXP-24507-A-1.0.0", false);
        this.checkPackagesState(PackageState.STARTED, "NXP-24507-A-1.0.0");
        try {
            this.connectBroker.pkgUninstall(Collections.singletonList("NXP-24507-A-1.0.0"));
            Assert.fail();
        }
        catch (LauncherRestartException e) {
            Assertions.assertThat((boolean)this.connectBroker.isRestartRequired()).isTrue();
        }
        this.checkPackagesState(PackageState.DOWNLOADED, "NXP-24507-A-1.0.0");
        Assertions.assertThat((Path)this.connectBroker.getPendingFile()).doesNotExist();
    }

    @Test
    public void testPkgUninstall_restartLauncherWithOnePendingCommand() {
        String pkgA = "NXP-24507-A-1.0.0";
        String pkgB = "NXP-24507-B-1.0.0";
        this.connectBroker.pkgInstall(pkgA, false);
        this.connectBroker.pkgInstall(pkgB, false);
        this.checkPackagesState(PackageState.STARTED, pkgA, pkgB);
        try {
            this.connectBroker.pkgUninstall(Arrays.asList(pkgA, pkgB));
            Assert.fail();
        }
        catch (LauncherRestartException e) {
            Assertions.assertThat((boolean)this.connectBroker.isRestartRequired()).isTrue();
        }
        this.checkPackagesState(PackageState.DOWNLOADED, pkgA);
        Assertions.assertThat((Path)this.connectBroker.getPendingFile()).hasContent("uninstall " + pkgB);
    }

    @Test
    public void testPersistPendingCommand_createNewFile() throws Exception {
        Path path = this.connectBroker.getPendingFile();
        Assertions.assertThat((Path)path).doesNotExist();
        Arrays.asList("L1", "L2").forEach(arg_0 -> ((ConnectBroker)this.connectBroker).persistCommand(arg_0));
        Assertions.assertThat(Files.readAllLines(path)).containsExactly((Object[])new String[]{"L1", "L2"});
    }

    @Test
    public void testPersistPendingCommand_appendExistingFile() throws Exception {
        Path path = this.connectBroker.getPendingFile();
        Files.write(path, Arrays.asList("L1", "L2"), new OpenOption[0]);
        Arrays.asList("L3", "L4").forEach(arg_0 -> ((ConnectBroker)this.connectBroker).persistCommand(arg_0));
        Assertions.assertThat(Files.readAllLines(path)).containsExactly((Object[])new String[]{"L1", "L2", "L3", "L4"});
    }

    @Test
    public void testExecutePending_resumeCommands() throws Exception {
        Path path = this.connectBroker.getPendingFile();
        Files.write(path, Arrays.asList("install A-1.2.0", "install B-1.0.1"), new OpenOption[0]);
        this.connectBroker.executePending(path.toFile(), true, true, false);
        this.checkPackagesState(PackageState.STARTED, "A-1.2.0", "B-1.0.1");
    }

    @Test
    public void testExecutePending_restartAgain() throws Exception {
        String pkgA = "NXP-24507-A-1.0.0";
        String pkgB = "NXP-24507-B-1.0.0";
        Path path = this.connectBroker.getPendingFile();
        Files.write(path, Arrays.asList("install " + pkgA, "install " + pkgB), new OpenOption[0]);
        try {
            this.connectBroker.executePending(path.toFile(), true, true, false);
            Assert.fail((String)("LauncherRestartException didn't thrown, isRestartRequired=" + this.connectBroker.isRestartRequired()));
        }
        catch (LauncherRestartException e) {
            Assertions.assertThat((boolean)this.connectBroker.isRestartRequired()).isTrue();
            this.checkPackagesState(PackageState.STARTED, pkgA);
            Assertions.assertThat((Path)path).hasContent("install " + pkgB);
        }
        this.environment.setProperty("launcher.changed", "false");
        boolean result = this.connectBroker.executePending(path.toFile(), true, true, false);
        Assertions.assertThat((boolean)result).isTrue();
        this.checkPackagesState(PackageState.STARTED, pkgA, pkgB);
    }

    @Test
    public void testIsRemotePackageId() throws Exception {
        Assertions.assertThat((boolean)this.connectBroker.isRemotePackageId("A-1.0.0")).isTrue();
        Assertions.assertThat((boolean)this.connectBroker.isRemotePackageId("B-1.0.1-SNAPSHOT")).isTrue();
        Assertions.assertThat((boolean)this.connectBroker.isRemotePackageId("studioA-1.0.0")).isTrue();
        Assertions.assertThat((boolean)this.connectBroker.isRemotePackageId("hfA-1.0.8")).isTrue();
        Assertions.assertThat((boolean)this.connectBroker.isRemotePackageId("E-1.0.1")).isFalse();
        Assertions.assertThat((boolean)this.connectBroker.isRemotePackageId("F.1.0.0-SNAPSHOT")).isFalse();
        Assertions.assertThat((boolean)this.connectBroker.isRemotePackageId("K.1.0.0-SNAPSHOT")).isFalse();
        Assertions.assertThat((boolean)this.connectBroker.isRemotePackageId("unknown-package")).isFalse();
        Assertions.assertThat((boolean)this.connectBroker.isRemotePackageId("NXP-24507-A-1.0.0")).isFalse();
        Assertions.assertThat((boolean)this.connectBroker.isRemotePackageId("NXP-24507-B-1.0.0")).isFalse();
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testInstallPackageRequest() {
        this.connectBroker.setAllowSNAPSHOT(false);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Arrays.asList("A-1.2.0", "B-1.0.2"), null, null, true, false)).isFalse();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        String expectedLogs = "org.nuxeo.connect.update.PackageException: Package(s) B-1.0.2 not available on platform version server-8.3 (relax is not allowed)";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.connectBroker.setRelax("true");
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Arrays.asList("A-1.2.0", "B-1.0.2"), null, null, true, false)).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.2.0", "B-1.0.2", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.0.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1-SNAPSHOT", "B-1.0.1", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = "Relax restriction to target platform server-8.3 because of package(s) B-1.0.2\n\nDependency resolution:\n  Installation order (2):        B-1.0.2/A-1.2.0\n  Unchanged packages (8):        hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n  Packages to upgrade (2):       A:1.0.0, B:1.0.1-SNAPSHOT\n  Local packages to install (2): A:1.2.0, B:1.0.2\n\nUninstalling B-1.0.1-SNAPSHOT\nUninstalling A-1.0.0\nInstalling B-1.0.2\nInstalling A-1.2.0";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Arrays.asList("A-1.2.2-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.4-SNAPSHOT"), null, null, true, false)).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.2.2-SNAPSHOT", "B-1.0.2", "C-1.0.2-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.0.0", "A-1.2.1-SNAPSHOT", "A-1.2.0", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1-SNAPSHOT", "B-1.0.1", "C-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = "The following SNAPSHOT package(s) will be replaced in local cache (if available): [A-1.2.2-SNAPSHOT, C-1.0.2-SNAPSHOT, D-1.0.4-SNAPSHOT]\nDownload of 'A-1.2.2-SNAPSHOT' will replace the one already in local cache.\nDownloading [A-1.2.2-SNAPSHOT]...\nReplacement of A-1.2.2-SNAPSHOT in local cache...\nAdded A-1.2.2-SNAPSHOT\nDownload of 'C-1.0.2-SNAPSHOT' will replace the one already in local cache.\nDownloading [C-1.0.2-SNAPSHOT]...\nReplacement of C-1.0.2-SNAPSHOT in local cache...\nAdded C-1.0.2-SNAPSHOT\nDownload of 'D-1.0.4-SNAPSHOT' will replace the one already in local cache.\nDownloading [D-1.0.4-SNAPSHOT]...\nReplacement of D-1.0.4-SNAPSHOT in local cache...\nAdded D-1.0.4-SNAPSHOT\nRelax restriction to target platform server-8.3 because of package(s) A-1.2.2-SNAPSHOT, C-1.0.2-SNAPSHOT, D-1.0.4-SNAPSHOT\n\nDependency resolution:\n  Installation order (3):        A-1.2.2-SNAPSHOT/D-1.0.4-SNAPSHOT/C-1.0.2-SNAPSHOT\n  Unchanged packages (7):        B:1.0.2, hfA:1.0.0, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n  Packages to upgrade (3):       A:1.2.0, C:1.0.0, D:1.0.2-SNAPSHOT\n  Local packages to install (3): A:1.2.2-SNAPSHOT, C:1.0.2-SNAPSHOT, D:1.0.4-SNAPSHOT\n\nUninstalling C-1.0.0\nUninstalling D-1.0.2-SNAPSHOT\nUninstalling A-1.2.0\nInstalling A-1.2.2-SNAPSHOT\nInstalling D-1.0.4-SNAPSHOT\nInstalling C-1.0.2-SNAPSHOT";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    private String getExpectedLogsForOnePkgAndItsDep(String pkg, String pkgVersion, String dep, String depVersion) {
        return String.format("\nDependency resolution:\n  Installation order (2):        %s-%s/%s-%s\n  Unchanged packages (10):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n  Packages to download (2):      %s:%s, %s:%s\n\nDownloading [%s-%s, %s-%s]...\nAborting packages change request", dep, depVersion, pkg, pkgVersion, pkg, pkgVersion, dep, depVersion, pkg, pkgVersion, dep, depVersion);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testInstallPackageRequestSnapshotDependenciesResolution() throws Exception {
        Environment environment = Environment.getDefault();
        environment.setProperty("org.nuxeo.distribution.name", "server");
        environment.setProperty("org.nuxeo.distribution.version", "11.3");
        this.connectBroker = new ConnectBroker(environment);
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        this.connectBroker.setAllowSNAPSHOT(false);
        this.connectBroker.pkgRequest(null, Collections.singletonList("U-1.0.0"), null, null, true, false);
        String expectedLogs = this.getExpectedLogsForOnePkgAndItsDep("U", "1.0.0", "V", "1.0.0");
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.connectBroker.pkgRequest(null, Collections.singletonList("U-1.0.1-SNAPSHOT"), null, null, true, false);
        expectedLogs = "\nFailed to resolve dependencies: Couldn't order [U-1.0.1-SNAPSHOT] missing [V:1.0.1-SNAPSHOT] (consider using --relax true or --snapshot).";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.connectBroker.pkgRequest(null, Collections.singletonList("UU-1.0.0"), null, null, true, false);
        expectedLogs = this.getExpectedLogsForOnePkgAndItsDep("UU", "1.0.0", "VV", "1.0.0");
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.connectBroker.pkgRequest(null, Collections.singletonList("UU-1.0.1-SNAPSHOT"), null, null, true, false);
        expectedLogs = this.getExpectedLogsForOnePkgAndItsDep("UU", "1.0.1-SNAPSHOT", "VV", "1.0.0");
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.connectBroker.pkgRequest(null, Collections.singletonList("UUU-1.0.0"), null, null, true, false);
        expectedLogs = this.getExpectedLogsForOnePkgAndItsDep("UUU", "1.0.0", "VVV", "1.0.0");
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.connectBroker.pkgRequest(null, Collections.singletonList("UUU-1.0.1-SNAPSHOT"), null, null, true, false);
        expectedLogs = this.getExpectedLogsForOnePkgAndItsDep("UUU", "1.0.1-SNAPSHOT", "VVV", "1.0.1-SNAPSHOT");
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.connectBroker.setAllowSNAPSHOT(true);
        this.connectBroker.pkgRequest(null, Collections.singletonList("U-1.0.0"), null, null, true, false);
        expectedLogs = this.getExpectedLogsForOnePkgAndItsDep("U", "1.0.0", "V", "1.0.1-SNAPSHOT");
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.connectBroker.pkgRequest(null, Collections.singletonList("U-1.0.1-SNAPSHOT"), null, null, true, false);
        expectedLogs = this.getExpectedLogsForOnePkgAndItsDep("U", "1.0.1-SNAPSHOT", "V", "1.0.1-SNAPSHOT");
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.connectBroker.pkgRequest(null, Collections.singletonList("UU-1.0.0"), null, null, true, false);
        expectedLogs = this.getExpectedLogsForOnePkgAndItsDep("UU", "1.0.0", "VV", "1.0.1-SNAPSHOT");
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.connectBroker.pkgRequest(null, Collections.singletonList("UU-1.0.1-SNAPSHOT"), null, null, true, false);
        expectedLogs = this.getExpectedLogsForOnePkgAndItsDep("UU", "1.0.1-SNAPSHOT", "VV", "1.0.1-SNAPSHOT");
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.connectBroker.pkgRequest(null, Collections.singletonList("UUU-1.0.0"), null, null, true, false);
        expectedLogs = this.getExpectedLogsForOnePkgAndItsDep("UUU", "1.0.0", "VVV", "1.0.0");
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.connectBroker.pkgRequest(null, Collections.singletonList("UUU-1.0.1-SNAPSHOT"), null, null, true, false);
        expectedLogs = this.getExpectedLogsForOnePkgAndItsDep("UUU", "1.0.1-SNAPSHOT", "VVV", "1.0.1-SNAPSHOT");
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testInstallPackageRequestWithMissingDependencies() throws Exception {
        Environment environment = Environment.getDefault();
        environment.setProperty("org.nuxeo.distribution.name", "server");
        environment.setProperty("org.nuxeo.distribution.version", "8.4");
        this.connectBroker = new ConnectBroker(environment);
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        this.connectBroker.setAllowSNAPSHOT(false);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Collections.singletonList("L-1.0.2"), null, null, true, false)).isFalse();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        String expectedLogs = "\nFailed to resolve dependencies: Couldn't order [L-1.0.2] missing [hfB] (consider using --relax true or --snapshot).";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Collections.singletonList("L"), null, null, true, false)).isFalse();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = "\nFailed to resolve dependencies: Couldn't order [L-1.0.3, hfD-1.0.0] missing [hfB, hfD] (consider using --relax true or --snapshot).";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testInstallLocalPackageRequest() {
        this.connectBroker.setAllowSNAPSHOT(false);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Arrays.asList("src/test/resources/packages/store/local-only/F-1.0.0-SNAPSHOT.zip", "src/test/resources/packages/store/local-only/E-1.0.1"), null, null, true, false)).isFalse();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT", "E-1.0.1", "F-1.0.0-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)new File("src/test/resources/packages/store/local-only/F-1.0.0-SNAPSHOT.zip").exists()).isTrue();
        Assertions.assertThat((boolean)new File("src/test/resources/packages/store/local-only/E-1.0.1").exists()).isTrue();
        String expectedLogs = "Added src/test/resources/packages/store/local-only/F-1.0.0-SNAPSHOT.zip\nAdded src/test/resources/packages/store/local-only/E-1.0.1\norg.nuxeo.connect.update.PackageException: Package(s) F-1.0.0-SNAPSHOT not available on platform version server-8.3 (relax is not allowed)";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.connectBroker.setRelax("true");
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Arrays.asList("src/test/resources/packages/store/local-only/F-1.0.0-SNAPSHOT.zip", "src/test/resources/packages/store/local-only/E-1.0.1"), null, null, true, false)).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "E-1.0.1", "F-1.0.0-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = "The following SNAPSHOT package(s) will be replaced in local cache (if available): [src/test/resources/packages/store/local-only/F-1.0.0-SNAPSHOT.zip]\nReplacement of F-1.0.0-SNAPSHOT in local cache...\nAdded src/test/resources/packages/store/local-only/F-1.0.0-SNAPSHOT.zip\nRelax restriction to target platform server-8.3 because of package(s) F-1.0.0-SNAPSHOT\n\nDependency resolution:\n  Installation order (2):        E-1.0.1/F-1.0.0-SNAPSHOT\n  Unchanged packages (10):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n  Local packages to install (2): E:1.0.1, F:1.0.0-SNAPSHOT\n\nInstalling E-1.0.1\nInstalling F-1.0.0-SNAPSHOT";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testInstallLocalPackageRequestWithRange() throws Exception {
        Environment environment = Environment.getDefault();
        environment.setProperty("org.nuxeo.distribution.name", "server");
        environment.setProperty("org.nuxeo.distribution.version", "11.2.3");
        this.connectBroker = new ConnectBroker(environment);
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        this.connectBroker.setAllowSNAPSHOT(false);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Arrays.asList("src/test/resources/packages/store/local-only/Q-1.0.0.zip", "src/test/resources/packages/store/local-only/R-1.0.2-SNAPSHOT", "src/test/resources/packages/store/local-only/S-1.0.0.zip"), null, null, true, false)).isFalse();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT", "Q-1.0.0", "R-1.0.2-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)new File("src/test/resources/packages/store/local-only/Q-1.0.0.zip").exists()).isTrue();
        Assertions.assertThat((boolean)new File("src/test/resources/packages/store/local-only/R-1.0.2-SNAPSHOT").exists()).isTrue();
        Assertions.assertThat((boolean)new File("src/test/resources/packages/store/local-only/S-1.0.0.zip").exists()).isTrue();
        String expectedLogs = "Added src/test/resources/packages/store/local-only/Q-1.0.0.zip\nAdded src/test/resources/packages/store/local-only/R-1.0.2-SNAPSHOT\nAdded src/test/resources/packages/store/local-only/S-1.0.0.zip\norg.nuxeo.connect.update.PackageException: Package(s) Q-1.0.0, R-1.0.2-SNAPSHOT not available on platform version server-11.2.3 (relax is not allowed)";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.connectBroker.setRelax("true");
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Arrays.asList("src/test/resources/packages/store/local-only/Q-1.0.0.zip", "src/test/resources/packages/store/local-only/R-1.0.2-SNAPSHOT", "src/test/resources/packages/store/local-only/S-1.0.0.zip"), null, null, true, false)).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "Q-1.0.0", "R-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = "The following SNAPSHOT package(s) will be replaced in local cache (if available): [src/test/resources/packages/store/local-only/R-1.0.2-SNAPSHOT]\nReplacement of R-1.0.2-SNAPSHOT in local cache...\nAdded src/test/resources/packages/store/local-only/R-1.0.2-SNAPSHOT\nRelax restriction to target platform server-11.2.3 because of package(s) Q-1.0.0, R-1.0.2-SNAPSHOT\n\nDependency resolution:\n  Installation order (3):        Q-1.0.0/R-1.0.2-SNAPSHOT/S-1.0.0\n  Unchanged packages (10):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n  Local packages to install (3): Q:1.0.0, R:1.0.2-SNAPSHOT, S:1.0.0\n\nInstalling Q-1.0.0\nInstalling R-1.0.2-SNAPSHOT\nInstalling S-1.0.0";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testReInstallPackageRequest() {
        this.connectBroker.setAllowSNAPSHOT(false);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Arrays.asList("A-1.0.0", "C"), null, null, true, false)).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        String expectedLogs = "\nDependency resolution:\n  Unchanged packages (10):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Arrays.asList("B-1.0.1-SNAPSHOT", "D"), null, null, true, false)).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = "The following SNAPSHOT package(s) will be replaced in local cache (if available): [D-1.0.2-SNAPSHOT, B-1.0.1-SNAPSHOT]\nUninstalling D-1.0.2-SNAPSHOT\nUninstalling B-1.0.1-SNAPSHOT\nDownload of 'D-1.0.2-SNAPSHOT' will replace the one already in local cache.\nDownloading [D-1.0.2-SNAPSHOT]...\nReplacement of D-1.0.2-SNAPSHOT in local cache...\nAdded D-1.0.2-SNAPSHOT\nDownload of 'B-1.0.1-SNAPSHOT' will replace the one already in local cache.\nDownloading [B-1.0.1-SNAPSHOT]...\nReplacement of B-1.0.1-SNAPSHOT in local cache...\nAdded B-1.0.1-SNAPSHOT\n\nAs package 'C-1.0.0' has an optional dependency on package(s) [D-1.0.2-SNAPSHOT] currently being installed, it will be reinstalled.\nDependency resolution:\n  Installation order (3):        B-1.0.1-SNAPSHOT/D-1.0.2-SNAPSHOT/C-1.0.0\n  Uninstallation order (1):      C-1.0.0\n  Unchanged packages (7):        A:1.0.0, hfA:1.0.0, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n  Local packages to install (3): B:1.0.1-SNAPSHOT, C:1.0.0, D:1.0.2-SNAPSHOT\n  Local packages to remove (1):  C:1.0.0\n\nUninstalling C-1.0.0\nInstalling B-1.0.1-SNAPSHOT\nInstalling D-1.0.2-SNAPSHOT\nInstalling C-1.0.0";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testReInstallLocalPackageRequest() {
        this.connectBroker.setAllowSNAPSHOT(false);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Collections.singletonList("src/test/resources/packages/store/A-1.0.0.zip"), null, null, true, false)).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        String expectedLogs = "\nDependency resolution:\n  Unchanged packages (10):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Collections.singletonList("src/test/resources/packages/store/B-1.0.1-SNAPSHOT.zip"), null, null, true, false)).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = "The following SNAPSHOT package(s) will be replaced in local cache (if available): [src/test/resources/packages/store/B-1.0.1-SNAPSHOT.zip]\nUninstalling B-1.0.1-SNAPSHOT\nReplacement of B-1.0.1-SNAPSHOT in local cache...\nAdded src/test/resources/packages/store/B-1.0.1-SNAPSHOT.zip\n\nDependency resolution:\n  Installation order (1):        B-1.0.1-SNAPSHOT\n  Unchanged packages (9):        A:1.0.0, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n  Local packages to install (1): B:1.0.1-SNAPSHOT\n\nInstalling B-1.0.1-SNAPSHOT";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Collections.singletonList("src/test/resources/packages/store/local-only/K-1.0.0-SNAPSHOT.zip"), null, null, true, false)).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "K-1.0.0-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = "The following SNAPSHOT package(s) will be replaced in local cache (if available): [src/test/resources/packages/store/local-only/K-1.0.0-SNAPSHOT.zip]\nUninstalling K-1.0.0-SNAPSHOT\nReplacement of K-1.0.0-SNAPSHOT in local cache...\nAdded src/test/resources/packages/store/local-only/K-1.0.0-SNAPSHOT.zip\n\nDependency resolution:\n  Installation order (1):        K-1.0.0-SNAPSHOT\n  Unchanged packages (9):        A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Local packages to install (1): K:1.0.0-SNAPSHOT\n\nInstalling K-1.0.0-SNAPSHOT";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Collections.singletonList("K"), null, null, true, false)).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "K-1.0.0-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = "The following SNAPSHOT package(s) will be replaced in local cache (if available): [K-1.0.0-SNAPSHOT]\nUninstalling K-1.0.0-SNAPSHOT\nThe SNAPSHOT package K-1.0.0-SNAPSHOT is not available remotely, local cache will be used.\n\nDependency resolution:\n  Installation order (1):        K-1.0.0-SNAPSHOT\n  Unchanged packages (9):        A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Local packages to install (1): K:1.0.0-SNAPSHOT\n\nInstalling K-1.0.0-SNAPSHOT";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testUpgradePackageRequestWithRelax() throws Exception {
        this.environment.setProperty("org.nuxeo.distribution.name", "nomatching");
        this.environment.setProperty("org.nuxeo.distribution.version", "1.0");
        this.connectBroker = new ConnectBroker(this.environment);
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        this.connectBroker.setAllowSNAPSHOT(false);
        this.connectBroker.setRelax("true");
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)this.connectBroker.pkgUpgrade()).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "A-1.2.2", "B-1.0.2", "C-1.0.0", "D-1.0.4-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "studioA-1.0.1", "hfA-1.0.0", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.0.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.0", "A-1.2.3-SNAPSHOT", "B-1.0.1-SNAPSHOT", "B-1.0.1", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT"), PackageState.DOWNLOADED);
        String expectedLogs = "Relax restriction to target platform nomatching-1.0 because of package(s) studioA, hfA, A, B, C, D, G, H, J, K\n\nDependency resolution:\n  Installation order (7):        A-1.2.2/B-1.0.2/D-1.0.4-SNAPSHOT/G-1.0.1-SNAPSHOT/H-1.0.1-SNAPSHOT/hfA-1.0.8/studioA-1.0.2-SNAPSHOT\n  Unchanged packages (5):        C:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n  Packages to upgrade (5):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0\n  Local packages to install (5): A:1.2.2, B:1.0.2, hfA:1.0.8, D:1.0.4-SNAPSHOT, studioA:1.0.2-SNAPSHOT\n\nUninstalling studioA-1.0.0\nUninstalling hfA-1.0.0\nUninstalling D-1.0.2-SNAPSHOT\nUninstalling B-1.0.1-SNAPSHOT\nUninstalling A-1.0.0\nInstalling A-1.2.2\nInstalling B-1.0.2\nInstalling D-1.0.4-SNAPSHOT\nUpdating package G-1.0.1-SNAPSHOT...\nUninstalling G-1.0.1-SNAPSHOT\nRemoved G-1.0.1-SNAPSHOT\nDownloading [G-1.0.1-SNAPSHOT]...\nAdded G-1.0.1-SNAPSHOT\nInstalling G-1.0.1-SNAPSHOT\nUpdating package H-1.0.1-SNAPSHOT...\nUninstalling H-1.0.1-SNAPSHOT\nRemoved H-1.0.1-SNAPSHOT\nDownloading [H-1.0.1-SNAPSHOT]...\nAdded H-1.0.1-SNAPSHOT\nInstalling H-1.0.1-SNAPSHOT\nInstalling hfA-1.0.8\nInstalling studioA-1.0.2-SNAPSHOT";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testUpgradePackageRequestWithRelaxAndSnapshot() throws Exception {
        this.environment.setProperty("org.nuxeo.distribution.name", "nomatching");
        this.environment.setProperty("org.nuxeo.distribution.version", "1.0");
        this.connectBroker = new ConnectBroker(this.environment);
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        this.connectBroker.setAllowSNAPSHOT(true);
        this.connectBroker.setRelax("true");
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)this.connectBroker.pkgUpgrade()).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "A-1.2.3-SNAPSHOT", "B-1.0.2", "C-1.0.2-SNAPSHOT", "D-1.0.4-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "studioA-1.0.1", "hfA-1.0.0", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.0.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.0", "B-1.0.1-SNAPSHOT", "B-1.0.1", "C-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT"), PackageState.DOWNLOADED);
        String expectedLogs = "Relax restriction to target platform nomatching-1.0 because of package(s) studioA, hfA, A, B, C, D, G, H, J, K\n\nDependency resolution:\n  Installation order (8):        A-1.2.3-SNAPSHOT/B-1.0.2/D-1.0.4-SNAPSHOT/G-1.0.1-SNAPSHOT/H-1.0.1-SNAPSHOT/hfA-1.0.8/studioA-1.0.2-SNAPSHOT/C-1.0.2-SNAPSHOT\n  Unchanged packages (4):        G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n  Packages to upgrade (6):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0\n  Local packages to install (6): A:1.2.3-SNAPSHOT, B:1.0.2, hfA:1.0.8, C:1.0.2-SNAPSHOT, D:1.0.4-SNAPSHOT, studioA:1.0.2-SNAPSHOT\n\nUninstalling C-1.0.0\nUninstalling studioA-1.0.0\nUninstalling hfA-1.0.0\nUninstalling D-1.0.2-SNAPSHOT\nUninstalling B-1.0.1-SNAPSHOT\nUninstalling A-1.0.0\nInstalling A-1.2.3-SNAPSHOT\nInstalling B-1.0.2\nInstalling D-1.0.4-SNAPSHOT\nUpdating package G-1.0.1-SNAPSHOT...\nUninstalling G-1.0.1-SNAPSHOT\nRemoved G-1.0.1-SNAPSHOT\nDownloading [G-1.0.1-SNAPSHOT]...\nAdded G-1.0.1-SNAPSHOT\nInstalling G-1.0.1-SNAPSHOT\nUpdating package H-1.0.1-SNAPSHOT...\nUninstalling H-1.0.1-SNAPSHOT\nRemoved H-1.0.1-SNAPSHOT\nDownloading [H-1.0.1-SNAPSHOT]...\nAdded H-1.0.1-SNAPSHOT\nInstalling H-1.0.1-SNAPSHOT\nInstalling hfA-1.0.8\nInstalling studioA-1.0.2-SNAPSHOT\nInstalling C-1.0.2-SNAPSHOT";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testUpgradePackageRequestWithTargetPlatform() {
        this.connectBroker.setAllowSNAPSHOT(false);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)this.connectBroker.pkgUpgrade()).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "A-1.2.0", "B-1.0.1", "C-1.0.0", "D-1.0.3-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "studioA-1.0.1", "hfA-1.0.0", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.0.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1-SNAPSHOT", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.2-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        String expectedLogs = "Optional dependencies [B:1.0.2] will be ignored for 'A-1.2.0'.\n\nDependency resolution:\n  Installation order (7):        A-1.2.0/B-1.0.1/D-1.0.3-SNAPSHOT/G-1.0.1-SNAPSHOT/H-1.0.1-SNAPSHOT/hfA-1.0.8/studioA-1.0.2-SNAPSHOT\n  Unchanged packages (5):        C:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n  Packages to upgrade (5):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0\n  Local packages to install (5): A:1.2.0, B:1.0.1, hfA:1.0.8, D:1.0.3-SNAPSHOT, studioA:1.0.2-SNAPSHOT\n\nUninstalling studioA-1.0.0\nUninstalling hfA-1.0.0\nUninstalling D-1.0.2-SNAPSHOT\nUninstalling B-1.0.1-SNAPSHOT\nUninstalling A-1.0.0\nInstalling A-1.2.0\nInstalling B-1.0.1\nInstalling D-1.0.3-SNAPSHOT\nUpdating package G-1.0.1-SNAPSHOT...\nUninstalling G-1.0.1-SNAPSHOT\nRemoved G-1.0.1-SNAPSHOT\nDownloading [G-1.0.1-SNAPSHOT]...\nAdded G-1.0.1-SNAPSHOT\nInstalling G-1.0.1-SNAPSHOT\nUpdating package H-1.0.1-SNAPSHOT...\nUninstalling H-1.0.1-SNAPSHOT\nRemoved H-1.0.1-SNAPSHOT\nDownloading [H-1.0.1-SNAPSHOT]...\nAdded H-1.0.1-SNAPSHOT\nInstalling H-1.0.1-SNAPSHOT\nInstalling hfA-1.0.8\nInstalling studioA-1.0.2-SNAPSHOT";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testUpgradePackageRequestWithTargetPlatformAndSnapshot() {
        this.connectBroker.setAllowSNAPSHOT(true);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)this.connectBroker.pkgUpgrade()).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "A-1.2.1-SNAPSHOT", "B-1.0.1", "C-1.0.1-SNAPSHOT", "D-1.0.3-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "studioA-1.0.1", "hfA-1.0.0", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.0.0", "A-1.2.0", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1-SNAPSHOT", "B-1.0.2", "C-1.0.0", "C-1.0.2-SNAPSHOT", "D-1.0.2-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        String expectedLogs = "\nDependency resolution:\n  Installation order (8):        A-1.2.1-SNAPSHOT/B-1.0.1/D-1.0.3-SNAPSHOT/G-1.0.1-SNAPSHOT/H-1.0.1-SNAPSHOT/hfA-1.0.8/studioA-1.0.2-SNAPSHOT/C-1.0.1-SNAPSHOT\n  Unchanged packages (4):        G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n  Packages to upgrade (6):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0\n  Local packages to install (6): A:1.2.1-SNAPSHOT, B:1.0.1, hfA:1.0.8, C:1.0.1-SNAPSHOT, D:1.0.3-SNAPSHOT, studioA:1.0.2-SNAPSHOT\n\nUninstalling C-1.0.0\nUninstalling studioA-1.0.0\nUninstalling hfA-1.0.0\nUninstalling D-1.0.2-SNAPSHOT\nUninstalling B-1.0.1-SNAPSHOT\nUninstalling A-1.0.0\nInstalling A-1.2.1-SNAPSHOT\nInstalling B-1.0.1\nInstalling D-1.0.3-SNAPSHOT\nUpdating package G-1.0.1-SNAPSHOT...\nUninstalling G-1.0.1-SNAPSHOT\nRemoved G-1.0.1-SNAPSHOT\nDownloading [G-1.0.1-SNAPSHOT]...\nAdded G-1.0.1-SNAPSHOT\nInstalling G-1.0.1-SNAPSHOT\nUpdating package H-1.0.1-SNAPSHOT...\nUninstalling H-1.0.1-SNAPSHOT\nRemoved H-1.0.1-SNAPSHOT\nDownloading [H-1.0.1-SNAPSHOT]...\nAdded H-1.0.1-SNAPSHOT\nInstalling H-1.0.1-SNAPSHOT\nInstalling hfA-1.0.8\nInstalling studioA-1.0.2-SNAPSHOT\nInstalling C-1.0.1-SNAPSHOT";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testHotfixPackageRequest() throws Exception {
        this.connectBroker.setAllowSNAPSHOT(false);
        LogicalInstanceIdentifier CLID = new LogicalInstanceIdentifier("toto--titi", "myInstance");
        CLID.save();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfA-1.0.8", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)this.connectBroker.pkgHotfix()).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.8", "hfB-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfA-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        String expectedLogs = "\nDependency resolution:\n  Installation order (2):        hfA-1.0.8/hfB-1.0.0\n  Unchanged packages (9):        A:1.0.0, B:1.0.1-SNAPSHOT, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n  Packages to upgrade (1):       hfA:1.0.0\n  Local packages to install (2): hfA:1.0.8, hfB:1.0.0\n\nUninstalling hfA-1.0.0\nInstalling hfA-1.0.8\nInstalling hfB-1.0.0";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        this.connectBroker.setAllowSNAPSHOT(true);
        Assertions.assertThat((boolean)this.connectBroker.pkgHotfix()).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.8", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfA-1.0.0", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = "The following SNAPSHOT package(s) will be replaced in local cache (if available): [hfC-1.0.0-SNAPSHOT]\nDownload of 'hfC-1.0.0-SNAPSHOT' will replace the one already in local cache.\nDownloading [hfC-1.0.0-SNAPSHOT]...\nReplacement of hfC-1.0.0-SNAPSHOT in local cache...\nAdded hfC-1.0.0-SNAPSHOT\n\nDependency resolution:\n  Installation order (1):        hfC-1.0.0-SNAPSHOT\n  Unchanged packages (11):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.8, C:1.0.0, D:1.0.2-SNAPSHOT, hfB:1.0.0, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n  Local packages to install (1): hfC:1.0.0-SNAPSHOT\n\nInstalling hfC-1.0.0-SNAPSHOT";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testReInstallPackageRequestWithOptionalDependencies() {
        this.connectBroker.setAllowSNAPSHOT(false);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Arrays.asList("H", "G"), null, null, true, false)).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        String expectedLogs = "The following SNAPSHOT package(s) will be replaced in local cache (if available): [G-1.0.1-SNAPSHOT, H-1.0.1-SNAPSHOT]\nUninstalling G-1.0.1-SNAPSHOT\nUninstalling H-1.0.1-SNAPSHOT\nDownload of 'G-1.0.1-SNAPSHOT' will replace the one already in local cache.\nDownloading [G-1.0.1-SNAPSHOT]...\nReplacement of G-1.0.1-SNAPSHOT in local cache...\nAdded G-1.0.1-SNAPSHOT\nDownload of 'H-1.0.1-SNAPSHOT' will replace the one already in local cache.\nDownloading [H-1.0.1-SNAPSHOT]...\nReplacement of H-1.0.1-SNAPSHOT in local cache...\nAdded H-1.0.1-SNAPSHOT\n\nAs package 'J-1.0.1' has an optional dependency on package(s) [G-1.0.1-SNAPSHOT, H-1.0.1-SNAPSHOT] currently being installed, it will be reinstalled.\nDependency resolution:\n  Installation order (3):        G-1.0.1-SNAPSHOT/H-1.0.1-SNAPSHOT/J-1.0.1\n  Uninstallation order (1):      J-1.0.1\n  Unchanged packages (7):        A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, K:1.0.0-SNAPSHOT\n  Local packages to install (3): G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Local packages to remove (1):  J:1.0.1\n\nUninstalling J-1.0.1\nInstalling G-1.0.1-SNAPSHOT\nInstalling H-1.0.1-SNAPSHOT\nInstalling J-1.0.1";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testUninstallLocalPackageRequest() {
        this.connectBroker.setAllowSNAPSHOT(false);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1", "K-1.0.0-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, null, Collections.singletonList("K"), null, true, false)).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT", "K-1.0.0-SNAPSHOT"), PackageState.DOWNLOADED);
        String expectedLogs = "\nDependency resolution:\n  Uninstallation order (1):      K-1.0.0-SNAPSHOT\n  Unchanged packages (9):        A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n  Local packages to remove (1):  K:1.0.0-SNAPSHOT\n\nUninstalling K-1.0.0-SNAPSHOT";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testUninstallPackageRequestWithOptionalDependencies() {
        this.connectBroker.setAllowSNAPSHOT(false);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, null, Arrays.asList("H", "G"), null, true, false)).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "J-1.0.1"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT", "G-1.0.1-SNAPSHOT", "H-1.0.1-SNAPSHOT"), PackageState.DOWNLOADED);
        String expectedLogs = "\nAs package 'J-1.0.1' has an optional dependency on package(s) [G-1.0.1-SNAPSHOT, H-1.0.1-SNAPSHOT] currently being uninstalled, it will be reinstalled.\nDependency resolution:\n  Installation order (1):        J-1.0.1\n  Uninstallation order (3):      J-1.0.1/H-1.0.1-SNAPSHOT/G-1.0.1-SNAPSHOT\n  Unchanged packages (7):        A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, K:1.0.0-SNAPSHOT\n  Local packages to install (1): J:1.0.1\n  Local packages to remove (3):  G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1\n\nUninstalling J-1.0.1\nUninstalling H-1.0.1-SNAPSHOT\nUninstalling G-1.0.1-SNAPSHOT\nInstalling J-1.0.1";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    @Test
    @LogCaptureFeature.FilterWith(value=PkgRequestLogFilter.class)
    public void testInstallPackageRequestWithCustomTargetPlatforms() throws Exception {
        Environment environment = Environment.getDefault();
        environment.setProperty("org.nuxeo.distribution.name", "server");
        environment.setProperty("org.nuxeo.distribution.version", "10.3-I20181011_1121");
        this.connectBroker = new ConnectBroker(environment);
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        this.connectBroker.setAllowSNAPSHOT(false);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Collections.singletonList("M"), null, null, true, false)).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "M-1.0.0-I20181011_1121"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        String expectedLogs = "\nDependency resolution:\n  Installation order (1):        M-1.0.0-I20181011_1121\n  Unchanged packages (10):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT\n  Packages to download (1):      M:1.0.0-I20181011_1121\n\nPackage 'M-1.0.0-I20181011_1121' is already in local cache.\nInstalling M-1.0.0-I20181011_1121";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
        this.logCaptureResult.clear();
        environment.setProperty("org.nuxeo.distribution.name", "server");
        environment.setProperty("org.nuxeo.distribution.version", "9.10-HF08-SNAPSHOT");
        this.connectBroker = new ConnectBroker(environment);
        ((StandaloneCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setTestMode(true);
        this.connectBroker.setAllowSNAPSHOT(true);
        Assertions.assertThat((boolean)this.connectBroker.pkgRequest(null, Collections.singletonList("N"), null, null, true, false)).isTrue();
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.0", "hfA-1.0.0", "A-1.0.0", "B-1.0.1-SNAPSHOT", "C-1.0.0", "D-1.0.2-SNAPSHOT", "M-1.0.0-I20181011_1121", "N-1.0.1-HF08-SNAPSHOT"), PackageState.STARTED);
        this.checkPackagesState(this.connectBroker, Arrays.asList("studioA-1.0.1", "studioA-1.0.2-SNAPSHOT", "hfB-1.0.0", "hfC-1.0.0-SNAPSHOT", "A-1.2.0", "A-1.2.1-SNAPSHOT", "A-1.2.2-SNAPSHOT", "A-1.2.2", "A-1.2.3-SNAPSHOT", "B-1.0.1", "B-1.0.2", "C-1.0.1-SNAPSHOT", "C-1.0.2-SNAPSHOT", "D-1.0.3-SNAPSHOT", "D-1.0.4-SNAPSHOT"), PackageState.DOWNLOADED);
        expectedLogs = "\nDependency resolution:\n  Installation order (1):        N-1.0.1-HF08-SNAPSHOT\n  Unchanged packages (11):       A:1.0.0, B:1.0.1-SNAPSHOT, hfA:1.0.0, C:1.0.0, D:1.0.2-SNAPSHOT, studioA:1.0.0, G:1.0.1-SNAPSHOT, H:1.0.1-SNAPSHOT, J:1.0.1, K:1.0.0-SNAPSHOT, M:1.0.0-I20181011_1121\n  Local packages to install (1): N:1.0.1-HF08-SNAPSHOT\n\nDownload of 'N-1.0.1-HF08-SNAPSHOT' will replace the one already in local cache.\nDownloading [N-1.0.1-HF08-SNAPSHOT]...\nReplacement of N-1.0.1-HF08-SNAPSHOT in local cache...\nAdded N-1.0.1-HF08-SNAPSHOT\nInstalling N-1.0.1-HF08-SNAPSHOT";
        Assertions.assertThat((String)TestConnectBroker.logOf(this.logCaptureResult)).isEqualTo(expectedLogs);
    }

    protected void checkPackagesState(PackageState expectedState, String ... packageIds) {
        this.checkPackagesState(this.connectBroker, Arrays.asList(packageIds), expectedState);
    }

    private void checkPackagesState(ConnectBroker connectBrocker, List<String> packageIdList, PackageState expectedState) {
        Map states = connectBrocker.getUpdateService().getPersistence().getStates();
        for (String pkgId : packageIdList) {
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((PackageState)states.get(pkgId))).as("Checking state of %s", new Object[]{pkgId})).isEqualTo((Object)expectedState);
        }
    }

    protected Set<String> collectIdsFrom(String ... jsonFileNames) throws JSONException, IOException {
        HashSet<String> result = new HashSet<String>();
        for (String jsonFileName : jsonFileNames) {
            File jsonFile = new File(testStore, jsonFileName);
            JSONArray array = new JSONArray(FileUtils.readFileToString((File)jsonFile, (Charset)StandardCharsets.UTF_8));
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < array.length(); ++i) {
                String id = (String)array.getJSONObject(i).get("id");
                ids.add(id);
            }
            Assertions.assertThat(ids).hasSize(array.length());
            result.addAll(ids);
        }
        return result;
    }

    protected static String logOf(LogCaptureFeature.Result logCaptureResult) {
        return String.join((CharSequence)"\n", logCaptureResult.getCaughtEventMessages());
    }

    public static class FakeConnectDownloadServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            block13: {
                String target = request.getPathInfo();
                if (target.startsWith("/test")) {
                    String pkgId = target.substring(target.lastIndexOf("/") + 1);
                    File pkgZip = new File(testStore, pkgId + ".zip");
                    if (pkgZip.exists()) {
                        response.setContentLength((int)pkgZip.length());
                        response.setStatus(200);
                        try (ServletOutputStream os = response.getOutputStream();
                             FileInputStream is = new FileInputStream(pkgZip);){
                            IOUtils.copy((InputStream)is, (OutputStream)os);
                            break block13;
                        }
                    }
                    response.setStatus(404);
                }
            }
        }
    }

    public static class PkgRequestLogFilter
    implements LogCaptureFeature.Filter {
        public boolean accept(LogEvent event) {
            return event.getLevel().isMoreSpecificThan(Level.INFO) && (event.getLoggerName().contains("ConnectBroker") || event.getLoggerName().contains("PackagePersistence") || event.getLoggerName().contains("PackageManagerImpl") || event.getLoggerName().contains("MessageInfo") || event.getLoggerName().contains("LocalDownloadingPackage"));
        }
    }
}

