/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone.commands;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.nuxeo.common.Environment;
import org.nuxeo.connect.update.standalone.commands.AbstractCommandTest;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.config.ConfigurationHolder;
import org.nuxeo.runtime.test.TargetResourceLocator;

public class TestConfig
extends AbstractCommandTest {
    protected static final Logger log = LogManager.getLogger(TestConfig.class);
    @Inject
    protected TargetResourceLocator locator;
    protected ConfigurationGenerator configurationGenerator;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        URL url = this.locator.getTargetTestResource("config/nuxeo.conf");
        File nuxeoConf = new File(Environment.getDefault().getServerHome(), "nuxeo.conf");
        FileUtils.copyFile((File)new File(URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8)), (File)nuxeoConf);
        System.setProperty("nuxeo.conf", nuxeoConf.getPath());
        System.setProperty("tomcat.home", Environment.getDefault().getServerHome().getPath());
        url = this.locator.getTargetTestResource("templates");
        FileUtils.copyDirectory((File)new File(URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8)), (File)new File(Environment.getDefault().getServerHome(), "templates"));
        this.configurationGenerator = ConfigurationGenerator.build();
        Assert.assertTrue((boolean)this.configurationGenerator.init());
        this.configurationGenerator.addTemplate("oldtemplate");
        this.configurationGenerator.addTemplate("oldtemplate1,oldtemplate2");
    }

    @Override
    protected File createPackage() throws IOException, URISyntaxException {
        return this.getTestPackageZip("test-config");
    }

    @Override
    protected void installDone(Task task, Throwable error) throws Exception {
        super.installDone(task, error);
        this.configurationGenerator = ConfigurationGenerator.build();
        Assert.assertTrue((boolean)this.configurationGenerator.init());
        ConfigurationHolder configHolder = this.configurationGenerator.getConfigurationHolder();
        log.info("Install done. nuxeo.conf content:\n{}", (Object)Files.readString(configHolder.getNuxeoConfPath()));
        String templates = this.configurationGenerator.getUserConfig().getProperty("nuxeo.templates");
        Assert.assertNotNull((Object)templates);
        Assert.assertTrue((String)"newtemplate was not added", (boolean)templates.contains("newtemplate"));
        Assert.assertFalse((String)"oldtemplate was not removed", (boolean)templates.contains("oldtemplate"));
        Assert.assertEquals((String)"test.property was not set to some.value", (Object)"some.value", (Object)this.configurationGenerator.getUserConfig().getProperty("test.property"));
        Assert.assertEquals((String)"alreadyset.property was not set to its new value", (Object)"new.value", (Object)this.configurationGenerator.getUserConfig().getProperty("alreadyset.property"));
    }

    @Override
    protected void uninstallDone(Task task, Throwable error) throws Exception {
        super.uninstallDone(task, error);
        this.configurationGenerator = ConfigurationGenerator.build();
        Assert.assertTrue((boolean)this.configurationGenerator.init());
        ConfigurationHolder configHolder = this.configurationGenerator.getConfigurationHolder();
        log.info("Install done. nuxeo.conf content:\n{}", (Object)Files.readString(configHolder.getNuxeoConfPath()));
        String templates = this.configurationGenerator.getUserConfig().getProperty("nuxeo.templates");
        Assert.assertNotNull((Object)templates);
        Assert.assertFalse((String)"newtemplate was not removed", (boolean)templates.contains("newtemplate"));
        Assert.assertTrue((String)"oldtemplate was not reset", (boolean)templates.contains("oldtemplate"));
        Assert.assertNull((String)"test.property was not removed", (Object)this.configurationGenerator.getUserConfig().getProperty("test.property"));
        Assert.assertEquals((String)"alreadyset.property was not set to its old value", (Object)"old.value", (Object)this.configurationGenerator.getUserConfig().getProperty("alreadyset.property"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        System.clearProperty("nuxeo.conf");
        System.clearProperty("nuxeo.home");
        System.clearProperty("tomcat.home");
        System.clearProperty("nuxeo.data.dir");
        System.clearProperty("nuxeo.log.dir");
    }
}

