/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone.registry;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.nuxeo.common.Environment;
import org.nuxeo.connect.update.PackageDef;
import org.nuxeo.connect.update.standalone.PackageTestCase;
import org.nuxeo.connect.update.task.update.UpdateManager;
import org.nuxeo.connect.update.xml.XmlWriter;

public abstract class SharedFilesTest
extends PackageTestCase {
    protected File bundles;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Environment.getDefault().getConfig().mkdirs();
        this.bundles = new File(Environment.getDefault().getHome(), "bundles");
        FileUtils.deleteQuietly((File)this.bundles);
        this.bundles.mkdirs();
        this.service.getRegistry().delete();
        FileUtils.deleteDirectory((File)this.service.getBackupDir());
    }

    protected void createFakeBundles() throws Exception {
        FileUtils.writeStringToFile((File)new File(this.bundles, "b1-1.0.jar"), (String)"b1-1.0.jar", (Charset)StandardCharsets.UTF_8);
        FileUtils.writeStringToFile((File)new File(this.bundles, "b2-1.0.jar"), (String)"b2-1.0.jar", (Charset)StandardCharsets.UTF_8);
    }

    public UpdateManager getManager() throws Exception {
        UpdateManager mgr = new UpdateManager(Environment.getDefault().getHome(), this.service.getRegistry());
        mgr.load();
        return mgr;
    }

    protected void ensureBaseVersion() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles("b1-1.0.jar", "b2-1.0.jar");
        File bak = new File(mgr.getBackupRoot(), "bundles");
        if (bak.isDirectory()) {
            Assert.assertEquals((long)0L, (long)bak.list().length);
        }
    }

    public void ensurePkg1() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)2L, (long)mgr.getRegistry().size());
        this.ensureFiles("b1-1.1.jar", "b2-1.1.jar");
    }

    @Deprecated
    public void ensurePkg1AfterBlockingDowngrade() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)2L, (long)mgr.getRegistry().size());
        this.ensureFiles("b1-1.2.jar", "b2-1.1.jar");
    }

    public void ensurePkg2() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)2L, (long)mgr.getRegistry().size());
        this.ensureFiles("b1-1.2.jar", "b2-1.0.jar", "lib2-1.0.jar");
    }

    public void ensurePkg12() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)3L, (long)mgr.getRegistry().size());
        this.ensureFiles("b1-1.2.jar", "b2-1.1.jar", "lib2-1.0.jar");
    }

    public void ensurePkg21() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)3L, (long)mgr.getRegistry().size());
        this.ensureFiles("b1-1.2.jar", "b2-1.1.jar", "lib2-1.0.jar");
    }

    public void ensurePkg21WithDowngrade() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)3L, (long)mgr.getRegistry().size());
        this.ensureFiles("b1-1.1.jar", "b2-1.1.jar", "lib2-1.0.jar");
    }

    protected void ensureFiles(String ... names) throws Exception {
        HashSet<String> set = new HashSet<String>(Arrays.asList(this.bundles.list()));
        Assert.assertEquals((String)("Number of files in " + this.bundles.toString()), (long)names.length, (long)set.size());
        for (String name : names) {
            Assert.assertTrue((String)("Missing file: " + name), (boolean)set.contains(name));
        }
        for (String name : names) {
            Assert.assertEquals((String)("Wrong file content for " + name), (Object)name, (Object)FileUtils.readFileToString((File)new File(this.bundles, name), (Charset)StandardCharsets.UTF_8));
        }
    }

    public class Pkg2
    extends PackageDef {
        public Pkg2() {
            super("pkg2", "5.5", SharedFilesTest.this.service);
        }

        @Override
        protected void updatePackage() throws Exception {
            this.addFile("lib2-1.0.jar", "lib2-1.0.jar");
            this.addFile("b1-1.2.jar", "b1-1.2.jar");
        }

        @Override
        protected void writeInstallCommands(XmlWriter writer) {
            writer.start("update");
            writer.attr("file", "${package.root}/b1-1.2.jar");
            writer.attr("todir", "${env.bundles}");
            writer.attr("allowDowngrade", Boolean.toString(this.allowDowngrade));
            writer.attr("upgradeOnly", Boolean.toString(this.upgradeOnly));
            writer.end();
            writer.start("update");
            writer.attr("file", "${package.root}/lib2-1.0.jar");
            writer.attr("todir", "${env.bundles}");
            writer.attr("allowDowngrade", Boolean.toString(this.allowDowngrade));
            writer.attr("upgradeOnly", Boolean.toString(this.upgradeOnly));
            writer.end();
        }
    }

    public class Pkg1
    extends PackageDef {
        public Pkg1() {
            super("pkg1", "5.5", SharedFilesTest.this.service);
        }

        @Override
        protected void updatePackage() throws Exception {
            this.addFile("bundles/b1-1.1.jar", "b1-1.1.jar");
            this.addFile("bundles/b2-1.1.jar", "b2-1.1.jar");
        }

        @Override
        protected void writeInstallCommands(XmlWriter writer) {
            writer.start("update");
            writer.attr("file", "${package.root}/bundles");
            writer.attr("todir", "${env.bundles}");
            writer.attr("allowDowngrade", Boolean.toString(this.allowDowngrade));
            writer.attr("upgradeOnly", Boolean.toString(this.upgradeOnly));
            writer.end();
        }
    }
}

