/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.cluster;

import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.runtime.cluster.ClusterFeature;
import org.nuxeo.runtime.cluster.ClusterService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={ClusterFeature.class})
public class TestClusterService {
    @Inject
    protected ClusterService clusterService;

    @Test
    public void testNothing() {
        Assert.assertFalse((boolean)this.clusterService.isEnabled());
        Assert.assertNotNull((Object)this.clusterService.getNodeId());
    }

    @Test
    @Deploy(value={"org.nuxeo.runtime.cluster.tests:OSGI-INF/test1.xml"})
    public void testClusterNode() {
        Assert.assertTrue((boolean)this.clusterService.isEnabled());
        Assert.assertEquals((Object)"123", (Object)this.clusterService.getNodeId());
    }

    @Test
    @Deploys(value={@Deploy(value={"org.nuxeo.runtime.cluster.tests:OSGI-INF/test1.xml"}), @Deploy(value={"org.nuxeo.runtime.cluster.tests:OSGI-INF/test-disable.xml"})})
    public void testDisable() {
        Assert.assertFalse((boolean)this.clusterService.isEnabled());
        Assert.assertNotNull((Object)this.clusterService.getNodeId());
    }

    @Test
    @Deploy(value={"org.nuxeo.runtime.cluster.tests:OSGI-INF/test-blank.xml"})
    public void testClusterNodeEnabledBlank() {
        Assert.assertFalse((boolean)this.clusterService.isEnabled());
    }
}

