/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.cluster;

import java.time.Duration;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.core.LogEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.cluster.ClusterFeature;
import org.nuxeo.runtime.cluster.ClusterService;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.test.runner.ConsoleLogLevelThreshold;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LogCaptureFeature;
import org.nuxeo.runtime.test.runner.LogFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={ClusterFeature.class, LogFeature.class, LogCaptureFeature.class})
@Deploy(value={"org.nuxeo.runtime.cluster.tests:OSGI-INF/test-cluster-lock.xml"})
public class TestClusterLockHelper {
    @Inject
    protected LogCaptureFeature.Result logCaptureResult;
    @Inject
    protected ClusterService clusterService;
    @Inject
    protected KeyValueService keyValueService;
    protected KeyValueStore kvStore;

    @Before
    public void setUp() {
        this.kvStore = this.keyValueService.getKeyValueStore("cluster");
    }

    @After
    public void tearDown() {
        this.kvStore.put("mykey", (String)null);
    }

    @Test
    public void testLockFailure() {
        this.kvStore.put("mykey", "mylockinfo");
        try {
            this.runAtomically(() -> {});
            Assert.fail();
        }
        catch (RuntimeServiceException e) {
            Assert.assertEquals((Object)"Failed to acquire lock 'mykey' after 3s, owner: mylockinfo", (Object)e.getMessage());
        }
    }

    @Test
    public void testLockOk() {
        MutableObject lockInfo = new MutableObject();
        this.runAtomically(() -> lockInfo.setValue((Object)this.kvStore.getString("mykey")));
        Assert.assertTrue((String)((String)lockInfo.getValue()), (boolean)Pattern.matches("node=123 time=.*", (CharSequence)lockInfo.getValue()));
    }

    @Test
    @LogCaptureFeature.FilterOn(logLevel="WARN")
    @ConsoleLogLevelThreshold(value="ERROR")
    public void testLockExpire() {
        this.runAtomically(() -> this.kvStore.put("mykey", (String)null));
        List events = this.logCaptureResult.getCaughtEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        LogEvent event = (LogEvent)events.get(0);
        Assert.assertEquals((Object)"WARN", (Object)event.getLevel().toString());
        Assert.assertEquals((Object)"Unlocking 'mykey' but the lock had already expired; consider increasing the try duration for this lock", (Object)event.getMessage().getFormattedMessage());
    }

    @Test
    @LogCaptureFeature.FilterOn(logLevel="ERROR")
    @ConsoleLogLevelThreshold(value="FATAL")
    public void testLockExpireThenStolen() {
        this.runAtomically(() -> this.kvStore.put("mykey", "node=456 time=sometime"));
        List events = this.logCaptureResult.getCaughtEvents();
        Assert.assertEquals((long)1L, (long)events.size());
        LogEvent event = (LogEvent)events.get(0);
        Assert.assertEquals((Object)"ERROR", (Object)event.getLevel().toString());
        Assert.assertEquals((Object)"Failed to unlock 'mykey', the lock expired and has a new owner: node=456 time=sometime; consider increasing the try duration for this lock", (Object)event.getMessage().getFormattedMessage());
    }

    protected void runAtomically(Runnable runnable) {
        Duration duration = Duration.ofSeconds(3L);
        Duration pollDelay = Duration.ofMillis(250L);
        this.clusterService.runAtomically("mykey", duration, pollDelay, runnable);
    }
}

