/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.ResourceAllocationException;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.datasource.DatasourceExceptionSorter;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerConfiguration;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerFactory;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.tranql.connector.AbstractManagedConnection;
import org.tranql.connector.CredentialExtractor;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.ManagedConnectionHandle;
import org.tranql.connector.UserPasswordManagedConnectionFactory;
import org.tranql.connector.jdbc.AutocommitSpecCompliant;
import org.tranql.connector.jdbc.ConnectionHandle;
import org.tranql.connector.jdbc.KnownSQLStateExceptionSorter;
import org.tranql.connector.jdbc.LocalDataSourceWrapper;
import org.tranql.connector.jdbc.TranqlDataSource;
import org.tranql.connector.jdbc.XADataSourceWrapper;

public class PooledDataSourceFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable<?, ?> environment) {
        NuxeoContainer.ConnectionManagerWrapper cm;
        ManagedConnectionFactory mcf;
        Reference ref = (Reference)obj;
        try {
            mcf = this.createFactory(ref, ctx);
            cm = this.createManager(ref, ctx);
        }
        catch (NamingException | ResourceException e) {
            throw new RuntimeException(e);
        }
        class NuxeoDataSource
        extends TranqlDataSource
        implements PooledDataSourceRegistry.PooledDataSource {
            protected NuxeoContainer.ConnectionManagerWrapper wrapper;

            public NuxeoDataSource(ManagedConnectionFactory mcf, NuxeoContainer.ConnectionManagerWrapper wrapper) {
                super(mcf, (ConnectionManager)wrapper);
                this.wrapper = wrapper;
            }

            @Override
            public void dispose() {
                this.wrapper.dispose();
            }

            @Override
            public Connection getConnection(boolean noSharing) throws SQLException {
                if (!noSharing) {
                    return this.getConnection();
                }
                this.wrapper.getManager().enterNoSharing();
                try {
                    Connection connection = this.getConnection();
                    return connection;
                }
                finally {
                    this.wrapper.getManager().exitNoSharing();
                }
            }

            @Override
            public Logger getParentLogger() throws SQLFeatureNotSupportedException {
                throw new SQLFeatureNotSupportedException("not yet available");
            }
        }
        return new NuxeoDataSource(mcf, cm);
    }

    protected NuxeoContainer.ConnectionManagerWrapper createManager(Reference ref, Context ctx) throws ResourceException {
        NuxeoConnectionManagerConfiguration config = NuxeoConnectionManagerFactory.getConfig((Reference)ref);
        String className = ref.getClassName();
        config.setXAMode(XADataSource.class.getName().equals(className));
        return NuxeoContainer.initConnectionManager((NuxeoConnectionManagerConfiguration)config);
    }

    protected ManagedConnectionFactory createFactory(Reference ref, Context ctx) throws NamingException, InvalidPropertyException {
        String className = ref.getClassName();
        if (XADataSource.class.getName().equals(className)) {
            String user = this.refAttribute(ref, "User", "");
            String password = this.refAttribute(ref, "Password", "");
            String name = this.refAttribute(ref, "dataSourceJNDI", null);
            XADataSource ds = (XADataSource)NuxeoContainer.lookup((String)name, XADataSource.class);
            XADataSourceWrapper wrapper = new XADataSourceWrapper(ds);
            wrapper.setUserName(user);
            wrapper.setPassword(password);
            return wrapper;
        }
        if (DataSource.class.getName().equals(className)) {
            String user = this.refAttribute(ref, "username", "");
            if (user.isEmpty() && !(user = this.refAttribute(ref, "user", "")).isEmpty()) {
                LogFactory.getLog(PooledDataSourceFactory.class).warn((Object)"wrong attribute 'user' in datasource descriptor, should use 'username' instead");
            }
            String password = this.refAttribute(ref, "password", "");
            String dsname = this.refAttribute(ref, "dataSourceJNDI", "");
            if (!dsname.isEmpty()) {
                DataSource ds = (DataSource)NuxeoContainer.lookup((String)dsname, DataSource.class);
                LocalDataSourceWrapper wrapper = new LocalDataSourceWrapper(ds);
                wrapper.setUserName(user);
                wrapper.setPassword(password);
                return wrapper;
            }
            String name = this.refAttribute(ref, "driverClassName", null);
            String url = this.refAttribute(ref, "url", null);
            String sqlExceptionSorter = this.refAttribute(ref, "sqlExceptionSorter", DatasourceExceptionSorter.class.getName());
            boolean commitBeforeAutocommit = Boolean.valueOf(this.refAttribute(ref, "commitBeforeAutocommit", "true"));
            JdbcConnectionFactory factory = new JdbcConnectionFactory();
            factory.setDriver(name);
            factory.setUserName(user);
            factory.setPassword(password);
            factory.setConnectionURL(url);
            factory.setExceptionSorterClass(sqlExceptionSorter);
            factory.setCommitBeforeAutocommit(commitBeforeAutocommit);
            return factory;
        }
        throw new IllegalArgumentException("unsupported class " + className);
    }

    protected String refAttribute(Reference ref, String key, String defvalue) {
        RefAddr addr = ref.get(key);
        if (addr == null) {
            if (defvalue == null) {
                throw new IllegalArgumentException(key + " address is mandatory");
            }
            return defvalue;
        }
        return (String)addr.getContent();
    }

    static class JdbcConnectionFactory
    implements UserPasswordManagedConnectionFactory,
    AutocommitSpecCompliant {
        private static final long serialVersionUID = 4317141492511322929L;
        private Driver driver;
        private String url;
        private String user;
        private String password;
        private ExceptionSorter exceptionSorter = new KnownSQLStateExceptionSorter();
        private boolean commitBeforeAutocommit = false;
        private PrintWriter log;

        JdbcConnectionFactory() {
        }

        public Object createConnectionFactory() throws ResourceException {
            throw new NotSupportedException("ConnectionManager is required");
        }

        public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
            return new TranqlDataSource((ManagedConnectionFactory)this, connectionManager);
        }

        public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
            CredentialExtractor credentialExtractor = new CredentialExtractor(subject, connectionRequestInfo, (UserPasswordManagedConnectionFactory)this);
            class ManagedJDBCConnection
            extends AbstractManagedConnection<Connection, ConnectionHandle> {
                final CredentialExtractor credentialExtractor;
                final AbstractManagedConnection.LocalTransactionImpl localTx;
                final AbstractManagedConnection.LocalTransactionImpl localClientTx;
                final boolean commitBeforeAutoCommit;
                Exception fatalError;

                ManagedJDBCConnection(UserPasswordManagedConnectionFactory mcf, Connection physicalConnection, CredentialExtractor credentialExtractor, ExceptionSorter exceptionSorter, boolean commitBeforeAutoCommit) {
                    super((ManagedConnectionFactory)mcf, (Object)physicalConnection, exceptionSorter);
                    this.credentialExtractor = credentialExtractor;
                    this.localTx = new AbstractManagedConnection.LocalTransactionImpl((AbstractManagedConnection)this, true);
                    this.localClientTx = new AbstractManagedConnection.LocalTransactionImpl((AbstractManagedConnection)this, false);
                    this.commitBeforeAutoCommit = commitBeforeAutoCommit;
                }

                public boolean matches(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceAdapterInternalException {
                    return this.credentialExtractor.matches(subject, connectionRequestInfo, (UserPasswordManagedConnectionFactory)mcf);
                }

                public LocalTransaction getClientLocalTransaction() {
                    return this.localClientTx;
                }

                public LocalTransaction getLocalTransaction() throws ResourceException {
                    return this.localTx;
                }

                protected void localTransactionStart(boolean isSPI) throws ResourceException {
                    try {
                        ((Connection)this.physicalConnection).setAutoCommit(false);
                    }
                    catch (SQLException e) {
                        throw new LocalTransactionException("Unable to disable autoCommit", (Throwable)e);
                    }
                    super.localTransactionStart(isSPI);
                }

                protected void localTransactionCommit(boolean isSPI) throws ResourceException {
                    try {
                        if (this.commitBeforeAutoCommit) {
                            ((Connection)this.physicalConnection).commit();
                        }
                    }
                    catch (SQLException e) {
                        block13: {
                            try {
                                ((Connection)this.physicalConnection).rollback();
                            }
                            catch (SQLException e1) {
                                if (this.log == null) break block13;
                                e.printStackTrace(this.log);
                            }
                        }
                        throw new LocalTransactionException("Unable to commit", (Throwable)e);
                    }
                    finally {
                        try {
                            ((Connection)this.physicalConnection).setAutoCommit(true);
                        }
                        catch (SQLException e) {
                            LogFactory.getLog(PooledDataSourceFactory.class).error((Object)"Unable to enable autoCommit after rollback", (Throwable)e);
                        }
                    }
                    super.localTransactionCommit(isSPI);
                }

                protected void localTransactionRollback(boolean isSPI) throws ResourceException {
                    Connection c = (Connection)this.physicalConnection;
                    try {
                        c.rollback();
                    }
                    catch (SQLException e) {
                        throw new LocalTransactionException("Unable to rollback", (Throwable)e);
                    }
                    super.localTransactionRollback(isSPI);
                    try {
                        c.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        throw new ResourceAdapterInternalException("Unable to enable autoCommit after rollback", (Throwable)e);
                    }
                }

                public XAResource getXAResource() throws ResourceException {
                    throw new NotSupportedException("XAResource not available from a LocalTransaction connection");
                }

                protected void closePhysicalConnection() throws ResourceException {
                    Connection c = (Connection)this.physicalConnection;
                    try {
                        c.close();
                    }
                    catch (SQLException e) {
                        throw new ResourceAdapterInternalException("Error attempting to destroy managed connection", (Throwable)e);
                    }
                }

                public ManagedConnectionMetaData getMetaData() throws ResourceException {
                    throw new NotSupportedException("no metadata available yet");
                }

                public void connectionError(Exception e) {
                    if (this.fatalError != null) {
                        return;
                    }
                    if (this.isFatal(e)) {
                        this.fatalError = e;
                        if (JdbcConnectionFactory.this.exceptionSorter.rollbackOnFatalException()) {
                            if (TransactionHelper.isTransactionActive()) {
                                TransactionHelper.setTransactionRollbackOnly();
                            } else {
                                this.attemptRollback();
                            }
                        }
                    }
                }

                public void cleanup() throws ResourceException {
                    super.cleanup();
                    if (this.fatalError != null) {
                        ResourceException error = new ResourceException(String.format("fatal error occurred on %s, destroying", new Object[]{this}), (Throwable)this.fatalError);
                        LogFactory.getLog(ManagedJDBCConnection.class).warn((Object)error.getMessage(), error.getCause());
                        throw error;
                    }
                }

                protected boolean isFatal(Exception e) {
                    if (JdbcConnectionFactory.this.exceptionSorter.isExceptionFatal(e)) {
                        return true;
                    }
                    try {
                        return !((Connection)this.physicalConnection).isValid(10);
                    }
                    catch (SQLException cause) {
                        return false;
                    }
                    catch (LinkageError cause) {
                        return false;
                    }
                }

                protected void attemptRollback() {
                    try {
                        ((Connection)this.physicalConnection).rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }

                public String toString() {
                    return super.toString() + ". jdbc=" + this.physicalConnection;
                }
            }
            return new ManagedJDBCConnection(this, this.getPhysicalConnection(subject, credentialExtractor), credentialExtractor, this.exceptionSorter, this.commitBeforeAutocommit);
        }

        protected Connection getPhysicalConnection(Subject subject, CredentialExtractor credentialExtractor) throws ResourceException {
            String password;
            try {
                if (!this.driver.acceptsURL(this.url)) {
                    throw new ResourceAdapterInternalException("JDBC Driver cannot handle url: " + this.url);
                }
            }
            catch (SQLException e) {
                throw new ResourceAdapterInternalException("JDBC Driver rejected url: " + this.url);
            }
            Properties info = new Properties();
            String user = credentialExtractor.getUserName();
            if (user != null) {
                info.setProperty("user", user);
            }
            if ((password = credentialExtractor.getPassword()) != null) {
                info.setProperty("password", password);
            }
            try {
                return this.driver.connect(this.url, info);
            }
            catch (SQLException e) {
                throw new ResourceAllocationException("Unable to obtain physical connection to " + this.url, (Throwable)e);
            }
        }

        public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
            for (Object o : set) {
                ManagedConnectionHandle mc;
                if (!(o instanceof ManagedConnectionHandle) || !(mc = (ManagedConnectionHandle)o).matches((ManagedConnectionFactory)this, subject, connectionRequestInfo)) continue;
                return mc;
            }
            return null;
        }

        public PrintWriter getLogWriter() {
            return this.log;
        }

        public void setLogWriter(PrintWriter log) {
            this.log = log;
        }

        void setDriver(String driver) throws InvalidPropertyException {
            if (driver == null || driver.length() == 0) {
                throw new InvalidPropertyException("Empty driver class name");
            }
            try {
                Class<?> driverClass = Class.forName(driver);
                this.driver = (Driver)driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidPropertyException("Unable to load driver class: " + driver, (Throwable)e);
            }
            catch (ReflectiveOperationException e) {
                throw new InvalidPropertyException("Unable to instantiate driver class: " + driver, (Throwable)e);
            }
            catch (ClassCastException e) {
                throw new InvalidPropertyException("Class is not a " + Driver.class.getName() + ": " + driver, (Throwable)e);
            }
        }

        void setConnectionURL(String url) throws InvalidPropertyException {
            if (url == null || url.length() == 0) {
                throw new InvalidPropertyException("Empty connection URL");
            }
            this.url = url;
        }

        public String getUserName() {
            return this.user;
        }

        void setUserName(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        void setPassword(String password) {
            this.password = password;
        }

        public Boolean isCommitBeforeAutocommit() {
            return this.commitBeforeAutocommit;
        }

        void setCommitBeforeAutocommit(Boolean commitBeforeAutocommit) {
            this.commitBeforeAutocommit = commitBeforeAutocommit != null && commitBeforeAutocommit != false;
        }

        void setExceptionSorterClass(String className) throws InvalidPropertyException {
            if (className == null || className.length() == 0) {
                throw new InvalidPropertyException("Empty class name");
            }
            try {
                Class<?> clazz = Class.forName(className);
                this.exceptionSorter = (ExceptionSorter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidPropertyException("Unable to load class: " + className, (Throwable)e);
            }
            catch (ReflectiveOperationException e) {
                throw new InvalidPropertyException("Unable to instantiate class: " + className, (Throwable)e);
            }
            catch (ClassCastException e) {
                throw new InvalidPropertyException("Class is not a " + ExceptionSorter.class.getName() + ": " + this.driver, (Throwable)e);
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof JdbcConnectionFactory) {
                JdbcConnectionFactory other = (JdbcConnectionFactory)obj;
                return this.url == other.url || this.url != null && this.url.equals(other.url);
            }
            return false;
        }

        public int hashCode() {
            return this.url == null ? 0 : this.url.hashCode();
        }

        public String toString() {
            return "Pooled JDBC Driver Connection Factory [" + this.user + "@" + this.url + "]";
        }
    }
}

