/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor.template;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.runtime.deployment.preprocessor.template.TemplateContribution;

public class Template {
    private static final Log log = LogFactory.getLog(Template.class);
    public static final String BEGIN = "BEGIN";
    public static final String END = "END";
    final LinkedHashMap<String, Part> parts = new LinkedHashMap();

    public void addPart(String name, String text) {
        this.parts.put(name, new Part(name, text));
    }

    public void update(TemplateContribution tc, Map<String, String> ctx) {
        String content = tc.getContent();
        content = new TextTemplate(ctx).processText(content);
        if (tc.isAppending()) {
            this.appendText(tc.getMarker(), content);
        } else if (tc.isPrepending()) {
            this.prependText(tc.getMarker(), content);
        } else if (tc.isReplacing()) {
            this.replaceText(tc.getMarker(), content);
        }
    }

    public void appendText(String marker, String text) {
        Part part = this.parts.get(marker);
        if (part != null) {
            part.append(text);
        } else {
            log.debug((Object)("Could not find marker: " + marker));
        }
    }

    public void prependText(String marker, String text) {
        Part part = this.parts.get(marker);
        if (part != null) {
            part.prepend(text);
        } else {
            log.debug((Object)("Could not find marker: " + marker));
        }
    }

    public void replaceText(String marker, String text) {
        Part part = this.parts.get(marker);
        if (part != null) {
            part.replace(text);
        } else {
            log.debug((Object)("Could not find marker: " + marker));
        }
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (Part part : this.parts.values()) {
            sb.append((CharSequence)part.text);
        }
        return sb.toString();
    }

    static class Part {
        public final String name;
        public final StringBuilder text;
        public final int offset;

        Part(String name, String text) {
            this.name = name;
            this.text = text == null ? new StringBuilder() : new StringBuilder(text);
            this.offset = this.text.length();
        }

        public void append(String aText) {
            this.text.append(aText);
        }

        public void prepend(String aText) {
            this.text.insert(this.offset, aText);
        }

        public void replace(String aText) {
            this.text.replace(this.offset, this.text.length(), aText);
        }

        public String getText() {
            return this.text.toString();
        }

        public String getName() {
            return this.name;
        }
    }
}

