/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.metrics.MetricsReporter;
import org.nuxeo.runtime.model.Descriptor;

@XObject(value="reporter")
public class MetricsReporterDescriptor
implements Descriptor {
    @XNode(value="@enabled")
    protected boolean isEnabled = true;
    @XNode(value="@name")
    public String name;
    @XNode(value="@class")
    public Class<? extends MetricsReporter> klass;
    @XNode(value="@pollInterval")
    protected long pollInterval = 60L;
    @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> options = new HashMap<String, String>();

    public long getPollInterval() {
        return this.pollInterval;
    }

    public String getId() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public MetricsReporter newInstance() {
        if (!MetricsReporter.class.isAssignableFrom(this.klass)) {
            throw new IllegalArgumentException("Cannot create reporter: " + this.getId() + ", class must implement MetricsReporter");
        }
        try {
            MetricsReporter ret = this.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ret.init(this.getPollInterval(), this.getOptions());
            return ret;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Cannot create reporter: " + this.getId(), e);
        }
    }
}

