/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics.reporter;

import io.dropwizard.metrics5.MetricAttribute;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricRegistry;
import io.opencensus.common.Duration;
import io.opencensus.exporter.trace.datadog.DatadogTraceConfiguration;
import io.opencensus.exporter.trace.datadog.DatadogTraceExporter;
import java.net.MalformedURLException;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.utils.DurationUtils;
import org.nuxeo.runtime.metrics.AbstractMetricsReporter;

public class DatadogTraceReporter
extends AbstractMetricsReporter {
    private static final Logger log = LogManager.getLogger(DatadogTraceReporter.class);
    protected static final String TYPE_OPTION = "type";
    protected static final String DEFAULT_TYPE = "web";
    protected boolean activated;

    @Override
    public void start(MetricRegistry registry, MetricFilter filter, Set<MetricAttribute> deniedExpansions) {
        log.warn("Creating Datadog Trace reporter");
        String url = (String)this.options.get("url");
        String service = this.options.getOrDefault("service", "nuxeo");
        String type = this.options.getOrDefault(TYPE_OPTION, DEFAULT_TYPE);
        Duration timeout = Duration.create((long)DurationUtils.parsePositive((String)((String)this.options.get("timeout")), (java.time.Duration)DEFAULT_TIMEOUT).getSeconds(), (int)0);
        DatadogTraceConfiguration config = DatadogTraceConfiguration.builder().setAgentEndpoint(url).setService(service).setType(type).setDeadline(timeout).build();
        try {
            DatadogTraceExporter.createAndRegister((DatadogTraceConfiguration)config);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        this.activated = true;
        this.enableTracing();
    }

    @Override
    public void stop() {
        log.debug("Stop reporting");
        if (this.activated) {
            DatadogTraceExporter.unregister();
            this.activated = false;
        }
    }
}

